/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.I18n;

public class DefaultProxySelector
extends ProxySelector {
    private static boolean JVM_WILL_USE_SYSTEM_PROXIES = false;
    private ProxyPreferencesPanel.ProxyPolicy proxyPolicy;
    private InetSocketAddress httpProxySocketAddress;
    private InetSocketAddress socksProxySocketAddress;
    private ProxySelector delegate;

    public static boolean willJvmRetrieveSystemProxies() {
        return JVM_WILL_USE_SYSTEM_PROXIES;
    }

    public DefaultProxySelector(ProxySelector proxySelector) {
        this.delegate = proxySelector;
        this.initFromPreferences();
    }

    protected int parseProxyPortValue(String string, String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Main.error(I18n.tr("Unexpected format for port number in in preference ''{0}''. Got ''{1}''.", string, string2));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        if (n <= 0 || n > 65535) {
            Main.error(I18n.tr("Illegal port number in preference ''{0}''. Got {1}.", string, n));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        return n;
    }

    public void initFromPreferences() {
        String string = Main.pref.get("proxy.policy");
        if (string.length() == 0) {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
        } else {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.fromName(string);
            if (this.proxyPolicy == null) {
                Main.warn(I18n.tr("Unexpected value for preference ''{0}'' found. Got ''{1}''. Will use no proxy.", "proxy.policy", string));
                this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
            }
        }
        String string2 = Main.pref.get("proxy.http.host", null);
        int n = this.parseProxyPortValue("proxy.http.port", Main.pref.get("proxy.http.port", null));
        this.httpProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_HTTP_PROXY)) {
            if (string2 != null && !string2.trim().isEmpty() && n > 0) {
                this.httpProxySocketAddress = new InetSocketAddress(string2, n);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for HTTP proxy. Got host ''{0}'' and port ''{1}''.", string2, n));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
        string2 = Main.pref.get("proxy.socks.host", null);
        n = this.parseProxyPortValue("proxy.socks.port", Main.pref.get("proxy.socks.port", null));
        this.socksProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_SOCKS_PROXY)) {
            if (string2 != null && !string2.trim().isEmpty() && n > 0) {
                this.socksProxySocketAddress = new InetSocketAddress(string2, n);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for SOCKS proxy. Got host ''{0}'' and port ''{1}''.", string2, n));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        Main.error(I18n.tr("Connection to proxy ''{0}'' for URI ''{1}'' failed. Exception was: {2}", socketAddress.toString(), uRI.toString(), iOException.toString()));
    }

    @Override
    public List<Proxy> select(URI uRI) {
        switch (this.proxyPolicy) {
            case USE_SYSTEM_SETTINGS: {
                if (!JVM_WILL_USE_SYSTEM_PROXIES) {
                    Main.warn(I18n.tr("The JVM is not configured to lookup proxies from the system settings. The property ''java.net.useSystemProxies'' was missing at startup time.  Will not use a proxy.", new Object[0]));
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                List<Proxy> list = this.delegate.select(uRI);
                return list;
            }
            case NO_PROXY: {
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            case USE_HTTP_PROXY: {
                if (this.httpProxySocketAddress == null) {
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, this.httpProxySocketAddress);
                return Collections.singletonList(proxy);
            }
            case USE_SOCKS_PROXY: {
                if (this.socksProxySocketAddress == null) {
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, this.socksProxySocketAddress);
                return Collections.singletonList(proxy);
            }
        }
        return null;
    }

    static {
        String string = System.getProperty("java.net.useSystemProxies");
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            JVM_WILL_USE_SYSTEM_PROXIES = true;
        }
    }
}

