/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.Utils;

public abstract class CacheCustomContent<T extends Throwable> {
    public static final int INTERVAL_ALWAYS = -1;
    public static final int INTERVAL_HOURLY = 3600;
    public static final int INTERVAL_DAILY = 86400;
    public static final int INTERVAL_WEEKLY = 604800;
    public static final int INTERVAL_MONTHLY = 2419200;
    public static final int INTERVAL_NEVER = Integer.MAX_VALUE;
    private byte[] data = null;
    private final String ident;
    private final File path;
    private final int updateInterval;

    protected abstract byte[] updateData() throws T;

    protected boolean isCacheValid() {
        return true;
    }

    public CacheCustomContent(String string, int n) {
        this.ident = string;
        this.updateInterval = n;
        this.path = new File(Main.pref.getCacheDirectory(), string);
    }

    public byte[] updateIfRequired() throws T {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < System.currentTimeMillis() / 1000L || !this.isCacheValid()) {
            return this.updateForce();
        }
        return this.getData();
    }

    public String updateIfRequiredString() throws T {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < System.currentTimeMillis() / 1000L || !this.isCacheValid()) {
            return this.updateForceString();
        }
        return this.getDataString();
    }

    public byte[] updateForce() throws T {
        this.data = this.updateData();
        this.saveToDisk();
        Main.pref.putInteger("cache." + this.ident, (int)(System.currentTimeMillis() / 1000L));
        return this.data;
    }

    public String updateForceString() throws T {
        this.updateForce();
        try {
            return new String(this.data, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public byte[] getData() throws T {
        if (this.data == null) {
            this.loadFromDisk();
        }
        return this.data;
    }

    public String getDataString() throws T {
        try {
            return new String(this.getData(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromDisk() throws T {
        if (Main.applet) {
            this.data = this.updateForce();
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.path));
            this.data = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(this.data);
        }
        catch (IOException iOException) {
            try {
                this.data = this.updateForce();
            }
            catch (Throwable throwable) {
                Utils.close(bufferedInputStream);
                throw throwable;
            }
            Utils.close(bufferedInputStream);
            return;
        }
        Utils.close(bufferedInputStream);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk() {
        if (Main.applet) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.path));
            bufferedOutputStream.write(this.data);
            bufferedOutputStream.flush();
            Utils.close(bufferedOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Utils.close(bufferedOutputStream);
        }
    }

    public void flushData() {
        this.data = null;
    }
}

