/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    protected final double lat1;
    protected final double lon1;
    protected final double lat2;
    protected final double lon2;
    protected final boolean crosses180th;

    public BoundingBoxDownloader(Bounds bounds) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "downloadArea");
        this.lat1 = bounds.getMinLat();
        this.lon1 = bounds.getMinLon();
        this.lat2 = bounds.getMaxLat();
        this.lon2 = bounds.getMaxLon();
        this.crosses180th = bounds.crosses180thMeridian();
    }

    private GpxData downloadRawGps(String string, ProgressMonitor progressMonitor) throws IOException, OsmTransferException, SAXException {
        boolean bl = false;
        GpxData gpxData = null;
        int n = 0;
        while (!bl) {
            progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", n * 5000, (n + 1) * 5000));
            InputStream inputStream = this.getInputStream(string + n, progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) break;
            progressMonitor.setTicks(0);
            GpxReader gpxReader = new GpxReader(inputStream);
            this.gpxParsedProperly = gpxReader.parse(false);
            GpxData gpxData2 = gpxReader.getGpxData();
            if (gpxData == null) {
                gpxData = gpxData2;
            } else if (gpxData2.hasTrackPoints()) {
                gpxData.mergeFrom(gpxData2);
            } else {
                bl = true;
            }
            Utils.close(inputStream);
            this.activeConnection = null;
            ++n;
        }
        gpxData.fromServer = true;
        return gpxData;
    }

    @Override
    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
            if (this.crosses180th) {
                GpxData gpxData = this.downloadRawGps("trackpoints?bbox=" + this.lon1 + "," + this.lat1 + ",180.0," + this.lat2 + "&page=", progressMonitor);
                gpxData.mergeFrom(this.downloadRawGps("trackpoints?bbox=-180.0," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=", progressMonitor));
                GpxData gpxData2 = gpxData;
                return gpxData2;
            }
            GpxData gpxData = this.downloadRawGps("trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=", progressMonitor);
            return gpxData;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException("Illegal characters within the HTTP-header response.", illegalArgumentException);
        }
        catch (IOException iOException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (RuntimeException runtimeException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw runtimeException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected String getRequestForBbox(double d, double d2, double d3, double d4) {
        return "map?bbox=" + d + "," + d2 + "," + d3 + "," + d4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSet parseOsm(ProgressMonitor var1_1) throws OsmTransferException {
        var1_1.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 10);
        var2_2 = null;
        try {
            var3_3 = null;
            var1_1.indeterminateSubTask(null);
            if (!this.crosses180th) ** GOTO lbl43
            var2_2 = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, 180.0, this.lat2), var1_1.createSubTaskMonitor(9, false));
            if (var2_2 == null) {
                var4_6 = null;
                var1_1.finishTask();
            }
            ** GOTO lbl-1000
        }
        catch (OsmTransferException var3_4) {
            try {
                throw var3_4;
                catch (Exception var3_5) {
                    throw new OsmTransferException(var3_5);
                }
            }
            catch (Throwable var6_11) {
                var1_1.finishTask();
                Utils.close(var2_2);
                this.activeConnection = null;
                throw var6_11;
            }
        }
        Utils.close(var2_2);
        this.activeConnection = null;
        return var4_6;
lbl-1000:
        // 1 sources

        {
            var3_3 = OsmReader.parseDataSet(var2_2, var1_1.createSubTaskMonitor(1, false));
            var2_2 = this.getInputStream(this.getRequestForBbox(-180.0, this.lat1, this.lon2, this.lat2), var1_1.createSubTaskMonitor(9, false));
            if (var2_2 != null) ** GOTO lbl-1000
            var4_7 = null;
            var1_1.finishTask();
        }
        Utils.close(var2_2);
        this.activeConnection = null;
        return var4_7;
lbl-1000:
        // 1 sources

        {
            var4_8 = OsmReader.parseDataSet(var2_2, var1_1.createSubTaskMonitor(1, false));
            if (var4_8 != null) ** GOTO lbl-1000
            var5_10 = null;
            var1_1.finishTask();
        }
        Utils.close(var2_2);
        this.activeConnection = null;
        return var5_10;
lbl-1000:
        // 1 sources

        {
            var3_3.mergeFrom(var4_8);
            ** GOTO lbl51
lbl43:
            // 1 sources

            var2_2 = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, this.lon2, this.lat2), var1_1.createSubTaskMonitor(9, false));
            if (var2_2 != null) ** GOTO lbl-1000
            var4_9 = null;
            var1_1.finishTask();
        }
        Utils.close(var2_2);
        this.activeConnection = null;
        return var4_9;
lbl-1000:
        // 1 sources

        {
            var3_3 = OsmReader.parseDataSet(var2_2, var1_1.createSubTaskMonitor(1, false));
lbl51:
            // 2 sources

            var4_8 = var3_3;
            var1_1.finishTask();
        }
        Utils.close(var2_2);
        this.activeConnection = null;
        return var4_8;
    }
}

