/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.text.View;

public class JMultilineLabel
extends JLabel {
    private int maxWidth = Integer.MAX_VALUE;
    private Rectangle oldbounds = null;
    private Dimension oldPreferred = null;

    public JMultilineLabel(String string) {
        String string2 = string.trim().replaceAll("\n", "<br>");
        if (!string2.startsWith("<html>")) {
            string2 = "<html>" + string2 + "</html>";
        }
        super.setText(string2);
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getBounds().equals(this.oldbounds) && this.oldPreferred != null) {
            return this.oldPreferred;
        }
        this.oldbounds = this.getBounds();
        Dimension dimension = super.getPreferredSize();
        int n = Math.min(dimension.width, this.maxWidth);
        View view = (View)super.getClientProperty("html");
        if (view == null) {
            return dimension;
        }
        view.setSize(n, 0.0f);
        int n2 = (int)Math.ceil(view.getPreferredSpan(0));
        int n3 = (int)Math.ceil(view.getPreferredSpan(1));
        this.oldPreferred = new Dimension(n2, n3);
        return this.oldPreferred;
    }
}

