/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;

public class ComboBoxHistory
extends DefaultComboBoxModel
implements Iterable<AutoCompletionListItem> {
    private int maxSize = 10;
    private List<HistoryChangedListener> listeners = new ArrayList<HistoryChangedListener>();

    public ComboBoxHistory(int n) {
        this.maxSize = n;
    }

    @Override
    public void addElement(Object object) {
        if (object instanceof String) {
            object = new AutoCompletionListItem((String)object);
        }
        String string = ((AutoCompletionListItem)object).getValue();
        for (int i = 0; i < this.getSize(); ++i) {
            String string2 = ((AutoCompletionListItem)this.getElementAt(i)).getValue();
            if (!string2.equals(string)) continue;
            this.removeElementAt(i);
        }
        this.insertElementAt(object, 0);
        if (this.getSize() > this.maxSize) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.setSelectedItem(object);
        this.fireHistoryChanged();
    }

    @Override
    public Iterator<AutoCompletionListItem> iterator() {
        return new Iterator<AutoCompletionListItem>(){
            private int position = -1;

            @Override
            public void remove() {
                ComboBoxHistory.this.removeElementAt(this.position);
            }

            @Override
            public boolean hasNext() {
                return this.position < ComboBoxHistory.this.getSize() - 1 && ComboBoxHistory.this.getSize() > 0;
            }

            @Override
            public AutoCompletionListItem next() {
                ++this.position;
                return (AutoCompletionListItem)ComboBoxHistory.this.getElementAt(this.position);
            }
        };
    }

    public void setItemsAsString(List<String> list) {
        this.removeAllElements();
        for (int i = list.size() - 1; i >= 0; --i) {
            this.addElement(new AutoCompletionListItem(list.get(i)));
        }
    }

    public List<String> asStringList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.maxSize);
        for (AutoCompletionListItem autoCompletionListItem : this) {
            arrayList.add(autoCompletionListItem.getValue());
        }
        return arrayList;
    }

    public void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.listeners.add(historyChangedListener);
    }

    public void removeHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.listeners.remove(historyChangedListener);
    }

    private void fireHistoryChanged() {
        for (HistoryChangedListener historyChangedListener : this.listeners) {
            historyChangedListener.historyChanged(this.asStringList());
        }
    }
}

