/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;

public class BasicAuthenticationPreferencesPanel
extends JPanel {
    private JosmTextField tfOsmUserName;
    private JosmPasswordField tfOsmPassword;
    private JPanel decorationPanel;

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("OSM username:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfOsmUserName = new JosmTextField();
        this.add((Component)this.tfOsmUserName, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmUserName);
        UserNameValidator userNameValidator = new UserNameValidator(this.tfOsmUserName);
        userNameValidator.validate();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("OSM password:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfOsmPassword = new JosmPasswordField();
        this.add((Component)this.tfOsmPassword, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmPassword);
        this.tfOsmPassword.setToolTipText(I18n.tr("Please enter your OSM password", new Object[0]));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.decorationPanel = new JPanel(new BorderLayout());
        this.add((Component)this.decorationPanel, gridBagConstraints);
    }

    public BasicAuthenticationPreferencesPanel() {
        this.build();
    }

    public void initFromPreferences() {
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            this.decorationPanel.removeAll();
            this.decorationPanel.add(credentialsManager.getPreferencesDecorationPanel(), "Center");
            PasswordAuthentication passwordAuthentication = credentialsManager.lookup(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost());
            if (passwordAuthentication == null) {
                this.tfOsmUserName.setText("");
                this.tfOsmPassword.setText("");
            } else {
                this.tfOsmUserName.setText(passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName());
                this.tfOsmPassword.setText(passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword()));
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            credentialsAgentException.printStackTrace();
            Main.warn(I18n.tr("Failed to retrieve OSM credentials from credential manager.", new Object[0]));
            Main.warn(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
            this.tfOsmUserName.setText("");
            this.tfOsmPassword.setText("");
        }
    }

    public void saveToPreferences() {
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.tfOsmUserName.getText().trim(), this.tfOsmPassword.getPassword());
            credentialsManager.store(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost(), passwordAuthentication);
        }
        catch (CredentialsAgentException credentialsAgentException) {
            credentialsAgentException.printStackTrace();
            Main.warn(I18n.tr("Failed to save OSM credentials to credential manager.", new Object[0]));
            Main.warn(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
        }
    }

    public void clearPassword() {
        this.tfOsmPassword.setText("");
    }
}

