/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.actionsupport.LogShowDialog;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.ExportProfileAction;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.preferences.advanced.PreferencesTable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class AdvancedPreference
extends DefaultTabPreferenceSetting {
    protected List<PrefEntry> allData;
    protected List<PrefEntry> displayData = new ArrayList<PrefEntry>();
    protected JosmTextField txtFilter;
    protected PreferencesTable table;
    private Comparator<PrefEntry> customComparator = new Comparator<PrefEntry>(){

        @Override
        public int compare(PrefEntry prefEntry, PrefEntry prefEntry2) {
            if (prefEntry.isChanged() && !prefEntry2.isChanged()) {
                return -1;
            }
            if (prefEntry2.isChanged() && !prefEntry.isChanged()) {
                return 1;
            }
            if (!prefEntry.isDefault() && prefEntry2.isDefault()) {
                return -1;
            }
            if (!prefEntry2.isDefault() && prefEntry.isDefault()) {
                return 1;
            }
            return prefEntry.compareTo(prefEntry2);
        }
    };
    Map<String, String> profileTypes = new LinkedHashMap<String, String>();

    private AdvancedPreference() {
        super("advanced", I18n.tr("Advanced Preferences", new Object[0]), I18n.tr("Setting Preference entries directly. Use with caution!", new Object[0]));
    }

    @Override
    public boolean isExpert() {
        return true;
    }

    @Override
    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        this.txtFilter = new JosmTextField();
        JLabel jLabel = new JLabel(I18n.tr("Search: ", new Object[0]));
        jLabel.setLabelFor(this.txtFilter);
        preferencePanel.add(jLabel);
        preferencePanel.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.applyFilter();
            }
        });
        this.readPreferences(Main.pref);
        this.applyFilter();
        this.table = new PreferencesTable(this.displayData);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        preferencePanel.add((Component)jScrollPane, GBC.eol().fill(1));
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
        preferencePanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        preferencePanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefEntry prefEntry = AdvancedPreference.this.table.addPreference(preferenceTabbedPane);
                if (prefEntry != null) {
                    AdvancedPreference.this.allData.add(prefEntry);
                    Collections.sort(AdvancedPreference.this.allData);
                    AdvancedPreference.this.applyFilter();
                }
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Edit", new Object[0]));
        preferencePanel.add((Component)jButton2, GBC.std().insets(5, 5, 5, 0));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AdvancedPreference.this.table.editPreference(preferenceTabbedPane);
                if (bl) {
                    AdvancedPreference.this.applyFilter();
                }
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Reset", new Object[0]));
        preferencePanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.table.resetPreferences(preferenceTabbedPane);
            }
        });
        JButton jButton4 = new JButton(I18n.tr("Read from file", new Object[0]));
        preferencePanel.add((Component)jButton4, GBC.std().insets(5, 5, 0, 0));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.readPreferencesFromXML();
            }
        });
        JButton jButton5 = new JButton(I18n.tr("Export selected items", new Object[0]));
        preferencePanel.add((Component)jButton5, GBC.std().insets(5, 5, 0, 0));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.exportSelectedToXML();
            }
        });
        final JButton jButton6 = new JButton(I18n.tr("More...", new Object[0]));
        preferencePanel.add((Component)jButton6, GBC.std().insets(5, 5, 0, 0));
        jButton6.addActionListener(new ActionListener(){
            JPopupMenu menu;
            {
                this.menu = AdvancedPreference.this.buildPopupMenu();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.menu.show(jButton6, 0, 0);
            }
        });
    }

    private void readPreferences(Preferences preferences) {
        Map<String, Preferences.Setting> map;
        Map<String, Preferences.Setting> map2 = Main.pref.getAllSettings();
        Map<String, Preferences.Setting> map3 = preferences.getAllDefaults();
        map2.remove("osm-server.password");
        map3.remove("osm-server.password");
        if (preferences != Main.pref) {
            map = preferences.getAllSettings();
            Preferences.Setting setting = map2.get("plugins");
            if (setting != null) {
                map.put("plugins", setting);
            }
        } else {
            map = map2;
        }
        this.allData = this.prepareData(map, map2, map3);
    }

    private File[] askUserForCustomSettingsFiles(boolean bl, String string) {
        FileFilter fileFilter;
        JFileChooser jFileChooser = DiskAccessAction.createAndOpenFileChooser(!bl, !bl, string, fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return I18n.tr("JOSM custom settings files (*.xml)", new Object[0]);
            }
        }, 0, "customsettings.lastDirectory");
        if (jFileChooser != null) {
            File[] fileArray;
            if (jFileChooser.isMultiSelectionEnabled()) {
                fileArray = jFileChooser.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = jFileChooser.getSelectedFile();
            }
            File[] fileArray3 = fileArray;
            if (fileArray3.length == 1 && !fileArray3[0].getName().contains(".")) {
                fileArray3[0] = new File(fileArray3[0].getAbsolutePath() + ".xml");
            }
            return fileArray3;
        }
        return new File[0];
    }

    private void exportSelectedToXML() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (PrefEntry prefEntry : this.table.getSelectedItems()) {
            if (!(prefEntry.getValue() instanceof Preferences.StringSetting)) {
                bl = true;
            }
            if (prefEntry.isDefault()) continue;
            arrayList.add(prefEntry.getKey());
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select some preference keys not marked as default", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        File[] fileArray = this.askUserForCustomSettingsFiles(true, I18n.tr("Export preferences keys to JOSM customization file", new Object[0]));
        if (fileArray.length == 0) {
            return;
        }
        int n = 0;
        if (bl) {
            n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("What to do with preference lists when this file is to be imported?", new Object[0]), I18n.tr("Question", new Object[0]), 1, 3, null, new String[]{I18n.tr("Append preferences from file to existing values", new Object[0]), I18n.tr("Replace existing values", new Object[0])}, 0);
        }
        CustomConfigurator.exportPreferencesKeysToFile(fileArray[0].getAbsolutePath(), n == 0, arrayList);
    }

    private void readPreferencesFromXML() {
        File[] fileArray = this.askUserForCustomSettingsFiles(false, I18n.tr("Open JOSM customization file", new Object[0]));
        if (fileArray.length == 0) {
            return;
        }
        Preferences preferences = CustomConfigurator.clonePreferences(Main.pref);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (File file : fileArray) {
            CustomConfigurator.readXML(file, preferences);
            stringBuilder.append(CustomConfigurator.getLog());
        }
        stringBuilder.append("</html>");
        String string = stringBuilder.toString().replace("\n", "<br/>");
        new LogShowDialog(I18n.tr("Import log", new Object[0]), I18n.tr("<html>Here is file import summary. <br/>You can reject preferences changes by pressing \"Cancel\" in preferences dialog <br/>To activate some changes JOSM restart may be needed.</html>", new Object[0]), string).showDialog();
        this.readPreferences(preferences);
        Collections.sort(this.allData, this.customComparator);
        this.applyFilter();
    }

    private List<PrefEntry> prepareData(Map<String, Preferences.Setting> map, Map<String, Preferences.Setting> map2, Map<String, Preferences.Setting> map3) {
        Preferences.Setting setting;
        Object object;
        ArrayList<PrefEntry> arrayList = new ArrayList<PrefEntry>();
        for (Map.Entry<String, Preferences.Setting> entry : map.entrySet()) {
            object = entry.getValue();
            setting = map2.get(entry.getKey());
            Preferences.Setting setting2 = map3.get(entry.getKey());
            if (setting2 == null) {
                setting2 = object.getNullInstance();
            }
            PrefEntry prefEntry = new PrefEntry(entry.getKey(), (Preferences.Setting)object, setting2, false);
            if (!Preferences.isEqual(setting, object)) {
                prefEntry.markAsChanged();
            }
            arrayList.add(prefEntry);
        }
        for (Map.Entry<String, Preferences.Setting> entry : map3.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            object = new PrefEntry(entry.getKey(), entry.getValue(), entry.getValue(), true);
            setting = map2.get(entry.getKey());
            if (setting != null) {
                ((PrefEntry)object).markAsChanged();
            }
            arrayList.add((PrefEntry)object);
        }
        Collections.sort(arrayList);
        this.displayData.clear();
        this.displayData.addAll(arrayList);
        return arrayList;
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.profileTypes.put(I18n.marktr("shortcut"), "shortcut\\..*");
        this.profileTypes.put(I18n.marktr("color"), "color\\..*");
        this.profileTypes.put(I18n.marktr("toolbar"), "toolbar.*");
        this.profileTypes.put(I18n.marktr("imagery"), "imagery.*");
        for (Map.Entry<String, String> entry : this.profileTypes.entrySet()) {
            jPopupMenu.add(new ExportProfileAction(Main.pref, entry.getKey(), entry.getValue()));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.getProfileMenu());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AbstractAction(I18n.tr("Reset preferences", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!GuiHelper.warnUser(I18n.tr("Reset preferences", new Object[0]), "<html>" + I18n.tr("You are about to clear all preferences to their default values<br />All your settings will be deleted: plugins, imagery, filters, toolbar buttons, keyboard, etc. <br />Are you sure you want to continue?", new Object[0]) + "</html>", null, "")) {
                    Main.pref.resetToDefault();
                    try {
                        Main.pref.save();
                    }
                    catch (IOException iOException) {
                        Main.warn("IOException while saving preferences: " + iOException.getMessage());
                    }
                    AdvancedPreference.this.readPreferences(Main.pref);
                    AdvancedPreference.this.applyFilter();
                }
            }
        });
        return jPopupMenu;
    }

    private JMenu getProfileMenu() {
        final JMenu jMenu = new JMenu(I18n.tr("Load profile", new Object[0]));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                String string;
                int n;
                String string2;
                jMenu.removeAll();
                for (File file : new File(".").listFiles()) {
                    string2 = file.getName();
                    n = string2.indexOf(95);
                    if (n < 0 || !AdvancedPreference.this.profileTypes.containsKey(string = string2.substring(0, n))) continue;
                    jMenu.add(new ImportProfileAction(string2, file, string));
                }
                for (File file : Main.pref.getPreferencesDirFile().listFiles()) {
                    string2 = file.getName();
                    n = string2.indexOf(95);
                    if (n < 0 || !AdvancedPreference.this.profileTypes.containsKey(string = string2.substring(0, n))) continue;
                    jMenu.add(new ImportProfileAction(string2, file, string));
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void applyFilter() {
        this.displayData.clear();
        for (PrefEntry prefEntry : this.allData) {
            String string = prefEntry.getKey();
            Preferences.Setting setting = prefEntry.getValue();
            String string2 = setting.getValue() == null ? "" : setting.getValue().toString();
            String[] stringArray = this.txtFilter.getText().split("\\s+");
            boolean bl = true;
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            for (String string5 : stringArray) {
                if (string3.contains(string5 = string5.toLowerCase()) || string4.contains(string5)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.displayData.add(prefEntry);
        }
        if (this.table != null) {
            this.table.fireDataChanged();
        }
    }

    @Override
    public boolean ok() {
        for (PrefEntry prefEntry : this.allData) {
            if (!prefEntry.isChanged()) continue;
            Main.pref.putSetting(prefEntry.getKey(), prefEntry.getValue());
        }
        return false;
    }

    private class ImportProfileAction
    extends AbstractAction {
        private final File file;
        private final String type;

        public ImportProfileAction(String string, File file, String string2) {
            super(string);
            this.file = file;
            this.type = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences preferences = CustomConfigurator.clonePreferences(Main.pref);
            CustomConfigurator.readXML(this.file, preferences);
            AdvancedPreference.this.readPreferences(preferences);
            String string = AdvancedPreference.this.profileTypes.get(this.type);
            for (PrefEntry prefEntry : AdvancedPreference.this.allData) {
                if (!prefEntry.getKey().matches(string) || prefEntry.isDefault()) continue;
                prefEntry.reset();
            }
            Collections.sort(AdvancedPreference.this.allData, AdvancedPreference.this.customComparator);
            AdvancedPreference.this.applyFilter();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

