/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.preferences.DefaultPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.GBC;

public abstract class DefaultTabPreferenceSetting
extends DefaultPreferenceSetting
implements TabPreferenceSetting {
    private final String iconName;
    private final String description;
    private final String title;
    private final JTabbedPane tabpane;
    private final Map<SubPreferenceSetting, Component> subSettingMap;

    public DefaultTabPreferenceSetting() {
        this(null, null, null);
    }

    public DefaultTabPreferenceSetting(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public DefaultTabPreferenceSetting(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, null);
    }

    public DefaultTabPreferenceSetting(String string, String string2, String string3, boolean bl, JTabbedPane jTabbedPane) {
        super(bl);
        this.iconName = string;
        this.description = string3;
        this.title = string2;
        this.tabpane = jTabbedPane;
        this.subSettingMap = jTabbedPane != null ? new HashMap() : null;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getTooltip() {
        if (this.getDescription() != null) {
            return "<html>" + this.getDescription() + "</html>";
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public final JTabbedPane getTabPane() {
        return this.tabpane;
    }

    protected final void createPreferenceTabWithScrollPane(PreferenceTabbedPane preferenceTabbedPane, JPanel jPanel) {
        GBC gBC = GBC.eol().insets(-5, 0, 0, 0);
        gBC.anchor = 13;
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        preferencePanel.add((Component)jScrollPane, GBC.eol().fill(1));
        preferencePanel.add(GBC.glue(0, 10), gBC);
    }

    @Override
    public boolean selectSubTab(SubPreferenceSetting subPreferenceSetting) {
        Component component;
        if (this.tabpane != null && subPreferenceSetting != null && (component = this.getSubTab(subPreferenceSetting)) != null) {
            try {
                this.tabpane.setSelectedComponent(component);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public final void addSubTab(SubPreferenceSetting subPreferenceSetting, String string, Component component) {
        this.addSubTab(subPreferenceSetting, string, component, null);
    }

    @Override
    public final void addSubTab(SubPreferenceSetting subPreferenceSetting, String string, Component component, String string2) {
        if (this.tabpane != null && component != null) {
            this.tabpane.addTab(string, null, component, string2);
            this.registerSubTab(subPreferenceSetting, component);
        }
    }

    @Override
    public final void registerSubTab(SubPreferenceSetting subPreferenceSetting, Component component) {
        if (this.subSettingMap != null && subPreferenceSetting != null && component != null) {
            this.subSettingMap.put(subPreferenceSetting, component);
        }
    }

    @Override
    public final Component getSubTab(SubPreferenceSetting subPreferenceSetting) {
        return this.subSettingMap != null ? this.subSettingMap.get(subPreferenceSetting) : null;
    }
}

