/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.AreaPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.IconPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinePrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinemodPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.Prototype;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSourceHandler;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlStyleSource
extends StyleSource
implements StyleKeys {
    protected final Map<String, IconPrototype> icons = new HashMap<String, IconPrototype>();
    protected final Map<String, LinePrototype> lines = new HashMap<String, LinePrototype>();
    protected final Map<String, LinemodPrototype> modifiers = new HashMap<String, LinemodPrototype>();
    protected final Map<String, AreaPrototype> areas = new HashMap<String, AreaPrototype>();
    protected final List<IconPrototype> iconsList = new LinkedList<IconPrototype>();
    protected final List<LinePrototype> linesList = new LinkedList<LinePrototype>();
    protected final List<LinemodPrototype> modifiersList = new LinkedList<LinemodPrototype>();
    protected final List<AreaPrototype> areasList = new LinkedList<AreaPrototype>();

    public XmlStyleSource(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public XmlStyleSource(SourceEntry sourceEntry) {
        super(sourceEntry);
    }

    @Override
    protected void init() {
        super.init();
        this.icons.clear();
        this.lines.clear();
        this.modifiers.clear();
        this.areas.clear();
        this.iconsList.clear();
        this.linesList.clear();
        this.modifiersList.clear();
        this.areasList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource() {
        this.init();
        try {
            InputStream inputStream = this.getSourceInputStream();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                XmlObjectParser xmlObjectParser = new XmlObjectParser(new XmlStyleSourceHandler(this));
                xmlObjectParser.startWithValidation(inputStreamReader, "http://josm.openstreetmap.de/mappaint-style-1.0", "resource://data/mappaint-style.xsd");
                while (xmlObjectParser.hasNext()) {
                }
            }
            finally {
                this.closeSourceInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, iOException.toString()));
            iOException.printStackTrace();
            this.logError(iOException);
        }
        catch (SAXParseException sAXParseException) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: [{1}:{2}] {3}", this.url, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage()));
            sAXParseException.printStackTrace();
            this.logError(sAXParseException);
        }
        catch (SAXException sAXException) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, sAXException.getMessage()));
            sAXException.printStackTrace();
            this.logError(sAXException);
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        MirroredInputStream mirroredInputStream = new MirroredInputStream(this.url);
        InputStream inputStream = mirroredInputStream.findZipEntryInputStream("xml", "style");
        if (inputStream != null) {
            this.zipIcons = mirroredInputStream.getFile();
            return inputStream;
        }
        this.zipIcons = null;
        return mirroredInputStream;
    }

    private <T extends Prototype> T update(T t, T t2, Double d, MultiCascade multiCascade) {
        if (this.requiresUpdate(t, t2, d, multiCascade)) {
            return t2;
        }
        return t;
    }

    private boolean requiresUpdate(Prototype prototype, Prototype prototype2, Double d, MultiCascade multiCascade) {
        if (prototype == null || prototype2.priority >= prototype.priority) {
            if (d == null) {
                return true;
            }
            if (prototype2.range.contains(d)) {
                multiCascade.range = Range.cut(multiCascade.range, prototype2.range);
                return true;
            }
            multiCascade.range = multiCascade.range.reduceAround(d, prototype2.range);
            return false;
        }
        return false;
    }

    private IconPrototype getNode(OsmPrimitive osmPrimitive, Double d, MultiCascade multiCascade) {
        IconPrototype iconPrototype = null;
        for (String object : osmPrimitive.keySet()) {
            String string = osmPrimitive.get(object);
            IconPrototype iconPrototype2 = this.icons.get("n" + object + "=" + string);
            if (iconPrototype2 != null) {
                iconPrototype = this.update(iconPrototype, iconPrototype2, d, multiCascade);
            }
            if ((iconPrototype2 = this.icons.get("b" + object + "=" + OsmUtils.getNamedOsmBoolean(string))) != null) {
                iconPrototype = this.update(iconPrototype, iconPrototype2, d, multiCascade);
            }
            if ((iconPrototype2 = this.icons.get("x" + object)) == null) continue;
            iconPrototype = this.update(iconPrototype, iconPrototype2, d, multiCascade);
        }
        for (IconPrototype iconPrototype3 : this.iconsList) {
            if (!iconPrototype3.check(osmPrimitive)) continue;
            iconPrototype = this.update(iconPrototype, iconPrototype3, d, multiCascade);
        }
        return iconPrototype;
    }

    private void get(OsmPrimitive osmPrimitive, boolean bl, WayPrototypesRecord wayPrototypesRecord, Double d, MultiCascade multiCascade) {
        String string = null;
        HashMap<String, LinemodPrototype> hashMap = new HashMap<String, LinemodPrototype>();
        boolean bl2 = OsmUtils.isFalse(osmPrimitive.get("area"));
        for (String object : osmPrimitive.keySet()) {
            LinemodPrototype linemodPrototype;
            LinePrototype linePrototype;
            String string2 = osmPrimitive.get(object);
            String string3 = "n" + object + "=" + string2;
            AreaPrototype areaPrototype = this.areas.get(string3);
            if (!(areaPrototype == null || !bl && areaPrototype.closed || bl2)) {
                wayPrototypesRecord.area = this.update(wayPrototypesRecord.area, areaPrototype, d, multiCascade);
            }
            if ((linePrototype = this.lines.get(string3)) != null && this.requiresUpdate(wayPrototypesRecord.line, linePrototype, d, multiCascade)) {
                wayPrototypesRecord.line = linePrototype;
                string = string3;
            }
            if ((linemodPrototype = this.modifiers.get(string3)) != null && this.requiresUpdate(null, linemodPrototype, d, multiCascade)) {
                hashMap.put(string3, linemodPrototype);
            }
            if (!((areaPrototype = this.areas.get(string3 = "b" + object + "=" + OsmUtils.getNamedOsmBoolean(string2))) == null || !bl && areaPrototype.closed || bl2)) {
                wayPrototypesRecord.area = this.update(wayPrototypesRecord.area, areaPrototype, d, multiCascade);
            }
            if ((linePrototype = this.lines.get(string3)) != null && this.requiresUpdate(wayPrototypesRecord.line, linePrototype, d, multiCascade)) {
                wayPrototypesRecord.line = linePrototype;
                string = string3;
            }
            if ((linemodPrototype = this.modifiers.get(string3)) != null && this.requiresUpdate(null, linemodPrototype, d, multiCascade)) {
                hashMap.put(string3, linemodPrototype);
            }
            if (!((areaPrototype = this.areas.get(string3 = "x" + object)) == null || !bl && areaPrototype.closed || bl2)) {
                wayPrototypesRecord.area = this.update(wayPrototypesRecord.area, areaPrototype, d, multiCascade);
            }
            if ((linePrototype = this.lines.get(string3)) != null && this.requiresUpdate(wayPrototypesRecord.line, linePrototype, d, multiCascade)) {
                wayPrototypesRecord.line = linePrototype;
                string = string3;
            }
            if ((linemodPrototype = this.modifiers.get(string3)) == null || !this.requiresUpdate(null, linemodPrototype, d, multiCascade)) continue;
            hashMap.put(string3, linemodPrototype);
        }
        for (AreaPrototype areaPrototype : this.areasList) {
            if (!bl && areaPrototype.closed || bl2 || !areaPrototype.check(osmPrimitive)) continue;
            wayPrototypesRecord.area = this.update(wayPrototypesRecord.area, areaPrototype, d, multiCascade);
        }
        for (LinePrototype linePrototype : this.linesList) {
            if (!linePrototype.check(osmPrimitive)) continue;
            wayPrototypesRecord.line = this.update(wayPrototypesRecord.line, linePrototype, d, multiCascade);
        }
        for (LinemodPrototype linemodPrototype : this.modifiersList) {
            if (!linemodPrototype.check(osmPrimitive) || !this.requiresUpdate(null, linemodPrototype, d, multiCascade)) continue;
            hashMap.put(linemodPrototype.getCode(), linemodPrototype);
        }
        hashMap.remove(string);
        if (!hashMap.isEmpty()) {
            LinkedList linkedList = new LinkedList();
            if (wayPrototypesRecord.linemods != null) {
                linkedList.addAll(wayPrototypesRecord.linemods);
            }
            linkedList.addAll(hashMap.values());
            Collections.sort(linkedList);
            wayPrototypesRecord.linemods = linkedList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XmlCondition xmlCondition, Collection<XmlCondition> collection, Prototype prototype) {
        if (collection != null) {
            prototype.conditions = collection;
            if (prototype instanceof IconPrototype) {
                this.iconsList.add((IconPrototype)prototype);
                return;
            } else if (prototype instanceof LinemodPrototype) {
                this.modifiersList.add((LinemodPrototype)prototype);
                return;
            } else if (prototype instanceof LinePrototype) {
                this.linesList.add((LinePrototype)prototype);
                return;
            } else {
                if (!(prototype instanceof AreaPrototype)) throw new RuntimeException();
                this.areasList.add((AreaPrototype)prototype);
            }
            return;
        } else {
            String string;
            prototype.code = string = xmlCondition.getKey();
            if (prototype instanceof IconPrototype) {
                this.icons.put(string, (IconPrototype)prototype);
                return;
            } else if (prototype instanceof LinemodPrototype) {
                this.modifiers.put(string, (LinemodPrototype)prototype);
                return;
            } else if (prototype instanceof LinePrototype) {
                this.lines.put(string, (LinePrototype)prototype);
                return;
            } else {
                if (!(prototype instanceof AreaPrototype)) throw new RuntimeException();
                this.areas.put(string, (AreaPrototype)prototype);
            }
        }
    }

    @Override
    public void apply(MultiCascade multiCascade, OsmPrimitive osmPrimitive, double d, OsmPrimitive osmPrimitive2, boolean bl) {
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        boolean bl2 = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        if (osmPrimitive instanceof Node || osmPrimitive instanceof Relation && "restriction".equals(osmPrimitive.get("type"))) {
            IconPrototype iconPrototype = this.getNode(osmPrimitive, bl2 ? Double.valueOf(d) : null, multiCascade);
            if (iconPrototype != null) {
                cascade.put("icon-image", iconPrototype.icon);
                if (osmPrimitive instanceof Node && iconPrototype.annotate != null) {
                    if (iconPrototype.annotate.booleanValue()) {
                        cascade.put("text", Keyword.AUTO);
                    } else {
                        cascade.remove("text");
                    }
                }
            }
        } else if (osmPrimitive instanceof Way || osmPrimitive instanceof Relation && ((Relation)osmPrimitive).isMultipolygon()) {
            Float f;
            WayPrototypesRecord wayPrototypesRecord = new WayPrototypesRecord();
            this.get(osmPrimitive, bl || !(osmPrimitive instanceof Way) || ((Way)osmPrimitive).isClosed(), wayPrototypesRecord, bl2 ? Double.valueOf(d) : null, multiCascade);
            if (wayPrototypesRecord.line != null) {
                int n;
                cascade.put("width", new Float(wayPrototypesRecord.line.getWidth()));
                cascade.putOrClear("real-width", wayPrototypesRecord.line.realWidth != null ? new Float(wayPrototypesRecord.line.realWidth.intValue()) : null);
                cascade.putOrClear("color", wayPrototypesRecord.line.color);
                if (wayPrototypesRecord.line.color != null && (n = wayPrototypesRecord.line.color.getAlpha()) != 255) {
                    cascade.put("opacity", Utils.color_int2float(n));
                }
                cascade.putOrClear("dashes", wayPrototypesRecord.line.getDashed());
                cascade.putOrClear("dashes-background-color", wayPrototypesRecord.line.dashedColor);
            }
            if ((f = cascade.get("width", null, Float.class)) != null && wayPrototypesRecord.linemods != null) {
                int n = 0;
                int n2 = 0;
                while (multiCascade.hasLayer(String.format("over_%d", ++n))) {
                }
                while (multiCascade.hasLayer(String.format("under_%d", ++n2))) {
                }
                for (LinemodPrototype linemodPrototype : wayPrototypesRecord.linemods) {
                    int n3;
                    Cascade cascade2;
                    String string;
                    if (linemodPrototype.over) {
                        string = String.format("over_%d", n);
                        cascade2 = multiCascade.getOrCreateCascade(string);
                        cascade2.put("object-z-index", new Float(n));
                        ++n;
                    } else {
                        string = String.format("under_%d", n2);
                        cascade2 = multiCascade.getOrCreateCascade(string);
                        cascade2.put("object-z-index", new Float(-n2));
                        ++n2;
                    }
                    cascade2.put("width", new Float(linemodPrototype.getWidth(f.floatValue())));
                    cascade2.putOrClear("color", linemodPrototype.color);
                    if (linemodPrototype.color != null && (n3 = linemodPrototype.color.getAlpha()) != 255) {
                        cascade2.put("opacity", Utils.color_int2float(n3));
                    }
                    cascade2.putOrClear("dashes", linemodPrototype.getDashed());
                    cascade2.putOrClear("dashes-background-color", linemodPrototype.dashedColor);
                }
            }
            if (osmPrimitive2 != null) {
                WayPrototypesRecord wayPrototypesRecord2 = new WayPrototypesRecord();
                this.get(osmPrimitive2, true, wayPrototypesRecord2, bl2 ? Double.valueOf(d) : null, multiCascade);
                if (Utils.equal(wayPrototypesRecord.area, wayPrototypesRecord2.area)) {
                    wayPrototypesRecord.area = null;
                }
            }
            if (wayPrototypesRecord.area != null) {
                cascade.putOrClear("fill-color", wayPrototypesRecord.area.color);
                cascade.putOrClear("text-position", Keyword.CENTER);
                cascade.putOrClear("text", Keyword.AUTO);
                cascade.remove("fill-image");
            }
        }
    }

    private static class WayPrototypesRecord {
        public LinePrototype line;
        public List<LinemodPrototype> linemods;
        public AreaPrototype area;

        private WayPrototypesRecord() {
        }
    }
}

