/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public final List<MapCSSRule> rules;
    private Color backgroundColorOverride;
    private String css = null;
    private ZipFile zipFile;

    public MapCSSStyleSource(String string, String string2, String string3) {
        super(string, string2, string3);
        this.rules = new ArrayList<MapCSSRule>();
    }

    public MapCSSStyleSource(SourceEntry sourceEntry) {
        super(sourceEntry);
        this.rules = new ArrayList<MapCSSRule>();
    }

    public MapCSSStyleSource(String string) throws IllegalArgumentException {
        super(null, null, null);
        CheckParameterUtil.ensureParameterNotNull(string);
        this.css = string;
        this.rules = new ArrayList<MapCSSRule>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource() {
        this.init();
        this.rules.clear();
        try {
            InputStream inputStream = this.getSourceInputStream();
            try {
                MapCSSParser mapCSSParser = new MapCSSParser(inputStream, "UTF-8");
                mapCSSParser.sheet(this);
                this.loadMeta();
                this.loadCanvas();
            }
            finally {
                this.closeSourceInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, iOException.toString()));
            iOException.printStackTrace();
            this.logError(iOException);
        }
        catch (TokenMgrError tokenMgrError) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, tokenMgrError.getMessage()));
            tokenMgrError.printStackTrace();
            this.logError(tokenMgrError);
        }
        catch (ParseException parseException) {
            Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, parseException.getMessage()));
            parseException.printStackTrace();
            this.logError(new ParseException(parseException.getMessage()));
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        if (this.css != null) {
            return new ByteArrayInputStream(this.css.getBytes("UTF-8"));
        }
        MirroredInputStream mirroredInputStream = new MirroredInputStream(this.url);
        if (this.isZip) {
            File file = mirroredInputStream.getFile();
            Utils.close(mirroredInputStream);
            this.zipFile = new ZipFile(file);
            this.zipIcons = file;
            ZipEntry zipEntry = this.zipFile.getEntry(this.zipEntryPath);
            return this.zipFile.getInputStream(zipEntry);
        }
        this.zipFile = null;
        this.zipIcons = null;
        return mirroredInputStream;
    }

    @Override
    public void closeSourceInputStream(InputStream inputStream) {
        super.closeSourceInputStream(inputStream);
        if (this.isZip) {
            Utils.close(this.zipFile);
        }
    }

    private void loadMeta() {
        Cascade cascade = this.constructSpecial("meta");
        String string = cascade.get("title", null, String.class);
        if (this.title == null) {
            this.title = string;
        }
        String string2 = cascade.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = string2;
        }
    }

    private void loadCanvas() {
        Cascade cascade = this.constructSpecial("canvas");
        this.backgroundColorOverride = cascade.get("background-color", null, Color.class);
    }

    private Cascade constructSpecial(String string) {
        MultiCascade multiCascade = new MultiCascade();
        Node node = new Node();
        String string2 = LanguageInfo.getJOSMLocaleCode();
        node.put("lang", string2);
        Environment environment = new Environment(node, multiCascade, "default", this);
        block0: for (MapCSSRule mapCSSRule : this.rules) {
            for (Selector selector : mapCSSRule.selectors) {
                Selector.GeneralSelector generalSelector;
                if (!(selector instanceof Selector.GeneralSelector) || !(generalSelector = (Selector.GeneralSelector)selector).getBase().equals(string)) continue;
                if (!generalSelector.matchesConditions(environment)) continue block0;
                mapCSSRule.execute(environment);
            }
        }
        return multiCascade.getCascade("default");
    }

    @Override
    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    @Override
    public void apply(MultiCascade multiCascade, OsmPrimitive osmPrimitive, double d, OsmPrimitive osmPrimitive2, boolean bl) {
        Environment environment = new Environment(osmPrimitive, multiCascade, null, this);
        for (MapCSSRule mapCSSRule : this.rules) {
            for (Selector selector : mapCSSRule.selectors) {
                environment.clearSelectorMatchingInformation();
                if (!selector.matches(environment)) continue;
                if (!selector.getRange().contains(d)) {
                    multiCascade.range = multiCascade.range.reduceAround(d, selector.getRange());
                    continue;
                }
                multiCascade.range = Range.cut(multiCascade.range, selector.getRange());
                String string = selector.getSubpart();
                if (string == null) {
                    string = "default";
                } else if ("*".equals(string)) {
                    for (Map.Entry<String, Cascade> entry : multiCascade.getLayers()) {
                        environment.layer = entry.getKey();
                        if (Utils.equal(environment.layer, "*")) continue;
                        mapCSSRule.execute(environment);
                    }
                }
                environment.layer = string;
                mapCSSRule.execute(environment);
            }
        }
    }

    @Override
    public String toString() {
        return Utils.join("\n", this.rules);
    }
}

