/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.tools.Utils;

public abstract class Condition {
    public static final EnumSet<Op> COMPARISON_OPERATERS = EnumSet.of(Op.GREATER_OR_EQUAL, Op.GREATER, Op.LESS_OR_EQUAL, Op.LESS);

    public abstract boolean applies(Environment var1);

    public static Condition create(String string, String string2, Op op, Context context) {
        switch (context) {
            case PRIMITIVE: {
                return new KeyValueCondition(string, string2, op);
            }
            case LINK: {
                if ("role".equalsIgnoreCase(string)) {
                    return new RoleCondition(string2, op);
                }
                if ("index".equalsIgnoreCase(string)) {
                    return new IndexCondition(string2, op);
                }
                throw new MapCSSException(MessageFormat.format("Expected key ''role'' or ''index'' in link context. Got ''{0}''.", string));
            }
        }
        throw new AssertionError();
    }

    public static Condition create(String string, boolean bl, boolean bl2, Context context) {
        switch (context) {
            case PRIMITIVE: {
                return new KeyCondition(string, bl, bl2);
            }
            case LINK: {
                if (bl2) {
                    throw new MapCSSException("Question mark operator ''?'' not supported in LINK context");
                }
                if (bl) {
                    return new RoleCondition(string, Op.NEQ);
                }
                return new RoleCondition(string, Op.EQ);
            }
        }
        throw new AssertionError();
    }

    public static Condition create(String string, boolean bl, Context context) {
        return new PseudoClassCondition(string, bl);
    }

    public static Condition create(Expression expression, Context context) {
        return new ExpressionCondition(expression);
    }

    public static class ExpressionCondition
    extends Condition {
        private Expression e;

        public ExpressionCondition(Expression expression) {
            this.e = expression;
        }

        @Override
        public boolean applies(Environment environment) {
            Boolean bl = Cascade.convertTo(this.e.evaluate(environment), Boolean.class);
            return bl != null && bl != false;
        }

        public String toString() {
            return "[" + this.e + "]";
        }
    }

    public static class PseudoClassCondition
    extends Condition {
        String id;
        boolean not;

        public PseudoClassCondition(String string, boolean bl) {
            this.id = string;
            this.not = bl;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.not ^ this.appliesImpl(environment);
        }

        public boolean appliesImpl(Environment environment) {
            if (Utils.equal(this.id, "closed")) {
                if (environment.osm instanceof Way && ((Way)environment.osm).isClosed()) {
                    return true;
                }
                return environment.osm instanceof Relation && ((Relation)environment.osm).isMultipolygon();
            }
            if (Utils.equal(this.id, "modified")) {
                return environment.osm.isModified() || environment.osm.isNewOrUndeleted();
            }
            if (Utils.equal(this.id, "new")) {
                return environment.osm.isNew();
            }
            if (Utils.equal(this.id, "connection") && environment.osm instanceof Node) {
                return ((Node)environment.osm).isConnectionNode();
            }
            if (Utils.equal(this.id, "tagged")) {
                return environment.osm.isTagged();
            }
            return true;
        }

        public String toString() {
            return ":" + (this.not ? "!" : "") + this.id;
        }
    }

    public static class KeyCondition
    extends Condition {
        private String label;
        private boolean exclamationMarkPresent;
        private boolean questionMarkPresent;

        public KeyCondition(String string, boolean bl, boolean bl2) {
            this.label = string;
            this.exclamationMarkPresent = bl;
            this.questionMarkPresent = bl2;
        }

        @Override
        public boolean applies(Environment environment) {
            switch (environment.getContext()) {
                case PRIMITIVE: {
                    if (this.questionMarkPresent) {
                        return OsmUtils.isTrue(environment.osm.get(this.label)) ^ this.exclamationMarkPresent;
                    }
                    return environment.osm.hasKey(this.label) ^ this.exclamationMarkPresent;
                }
                case LINK: {
                    Utils.ensure(false, "Illegal state: KeyCondition not supported in LINK context", new Object[0]);
                    return false;
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return "[" + (this.exclamationMarkPresent ? "!" : "") + this.label + "]";
        }
    }

    public static class IndexCondition
    extends Condition {
        public String index;
        public Op op;

        public IndexCondition(String string, Op op) {
            this.index = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            if (environment.index == null) {
                return false;
            }
            return this.op.eval(Integer.toString(environment.index + 1), this.index);
        }
    }

    public static class RoleCondition
    extends Condition {
        public String role;
        public Op op;

        public RoleCondition(String string, Op op) {
            this.role = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            String string = environment.getRole();
            if (string == null) {
                return false;
            }
            return this.op.eval(string, this.role);
        }
    }

    public static class KeyValueCondition
    extends Condition {
        public String k;
        public String v;
        public Op op;

        public KeyValueCondition(String string, String string2, Op op) {
            this.k = string;
            this.v = string2;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.op.eval(environment.osm.get(this.k), this.v);
        }

        public String toString() {
            return "[" + this.k + "'" + (Object)((Object)this.op) + "'" + this.v + "]";
        }
    }

    public static enum Context {
        PRIMITIVE,
        LINK;

    }

    public static enum Op {
        EQ,
        NEQ,
        GREATER_OR_EQUAL,
        GREATER,
        LESS_OR_EQUAL,
        LESS,
        REGEX,
        NREGEX,
        ONE_OF,
        BEGINS_WITH,
        ENDS_WITH,
        CONTAINS;


        public boolean eval(String string, String string2) {
            float f;
            if (string == null && this != NEQ) {
                return false;
            }
            switch (this) {
                case EQ: {
                    return Utils.equal(string, string2);
                }
                case NEQ: {
                    return !Utils.equal(string, string2);
                }
                case REGEX: 
                case NREGEX: {
                    Pattern pattern = Pattern.compile(string2);
                    Matcher matcher = pattern.matcher(string);
                    return REGEX.equals((Object)this) ? matcher.find() : !matcher.find();
                }
                case ONE_OF: {
                    String[] stringArray;
                    for (String string3 : stringArray = string.split(";")) {
                        if (!Utils.equal(string2, string3.trim())) continue;
                        return true;
                    }
                    return false;
                }
                case BEGINS_WITH: {
                    return string.startsWith(string2);
                }
                case ENDS_WITH: {
                    return string.endsWith(string2);
                }
                case CONTAINS: {
                    return string.contains(string2);
                }
            }
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            float f2 = Float.parseFloat(string2);
            switch (this) {
                case GREATER_OR_EQUAL: {
                    return f >= f2;
                }
                case GREATER: {
                    return f > f2;
                }
                case LESS_OR_EQUAL: {
                    return f <= f2;
                }
                case LESS: {
                    return f < f2;
                }
            }
            throw new AssertionError();
        }
    }
}

