/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.LanguageInfo;

public abstract class LabelCompositionStrategy {
    public abstract String compose(OsmPrimitive var1);

    public static class DeriveLabelFromNameTagsCompositionStrategy
    extends LabelCompositionStrategy {
        public static final String[] DEFAULT_NAME_TAGS = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        private List<String> nameTags = new ArrayList<String>();

        public DeriveLabelFromNameTagsCompositionStrategy() {
            this.initNameTagsFromPreferences();
        }

        public void setNameTags(List<String> list) {
            if (list == null) {
                list = Collections.emptyList();
            }
            this.nameTags = new ArrayList<String>();
            for (String string : list) {
                if (string == null || (string = string.trim()).isEmpty()) continue;
                this.nameTags.add(string);
            }
        }

        public List<String> getNameTags() {
            return Collections.unmodifiableList(this.nameTags);
        }

        public void initNameTagsFromPreferences() {
            this.nameTags = Main.pref == null ? new ArrayList<String>(Arrays.asList(DEFAULT_NAME_TAGS)) : new ArrayList<String>(Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(DEFAULT_NAME_TAGS)));
        }

        private String getPrimitiveName(OsmPrimitive osmPrimitive) {
            String string = null;
            if (!osmPrimitive.hasKeys()) {
                return null;
            }
            for (String string2 : this.nameTags) {
                string = osmPrimitive.get(string2);
                if (string == null) continue;
                return string;
            }
            return null;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (osmPrimitive == null) {
                return null;
            }
            return this.getPrimitiveName(osmPrimitive);
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + "}";
        }
    }

    public static class TagLookupCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabelTag;

        public TagLookupCompositionStrategy(String string) {
            if (string != null && (string = string.trim()).isEmpty()) {
                string = null;
            }
            this.defaultLabelTag = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (this.defaultLabelTag == null) {
                return null;
            }
            if (osmPrimitive == null) {
                return null;
            }
            return osmPrimitive.get(this.defaultLabelTag);
        }

        public String getDefaultLabelTag() {
            return this.defaultLabelTag;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabelTag=" + this.defaultLabelTag + "}";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.defaultLabelTag == null ? 0 : this.defaultLabelTag.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TagLookupCompositionStrategy tagLookupCompositionStrategy = (TagLookupCompositionStrategy)object;
            return !(this.defaultLabelTag == null ? tagLookupCompositionStrategy.defaultLabelTag != null : !this.defaultLabelTag.equals(tagLookupCompositionStrategy.defaultLabelTag));
        }
    }

    public static class StaticLabelCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabel;

        public StaticLabelCompositionStrategy(String string) {
            this.defaultLabel = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            return this.defaultLabel;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabel=" + this.defaultLabel + "}";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.defaultLabel == null ? 0 : this.defaultLabel.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StaticLabelCompositionStrategy staticLabelCompositionStrategy = (StaticLabelCompositionStrategy)object;
            return !(this.defaultLabel == null ? staticLabelCompositionStrategy.defaultLabel != null : !this.defaultLabel.equals(staticLabelCompositionStrategy.defaultLabel));
        }
    }
}

