/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class ImageDisplay
extends JComponent {
    private File file = null;
    private Image image = null;
    private boolean errorLoading = false;
    private Rectangle visibleRect = null;
    private Rectangle selectedRect = null;
    private MediaTracker tracker = new MediaTracker(this);
    private String osdText = null;
    private static int DRAG_BUTTON = Main.pref.getBoolean("geoimage.agpifo-style-drag-and-zoom", false) ? 1 : 3;
    private static int ZOOM_BUTTON = DRAG_BUTTON == 1 ? 3 : 1;

    public ImageDisplay() {
        ImgDisplayMouseListener imgDisplayMouseListener = new ImgDisplayMouseListener();
        this.addMouseListener(imgDisplayMouseListener);
        this.addMouseWheelListener(imgDisplayMouseListener);
        this.addMouseMotionListener(imgDisplayMouseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(File file, Integer n) {
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            this.file = file;
            this.image = null;
            this.selectedRect = null;
            this.errorLoading = false;
        }
        this.repaint();
        if (file != null) {
            new Thread(new LoadImageRunnable(file, n)).start();
        }
    }

    public void setOsdText(String string) {
        this.osdText = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl;
        Rectangle rectangle;
        File file;
        Image image;
        Object object = this;
        synchronized (object) {
            image = this.image;
            file = this.file;
            rectangle = this.visibleRect;
            bl = this.errorLoading;
        }
        if (file == null) {
            graphics.setColor(Color.black);
            object = I18n.tr("No image", new Object[0]);
            Rectangle2D rectangle2D = graphics.getFontMetrics(graphics.getFont()).getStringBounds((String)object, graphics);
            Dimension dimension = this.getSize();
            graphics.drawString((String)object, (int)(((double)dimension.width - rectangle2D.getWidth()) / 2.0), (int)(((double)dimension.height - rectangle2D.getHeight()) / 2.0));
        } else if (image == null) {
            graphics.setColor(Color.black);
            object = !bl ? I18n.tr("Loading {0}", file.getName()) : I18n.tr("Error on file {0}", file.getName());
            Rectangle2D rectangle2D = graphics.getFontMetrics(graphics.getFont()).getStringBounds((String)object, graphics);
            Dimension dimension = this.getSize();
            graphics.drawString((String)object, (int)(((double)dimension.width - rectangle2D.getWidth()) / 2.0), (int)(((double)dimension.height - rectangle2D.getHeight()) / 2.0));
        } else {
            Serializable serializable;
            Cloneable cloneable;
            Object object2;
            object = this.calculateDrawImageRectangle(rectangle);
            graphics.drawImage(image, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
            if (this.selectedRect != null) {
                object2 = this.img2compCoord(rectangle, this.selectedRect.x, this.selectedRect.y);
                cloneable = this.img2compCoord(rectangle, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height);
                graphics.setColor(new Color(128, 128, 128, 180));
                graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Point)object2).y - ((Rectangle)object).y);
                graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Point)object2).x - ((Rectangle)object).x, ((Rectangle)object).height);
                graphics.fillRect(((Point)cloneable).x, ((Rectangle)object).y, ((Rectangle)object).x + ((Rectangle)object).width - ((Point)cloneable).x, ((Rectangle)object).height);
                graphics.fillRect(((Rectangle)object).x, ((Point)cloneable).y, ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height - ((Point)cloneable).y);
                graphics.setColor(Color.black);
                graphics.drawRect(((Point)object2).x, ((Point)object2).y, ((Point)cloneable).x - ((Point)object2).x, ((Point)cloneable).y - ((Point)object2).y);
            }
            if (bl) {
                object2 = I18n.tr("Error on file {0}", file.getName());
                cloneable = graphics.getFontMetrics(graphics.getFont()).getStringBounds((String)object2, graphics);
                serializable = this.getSize();
                graphics.drawString((String)object2, (int)(((double)((Dimension)serializable).width - ((RectangularShape)cloneable).getWidth()) / 2.0), (int)(((double)((Dimension)serializable).height - ((RectangularShape)cloneable).getHeight()) / 2.0));
            }
            if (this.osdText != null) {
                Rectangle2D rectangle2D;
                String string;
                object2 = graphics.getFontMetrics(graphics.getFont());
                int n = ((FontMetrics)object2).getAscent();
                serializable = new Color(255, 255, 255, 128);
                int n2 = 0;
                int n3 = this.osdText.indexOf(10);
                int n4 = 3;
                int n5 = 3;
                while (n3 > 0) {
                    string = this.osdText.substring(n2, n3);
                    rectangle2D = ((FontMetrics)object2).getStringBounds(string, graphics);
                    graphics.setColor((Color)serializable);
                    graphics.fillRect(n4, n5, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                    graphics.setColor(Color.black);
                    graphics.drawString(string, n4, n5 + n);
                    n5 += (int)rectangle2D.getHeight();
                    n2 = n3 + 1;
                    n3 = this.osdText.indexOf(10, n2);
                }
                string = this.osdText.substring(n2);
                rectangle2D = graphics.getFontMetrics(graphics.getFont()).getStringBounds(string, graphics);
                graphics.setColor((Color)serializable);
                graphics.fillRect(n4, n5, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                graphics.setColor(Color.black);
                graphics.drawString(string, n4, n5 + n);
            }
        }
    }

    private final Point img2compCoord(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = this.calculateDrawImageRectangle(rectangle);
        return new Point(rectangle2.x + (n - rectangle.x) * rectangle2.width / rectangle.width, rectangle2.y + (n2 - rectangle.y) * rectangle2.height / rectangle.height);
    }

    private final Point comp2imgCoord(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = this.calculateDrawImageRectangle(rectangle);
        return new Point(rectangle.x + (n - rectangle2.x) * rectangle.width / rectangle2.width, rectangle.y + (n2 - rectangle2.y) * rectangle.height / rectangle2.height);
    }

    private final Point getCenterImgCoord(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    private Rectangle calculateDrawImageRectangle(Rectangle rectangle) {
        return ImageDisplay.calculateDrawImageRectangle(rectangle, new Rectangle(0, 0, this.getSize().width, this.getSize().height));
    }

    static Rectangle calculateDrawImageRectangle(Rectangle rectangle, Rectangle rectangle2) {
        int n = 0;
        int n2 = 0;
        int n3 = rectangle2.width;
        int n4 = n3 * rectangle.height;
        int n5 = rectangle2.height;
        int n6 = n5 * rectangle.width;
        if (n4 != n6) {
            if (n4 > n6) {
                n3 = n6 / rectangle.height;
                n = (rectangle2.width - n3) / 2;
            } else {
                n5 = n4 / rectangle.width;
                n2 = (rectangle2.height - n5) / 2;
            }
        }
        return new Rectangle(n + rectangle2.x, n2 + rectangle2.y, n3, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomBestFitOrOne() {
        Rectangle rectangle;
        Image image;
        File file;
        Serializable serializable = this;
        synchronized (serializable) {
            file = this.file;
            image = this.image;
            rectangle = this.visibleRect;
        }
        if (image == null) {
            return;
        }
        if (rectangle.width != image.getWidth(null) || rectangle.height != image.getHeight(null)) {
            rectangle = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        } else {
            serializable = this.getCenterImgCoord(rectangle);
            rectangle = new Rectangle(((Point)serializable).x - this.getWidth() / 2, ((Point)serializable).y - this.getHeight() / 2, this.getWidth(), this.getHeight());
            this.checkVisibleRectPos(image, rectangle);
        }
        serializable = this;
        synchronized (serializable) {
            if (file == this.file) {
                this.visibleRect = rectangle;
            }
        }
        this.repaint();
    }

    private final void checkVisibleRectPos(Image image, Rectangle rectangle) {
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        if (rectangle.x + rectangle.width > image.getWidth(null)) {
            rectangle.x = image.getWidth(null) - rectangle.width;
        }
        if (rectangle.y + rectangle.height > image.getHeight(null)) {
            rectangle.y = image.getHeight(null) - rectangle.height;
        }
    }

    private void checkVisibleRectSize(Image image, Rectangle rectangle) {
        if (rectangle.width > image.getWidth(null)) {
            rectangle.width = image.getWidth(null);
        }
        if (rectangle.height > image.getHeight(null)) {
            rectangle.height = image.getHeight(null);
        }
    }

    private class ImgDisplayMouseListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        boolean mouseIsDragging = false;
        long lastTimeForMousePoint = 0L;
        Point mousePointInImg = null;

        private ImgDisplayMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n;
            int n2;
            Rectangle rectangle;
            Image image;
            File file;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                rectangle = ImageDisplay.this.visibleRect;
            }
            this.mouseIsDragging = false;
            ImageDisplay.this.selectedRect = null;
            if (image == null) {
                return;
            }
            if (mouseWheelEvent.getWhen() - this.lastTimeForMousePoint > 1500L || this.mousePointInImg == null) {
                this.lastTimeForMousePoint = mouseWheelEvent.getWhen();
                this.mousePointInImg = ImageDisplay.this.comp2imgCoord(rectangle, mouseWheelEvent.getX(), mouseWheelEvent.getY());
            }
            if (mouseWheelEvent.getWheelRotation() > 0) {
                rectangle.width = rectangle.width * 3 / 2;
                rectangle.height = rectangle.height * 3 / 2;
            } else {
                rectangle.width = rectangle.width * 2 / 3;
                rectangle.height = rectangle.height * 2 / 3;
            }
            if (rectangle.width < ImageDisplay.this.getSize().width / 2) {
                rectangle.width = ImageDisplay.this.getSize().width / 2;
            }
            if (rectangle.height < ImageDisplay.this.getSize().height / 2) {
                rectangle.height = ImageDisplay.this.getSize().height / 2;
            }
            if ((n2 = rectangle.height * ImageDisplay.this.getSize().width) > (n = rectangle.width * ImageDisplay.this.getSize().height)) {
                rectangle.width = n2 / ImageDisplay.this.getSize().height;
            } else {
                rectangle.height = n / ImageDisplay.this.getSize().width;
            }
            ImageDisplay.this.checkVisibleRectSize(image, rectangle);
            Rectangle rectangle2 = ImageDisplay.this.calculateDrawImageRectangle(rectangle);
            rectangle.x = this.mousePointInImg.x + (rectangle2.x - mouseWheelEvent.getX()) * rectangle.width / rectangle2.width;
            rectangle.y = this.mousePointInImg.y + (rectangle2.y - mouseWheelEvent.getY()) * rectangle.height / rectangle2.height;
            ImageDisplay.this.checkVisibleRectPos(image, rectangle);
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.file == file) {
                    ImageDisplay.this.visibleRect = rectangle;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Image image;
            File file;
            Serializable serializable = ImageDisplay.this;
            synchronized (serializable) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                rectangle = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (mouseEvent.getButton() != DRAG_BUTTON) {
                return;
            }
            serializable = ImageDisplay.this.comp2imgCoord(rectangle, mouseEvent.getX(), mouseEvent.getY());
            Point point = ImageDisplay.this.getCenterImgCoord(rectangle);
            rectangle.x += ((Point)serializable).x - point.x;
            rectangle.y += ((Point)serializable).y - point.y;
            ImageDisplay.this.checkVisibleRectPos(image, rectangle);
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                if (ImageDisplay.this.file == file) {
                    ImageDisplay.this.visibleRect = rectangle;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Image image;
            if (ImageDisplay.this.image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                image = ImageDisplay.this.image;
                rectangle = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (mouseEvent.getButton() == DRAG_BUTTON) {
                this.mousePointInImg = ImageDisplay.this.comp2imgCoord(rectangle, mouseEvent.getX(), mouseEvent.getY());
                this.mouseIsDragging = true;
                ImageDisplay.this.selectedRect = null;
            } else if (mouseEvent.getButton() == ZOOM_BUTTON) {
                this.mousePointInImg = ImageDisplay.this.comp2imgCoord(rectangle, mouseEvent.getX(), mouseEvent.getY());
                this.checkPointInVisibleRect(this.mousePointInImg, rectangle);
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = new Rectangle(this.mousePointInImg.x, this.mousePointInImg.y, 0, 0);
                ImageDisplay.this.repaint();
            } else {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Image image;
            File file;
            if (!this.mouseIsDragging && ImageDisplay.this.selectedRect == null) {
                return;
            }
            Serializable serializable = ImageDisplay.this;
            synchronized (serializable) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                rectangle = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                serializable = ImageDisplay.this.comp2imgCoord(rectangle, mouseEvent.getX(), mouseEvent.getY());
                rectangle.x += this.mousePointInImg.x - ((Point)serializable).x;
                rectangle.y += this.mousePointInImg.y - ((Point)serializable).y;
                ImageDisplay.this.checkVisibleRectPos(image, rectangle);
                ImageDisplay imageDisplay = ImageDisplay.this;
                synchronized (imageDisplay) {
                    if (ImageDisplay.this.file == file) {
                        ImageDisplay.this.visibleRect = rectangle;
                    }
                }
                ImageDisplay.this.repaint();
            } else if (ImageDisplay.this.selectedRect != null) {
                serializable = ImageDisplay.this.comp2imgCoord(rectangle, mouseEvent.getX(), mouseEvent.getY());
                this.checkPointInVisibleRect((Point)serializable, rectangle);
                Rectangle rectangle2 = new Rectangle(((Point)serializable).x < this.mousePointInImg.x ? ((Point)serializable).x : this.mousePointInImg.x, ((Point)serializable).y < this.mousePointInImg.y ? ((Point)serializable).y : this.mousePointInImg.y, ((Point)serializable).x < this.mousePointInImg.x ? this.mousePointInImg.x - ((Point)serializable).x : ((Point)serializable).x - this.mousePointInImg.x, ((Point)serializable).y < this.mousePointInImg.y ? this.mousePointInImg.y - ((Point)serializable).y : ((Point)serializable).y - this.mousePointInImg.y);
                ImageDisplay.this.checkVisibleRectSize(image, rectangle2);
                ImageDisplay.this.checkVisibleRectPos(image, rectangle2);
                ImageDisplay.this.selectedRect = rectangle2;
                ImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Image image;
            File file;
            if (!this.mouseIsDragging && ImageDisplay.this.selectedRect == null) {
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                this.mouseIsDragging = false;
            } else if (ImageDisplay.this.selectedRect != null) {
                int n;
                int n2;
                int n3 = ((ImageDisplay)ImageDisplay.this).selectedRect.width;
                int n4 = ((ImageDisplay)ImageDisplay.this).selectedRect.height;
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width < ImageDisplay.this.getSize().width / 2) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = ImageDisplay.this.getSize().width / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height < ImageDisplay.this.getSize().height / 2) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = ImageDisplay.this.getSize().height / 2;
                }
                if ((n2 = ((ImageDisplay)ImageDisplay.this).selectedRect.height * ImageDisplay.this.getSize().width) > (n = ((ImageDisplay)ImageDisplay.this).selectedRect.width * ImageDisplay.this.getSize().height)) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = n2 / ImageDisplay.this.getSize().height;
                } else {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = n / ImageDisplay.this.getSize().width;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width != n3) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.x -= (((ImageDisplay)ImageDisplay.this).selectedRect.width - n3) / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height != n4) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.y -= (((ImageDisplay)ImageDisplay.this).selectedRect.height - n4) / 2;
                }
                ImageDisplay.this.checkVisibleRectSize(image, ImageDisplay.this.selectedRect);
                ImageDisplay.this.checkVisibleRectPos(image, ImageDisplay.this.selectedRect);
                ImageDisplay imageDisplay2 = ImageDisplay.this;
                synchronized (imageDisplay2) {
                    if (file == ImageDisplay.this.file) {
                        ImageDisplay.this.visibleRect = ImageDisplay.this.selectedRect;
                    }
                }
                ImageDisplay.this.selectedRect = null;
                ImageDisplay.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void checkPointInVisibleRect(Point point, Rectangle rectangle) {
            if (point.x < rectangle.x) {
                point.x = rectangle.x;
            }
            if (point.x > rectangle.x + rectangle.width) {
                point.x = rectangle.x + rectangle.width;
            }
            if (point.y < rectangle.y) {
                point.y = rectangle.y;
            }
            if (point.y > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height;
            }
        }
    }

    private class LoadImageRunnable
    implements Runnable {
        private File file;
        private int orientation;

        public LoadImageRunnable(File file, Integer n) {
            this.file = file;
            this.orientation = n == null ? -1 : n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Image image = Toolkit.getDefaultToolkit().createImage(this.file.getPath());
            ImageDisplay.this.tracker.addImage(image, 1);
            while (!ImageDisplay.this.tracker.checkID(1, true)) {
                if (this.file != ImageDisplay.this.file) {
                    ImageDisplay.this.tracker.removeImage(image);
                    return;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while loading image " + this.file.getPath());
                }
            }
            boolean bl = ImageDisplay.this.tracker.isErrorID(1);
            if (image.getWidth(null) < 0 || image.getHeight(null) < 0) {
                bl = true;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                block15: {
                    if (this.file != ImageDisplay.this.file) {
                        ImageDisplay.this.tracker.removeImage(image);
                        return;
                    }
                    if (!bl) {
                        int n;
                        int n2;
                        double d;
                        double d2;
                        int n3;
                        ImageDisplay.this.image = image;
                        ImageDisplay.this.visibleRect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
                        int n4 = (int)ImageDisplay.this.visibleRect.getWidth();
                        int n5 = (int)ImageDisplay.this.visibleRect.getHeight();
                        switch (this.orientation) {
                            case 8: {
                                n3 = -1;
                                d2 = n4 / 2;
                                d = n4 / 2;
                                n2 = n5;
                                n = n4;
                                break;
                            }
                            case 3: {
                                n3 = 2;
                                d2 = n4 / 2;
                                d = n5 / 2;
                                n2 = n4;
                                n = n5;
                                break;
                            }
                            case 6: {
                                n3 = 1;
                                d2 = n5 / 2;
                                d = n5 / 2;
                                n2 = n5;
                                n = n4;
                                break;
                            }
                            default: {
                                break block15;
                            }
                        }
                        BufferedImage bufferedImage = new BufferedImage(n2, n, 1);
                        AffineTransform affineTransform = AffineTransform.getQuadrantRotateInstance(n3, d2, d);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.drawImage(ImageDisplay.this.image, affineTransform, null);
                        graphics2D.dispose();
                        ImageDisplay.this.visibleRect.setSize(n2, n);
                        ImageDisplay.this.image.flush();
                        ImageDisplay.this.image = bufferedImage;
                    }
                }
                ImageDisplay.this.selectedRect = null;
                ImageDisplay.this.errorLoading = bl;
            }
            ImageDisplay.this.tracker.removeImage(image);
            ImageDisplay.this.repaint();
        }
    }
}

