/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;

public abstract class HistoryViewerPanel
extends JPanel {
    protected HistoryBrowserModel model;
    protected VersionInfoPanel referenceInfoPanel;
    protected VersionInfoPanel currentInfoPanel;
    protected AdjustmentSynchronizer adjustmentSynchronizer;
    protected SelectionSynchronizer selectionSynchronizer;

    protected HistoryViewerPanel(HistoryBrowserModel historyBrowserModel) {
        this.setModel(historyBrowserModel);
        this.build();
    }

    private JScrollPane embedInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    public final void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    protected final void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected final void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
    }

    protected abstract JTable buildReferenceTable();

    protected abstract JTable buildCurrentTable();

    private void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embedInScrollPane(this.buildReferenceTable()), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embedInScrollPane(this.buildCurrentTable()), gridBagConstraints);
    }
}

