/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final ImageIcon icon = ImageProvider.get("data", "node");
    private final Border rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
    }

    public String buildToolTipText(OsmPrimitive osmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(osmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(osmPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = (String)arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = osmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void reset() {
        this.setBackground(ConflictColors.BGCOLOR.get());
        this.setForeground(ConflictColors.FGCOLOR.get());
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderNode(ListMergeModel.EntriesTableModel entriesTableModel, Node node, int n, boolean bl) {
        this.setIcon(this.icon);
        this.setBorder(null);
        if (entriesTableModel.getListMergeModel().isFrozen()) {
            this.setBackground(ConflictColors.BGCOLOR_FROZEN.get());
        } else if (bl) {
            this.setBackground(ConflictColors.BGCOLOR_SELECTED.get());
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            if (entriesTableModel.isSamePositionInOppositeList(n)) {
                this.setBackground(ConflictColors.BGCOLOR_SAME_POSITION_IN_OPPOSITE.get());
            } else if (entriesTableModel.isIncludedInOppositeList(n)) {
                this.setBackground(ConflictColors.BGCOLOR_IN_OPPOSITE.get());
            } else {
                this.setBackground(ConflictColors.BGCOLOR_NOT_IN_OPPOSITE.get());
            }
        }
        this.setText(node.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(this.buildToolTipText(node));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(ConflictColors.BGCOLOR_EMPTY_ROW.get());
        this.setText("");
    }

    protected void renderRowId(ListMergeModel.EntriesTableModel entriesTableModel, int n, boolean bl) {
        this.setIcon(null);
        this.setBorder(this.rowNumberBorder);
        if (entriesTableModel.getListMergeModel().isFrozen()) {
            this.setBackground(ConflictColors.BGCOLOR_FROZEN.get());
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            this.setBackground(ConflictColors.BGCOLOR_PARTICIPAING_IN_COMPARISON.get());
            this.setForeground(ConflictColors.FGCOLOR_PARTICIPAING_IN_COMPARISON.get());
        }
        this.setText(Integer.toString(n + 1));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Node node = (Node)object;
        this.reset();
        if (node == null) {
            this.renderEmptyRow();
        } else {
            switch (n2) {
                case 0: {
                    this.renderRowId(this.getModel(jTable), n, bl);
                    break;
                }
                case 1: {
                    this.renderNode(this.getModel(jTable), node, n, bl);
                    break;
                }
                default: {
                    throw new RuntimeException(MessageFormat.format("Unexpected column index. Got {0}.", n2));
                }
            }
        }
        return this;
    }

    protected ListMergeModel.EntriesTableModel getModel(JTable jTable) {
        return (ListMergeModel.EntriesTableModel)jTable.getModel();
    }
}

