/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class SourceButton {
    private int barX;
    private int barY;
    private int barWidth;
    private int layerHeight;
    private TileSource[] sources;
    private ImageIcon enlargeImage;
    private ImageIcon shrinkImage;
    private boolean isEnlarged = false;
    private int currentMap;
    public static final int HIDE_OR_SHOW = 1;

    public SourceButton(Collection<TileSource> collection) {
        this.setSources(collection);
        this.currentMap = 2;
        this.enlargeImage = ImageProvider.get("layer-switcher-maximize.png");
        this.shrinkImage = ImageProvider.get("layer-switcher-minimize.png");
    }

    public final void setSources(Collection<TileSource> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "sources");
        this.sources = collection.toArray(new TileSource[collection.size()]);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isEnlarged) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = 5;
            int n2 = 10;
            int n3 = 5;
            int n4 = 5;
            int n5 = 0;
            graphics2D.setFont(graphics2D.getFont().deriveFont(1).deriveFont(15.0f));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (TileSource tileSource : this.sources) {
                int n6 = fontMetrics.stringWidth(tileSource.getName());
                if (n6 <= n5) continue;
                n5 = n6;
            }
            this.barWidth = n5 + 50;
            this.barX = graphics2D.getClipBounds().width - this.barWidth - this.shrinkImage.getIconWidth();
            this.barY = 30;
            this.layerHeight = 20;
            graphics2D.setColor(new Color(0, 0, 139, 179));
            graphics2D.fillRoundRect(this.barX, this.barY, this.barWidth + this.shrinkImage.getIconWidth(), this.sources.length * this.layerHeight + n3 + n4, 10, 10);
            for (int i = 0; i < this.sources.length; ++i) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillOval(this.barX + n, this.barY + n3 + i * this.layerHeight + 6, n2, n2);
                graphics2D.drawString(this.sources[i].getName(), this.barX + n + n2 + n, this.barY + n3 + i * this.layerHeight + graphics2D.getFontMetrics().getHeight());
                if (this.currentMap != i + 2) continue;
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillOval(this.barX + n + 1, this.barY + n3 + 7 + i * this.layerHeight, n2 - 2, n2 - 2);
            }
            graphics2D.drawImage(this.shrinkImage.getImage(), this.barX + this.barWidth, this.barY, null);
        } else {
            this.barWidth = 0;
            this.barX = graphics2D.getClipBounds().width - this.shrinkImage.getIconWidth();
            this.barY = 30;
            graphics2D.drawImage(this.enlargeImage.getImage(), this.barX + this.barWidth, this.barY, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
    }

    public int hit(Point point) {
        if (this.isEnlarged) {
            int n;
            if (this.barX + this.barWidth < point.x) {
                if (this.barY < point.y && point.y < this.barY + this.shrinkImage.getIconHeight()) {
                    return 1;
                }
            } else if (this.barX < point.x && point.x < this.barX + this.barWidth && (n = (point.y - this.barY - 5) / this.layerHeight) >= 0 && n < this.sources.length) {
                this.currentMap = n + 2;
                return this.currentMap;
            }
        } else if (this.barX + this.barWidth < point.x && this.barY < point.y && point.y < this.barY + this.shrinkImage.getIconHeight()) {
            return 1;
        }
        return 0;
    }

    public TileSource hitToTileSource(int n) {
        if (n >= 2 && n < this.sources.length + 2) {
            return this.sources[n - 2];
        }
        return null;
    }

    public void setCurrentMap(TileSource tileSource) {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].equals(tileSource)) continue;
            this.currentMap = i + 2;
            return;
        }
        this.currentMap = 2;
    }
}

