/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static CopyOnWriteArrayList<TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    public static final String RESIZE_PROP;
    private OsmTileLoader cachedLoader;
    private OsmTileLoader uncachedLoader;
    private final SizeButton iSizeButton = new SizeButton();
    private final SourceButton iSourceButton;
    private Bounds bbox;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;

    public static void addTileSourceProvider(TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        TMSLayer.setMaxWorkers();
        this.cachedLoader = TMSLayer.loaderFactory.makeTileLoader(this);
        this.uncachedLoader = new OsmTileLoader(this);
        this.uncachedLoader.headers.put("User-Agent", Version.getInstance().getFullAgentString());
        this.setZoomContolsVisible(Main.pref.getBoolean("slippy_map_chooser.zoomcontrols", false));
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        List<TileSource> list = this.getAllTileSources();
        this.iSourceButton = new SourceButton(list);
        String string = PROP_MAPSTYLE.get();
        boolean bl = false;
        for (TileSource tileSource : list) {
            if (!tileSource.getName().equals(string)) continue;
            this.setTileSource(tileSource);
            this.iSourceButton.setCurrentMap(tileSource);
            bl = true;
            break;
        }
        if (!bl) {
            this.setTileSource(list.get(0));
            this.iSourceButton.setCurrentMap(list.get(0));
        }
        new SlippyMapControler(this, this, this.iSizeButton, this.iSourceButton);
    }

    private List<TileSource> getAllTileSources() {
        ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
        for (TileSourceProvider tileSourceProvider : providers) {
            arrayList.addAll(tileSourceProvider.getTileSources());
        }
        return arrayList;
    }

    public boolean handleAttribution(Point point, boolean bl) {
        return this.attribution.handleAttribution(point, bl);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int n = 22 - this.zoom;
                Point point = this.getTopLeftCoordinates();
                int n2 = (this.iSelectionRectStart.x >> n) - point.x;
                int n3 = (this.iSelectionRectStart.y >> n) - point.y;
                int n4 = (this.iSelectionRectEnd.x >> n) - point.x;
                int n5 = (this.iSelectionRectEnd.y >> n) - point.y;
                int n6 = n4 - n2;
                int n7 = n5 - n3;
                graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                graphics.fillRect(n2, n3, n6, n7);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n2, n3, n6, n7);
            }
            this.iSizeButton.paint(graphics);
            this.iSourceButton.paint((Graphics2D)graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFileCacheEnabled(boolean bl) {
        if (bl) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void setMaxTilesInMemory(int n) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(n);
    }

    public void setSelection(Point point, Point point2) {
        if (point == null || point2 == null || point.x == point2.x || point.y == point2.y) {
            return;
        }
        Point point3 = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        Point point4 = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        Point point5 = this.getTopLeftCoordinates();
        int n = 22 - this.zoom;
        Point point6 = new Point(point3.x + point5.x, point3.y + point5.y);
        Point point7 = new Point(point4.x + point5.x, point4.y + point5.y);
        point6.x <<= n;
        point6.y <<= n;
        point7.x <<= n;
        point7.y <<= n;
        this.iSelectionRectStart = point7;
        this.iSelectionRectEnd = point6;
        Coordinate coordinate = this.getPosition(point3);
        Coordinate coordinate2 = this.getPosition(point4);
        Bounds bounds = new Bounds(new LatLon(Math.min(coordinate2.getLat(), coordinate.getLat()), LatLon.toIntervalLon(Math.min(coordinate.getLon(), coordinate2.getLon()))), new LatLon(Math.max(coordinate2.getLat(), coordinate.getLat()), LatLon.toIntervalLon(Math.max(coordinate.getLon(), coordinate2.getLon()))));
        Bounds bounds2 = this.bbox;
        this.bbox = bounds;
        this.repaint();
        this.firePropertyChange(BBOX_PROP, bounds2, this.bbox);
    }

    public void resizeSlippyMap() {
        boolean bl = this.iSizeButton.isEnlarged();
        this.firePropertyChange(RESIZE_PROP, !bl, bl);
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bounds) {
        if (bounds == null || bounds.getMinLat() == 0.0 && bounds.getMinLon() == 0.0 && bounds.getMaxLat() == 0.0 && bounds.getMaxLon() == 0.0) {
            this.bbox = null;
            this.iSelectionRectStart = null;
            this.iSelectionRectEnd = null;
            this.repaint();
            return;
        }
        this.bbox = bounds;
        double d = bounds.getMinLon();
        double d2 = bounds.getMaxLon();
        if (bounds.crosses180thMeridian()) {
            d -= 360.0;
        }
        int n = OsmMercator.LatToY(bounds.getMinLat(), 22);
        int n2 = OsmMercator.LatToY(bounds.getMaxLat(), 22);
        int n3 = OsmMercator.LonToX(d, 22);
        int n4 = OsmMercator.LonToX(d2, 22);
        this.iSelectionRectStart = new Point(Math.min(n3, n4), Math.min(n, n2));
        this.iSelectionRectEnd = new Point(Math.max(n3, n4), Math.max(n, n2));
        MapMarkerDot mapMarkerDot = new MapMarkerDot(bounds.getMinLat(), bounds.getMinLon());
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(bounds.getMaxLat(), bounds.getMaxLon());
        ArrayList<MapMarker> arrayList = new ArrayList<MapMarker>(2);
        arrayList.add(mapMarkerDot);
        arrayList.add(mapMarkerDot2);
        this.setMapMarkerList(arrayList);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.repaint();
    }

    public final void refreshTileSources() {
        this.iSourceButton.setSources(this.getAllTileSources());
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(new TileSourceProvider(){

            @Override
            public List<TileSource> getTileSources() {
                return Arrays.asList(new RenamedSourceDecorator(new OsmTileSource.Mapnik(), "Mapnik"), new RenamedSourceDecorator(new OsmTileSource.CycleMap(), "Cyclemap"), new RenamedSourceDecorator(new MapQuestOsmTileSource(), "MapQuest-OSM"), new RenamedSourceDecorator(new MapQuestOpenAerialTileSource(), "MapQuest Open Aerial"));
            }
        });
        SlippyMapBBoxChooser.addTileSourceProvider(new TMSTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
        RESIZE_PROP = SlippyMapBBoxChooser.class.getName() + ".resize";
    }

    public static class TMSTileSourceProvider
    implements TileSourceProvider {
        static final Set<String> existingSlippyMapUrls = new HashSet<String>();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue()) {
                return Collections.emptyList();
            }
            ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
            for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getLayers()) {
                if (existingSlippyMapUrls.contains(imageryInfo.getUrl())) continue;
                try {
                    TileSource tileSource = TMSLayer.getTileSource(imageryInfo);
                    if (tileSource == null) continue;
                    arrayList.add(tileSource);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) continue;
                    JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Warning", new Object[0]), 2);
                }
            }
            return arrayList;
        }

        public static void addExistingSlippyMapUrl(String string) {
            existingSlippyMapUrls.add(string);
        }

        static {
            existingSlippyMapUrls.add("http://tile.openstreetmap.org/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://tile.opencyclemap.org/cycle/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://otile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/osm/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://oatile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/sat/{zoom}/{x}/{y}.png");
        }
    }

    public static class RenamedSourceDecorator
    implements TileSource {
        private final TileSource source;
        private final String name;

        public RenamedSourceDecorator(TileSource tileSource, String string) {
            this.source = tileSource;
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxZoom() {
            return this.source.getMaxZoom();
        }

        @Override
        public int getMinZoom() {
            return this.source.getMinZoom();
        }

        @Override
        public int getTileSize() {
            return this.source.getTileSize();
        }

        @Override
        public String getTileType() {
            return this.source.getTileType();
        }

        @Override
        public TileSource.TileUpdate getTileUpdate() {
            return this.source.getTileUpdate();
        }

        @Override
        public String getTileUrl(int n, int n2, int n3) throws IOException {
            return this.source.getTileUrl(n, n2, n3);
        }

        @Override
        public boolean requiresAttribution() {
            return this.source.requiresAttribution();
        }

        @Override
        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return this.source.getAttributionText(n, coordinate, coordinate2);
        }

        @Override
        public String getAttributionLinkURL() {
            return this.source.getAttributionLinkURL();
        }

        @Override
        public Image getAttributionImage() {
            return this.source.getAttributionImage();
        }

        @Override
        public String getAttributionImageURL() {
            return this.source.getAttributionImageURL();
        }

        @Override
        public String getTermsOfUseText() {
            return this.source.getTermsOfUseText();
        }

        @Override
        public String getTermsOfUseURL() {
            return this.source.getTermsOfUseURL();
        }

        @Override
        public double latToTileY(double d, int n) {
            return this.source.latToTileY(d, n);
        }

        @Override
        public double lonToTileX(double d, int n) {
            return this.source.lonToTileX(d, n);
        }

        @Override
        public double tileYToLat(int n, int n2) {
            return this.source.tileYToLat(n, n2);
        }

        @Override
        public double tileXToLon(int n, int n2) {
            return this.source.tileXToLon(n, n2);
        }
    }

    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

