/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public final class GettingStarted
extends JPanel {
    private String content = "";
    private static final String STYLE = "<style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n";

    public GettingStarted() {
        super(new BorderLayout());
        final LinkGeneral linkGeneral = new LinkGeneral("<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"", new Object[0]) + "</h2></html>");
        linkGeneral.getInputMap(0).put(KeyStroke.getKeyStroke(79, 3), "none");
        JScrollPane jScrollPane = new JScrollPane(linkGeneral);
        jScrollPane.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)jScrollPane, "Center");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (GettingStarted.this.content.isEmpty() && Main.pref.getBoolean("help.displaymotd", true)) {
                    try {
                        GettingStarted.this.content = new MotdContent().updateIfRequiredString();
                    }
                    catch (IOException iOException) {
                        Main.warn(I18n.tr("Failed to read MOTD. Exception was: {0}", iOException.toString()));
                        GettingStarted.this.content = "<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available", new Object[0]) + ")</h2></html>";
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        linkGeneral.setText(GettingStarted.this.fixImageLinks(GettingStarted.this.content));
                    }
                });
            }
        }, "MOTD-Loader");
        thread.setDaemon(true);
        thread.start();
        new FileDrop(jScrollPane);
    }

    private String fixImageLinks(String string) {
        Matcher matcher = Pattern.compile("src=\"http://josm.openstreetmap.de/browser/trunk(/images/.*?\\.png)\\?format=raw\"").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            URL uRL = this.getClass().getResource(string2);
            if (uRL == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement("src=\"" + uRL.toString() + "\""));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static class MotdContent
    extends CacheCustomContent<IOException> {
        private final int myVersion = Version.getInstance().getVersion();
        private final String myJava = System.getProperty("java.version");
        private final String myLang = LanguageInfo.getWikiLanguagePrefix();

        public MotdContent() {
            super("motd.html", 86400);
        }

        @Override
        protected byte[] updateData() throws IOException {
            String string = new WikiReader().readLang("StartupPage");
            Main.pref.putInteger("cache.motd.html.version", this.myVersion);
            Main.pref.put("cache.motd.html.java", this.myJava);
            Main.pref.put("cache.motd.html.lang", this.myLang);
            try {
                return string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return new byte[0];
            }
        }

        @Override
        protected boolean isCacheValid() {
            return Main.pref.getInteger("cache.motd.html.version", -999) == this.myVersion && Main.pref.get("cache.motd.html.java").equals(this.myJava) && Main.pref.get("cache.motd.html.lang").equals(this.myLang);
        }
    }

    public static class LinkGeneral
    extends JosmEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String string) {
            this.setContentType("text/html");
            this.setText(string);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(hyperlinkEvent.getDescription());
            }
        }
    }
}

