/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;

    private ConditionalOptionPaneUtil() {
    }

    public static boolean getDialogShowingEnabled(String string) {
        return Main.pref.getBoolean("message." + string, true);
    }

    public static void setDialogShowingEnabled(String string, boolean bl) {
        Main.pref.put("message." + string, bl);
    }

    public static Integer getDialogReturnValue(String string) {
        return Main.pref.getInteger("message." + string + ".value", -1);
    }

    public static void setDialogReturnValue(String string, Integer n) {
        Main.pref.putInteger("message." + string + ".value", n);
    }

    public static int showOptionDialog(String string, Component component, Object object, String string2, int n, int n2, Object[] objectArray, Object object2) throws HeadlessException {
        int n3 = ConditionalOptionPaneUtil.getDialogReturnValue(string);
        if (!(ConditionalOptionPaneUtil.getDialogShowingEnabled(string) || n3 != 0 && n3 != 1)) {
            return n3;
        }
        MessagePanel messagePanel = new MessagePanel(false, object);
        n3 = JOptionPane.showOptionDialog(component, messagePanel, string2, n, n2, null, objectArray, object2);
        if (!(n3 != 0 && n3 != 1 || messagePanel.getDialogShowingEnabled())) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(string, false);
            ConditionalOptionPaneUtil.setDialogReturnValue(string, n3);
        }
        return n3;
    }

    public static boolean showConfirmationDialog(String string, Component component, Object object, String string2, int n, int n2, int n3) throws HeadlessException {
        int n4 = ConditionalOptionPaneUtil.getDialogReturnValue(string);
        if (!(ConditionalOptionPaneUtil.getDialogShowingEnabled(string) || n4 != 0 && n4 != 1)) {
            return n4 == n3;
        }
        MessagePanel messagePanel = new MessagePanel(false, object);
        n4 = JOptionPane.showConfirmDialog(component, messagePanel, string2, n, n2);
        if (!(n4 != 0 && n4 != 1 || messagePanel.getDialogShowingEnabled())) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(string, false);
            ConditionalOptionPaneUtil.setDialogReturnValue(string, n4);
        }
        return n4 == n3;
    }

    public static void showMessageDialog(String string, Component component, Object object, String string2, int n) {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(string)) {
            return;
        }
        MessagePanel messagePanel = new MessagePanel(false, object);
        JOptionPane.showMessageDialog(component, messagePanel, string2, n);
        if (!messagePanel.getDialogShowingEnabled()) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(string, false);
        }
    }

    private static class MessagePanel
    extends JPanel {
        JCheckBox cbShowDialog = new JCheckBox(I18n.tr("Do not show again (remembers choice)", new Object[0]));

        public MessagePanel(boolean bl, Object object) {
            this.cbShowDialog.setSelected(bl);
            this.setLayout(new GridBagLayout());
            if (object instanceof Component) {
                this.add((Component)object, GBC.eop());
            } else {
                this.add((Component)new JLabel(object.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowDialog, GBC.eol());
        }

        public boolean getDialogShowingEnabled() {
            return !this.cbShowDialog.isSelected();
        }
    }
}

