/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("This plugin checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        this.initializePresets();
    }

    public void initializePresets() {
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            block0: for (TaggingPreset taggingPreset : collection) {
                for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                    if (!(taggingPresetItem instanceof TaggingPresetItems.Roles)) continue;
                    relationpresets.add(taggingPreset);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(Relation relation) {
        Object object;
        Iterator<Object> iterator;
        LinkedList<TaggingPresetItems.Role> linkedList = new LinkedList<TaggingPresetItems.Role>();
        for (TaggingPreset linkedList2 : relationpresets) {
            boolean relationMember = true;
            iterator = null;
            for (Object object2 : linkedList2.data) {
                if (object2 instanceof TaggingPresetItems.Key) {
                    object = (TaggingPresetItems.Key)object2;
                    if (((TaggingPresetItems.Key)object).value.equals(relation.get(((TaggingPresetItems.Key)object).key))) continue;
                    relationMember = false;
                    break;
                }
                if (!(object2 instanceof TaggingPresetItems.Roles)) continue;
                iterator = (TaggingPresetItems.Roles)object2;
            }
            if (!relationMember || iterator == null) continue;
            linkedList.addAll(((TaggingPresetItems.Roles)((Object)iterator)).roles);
        }
        if (linkedList.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, relation));
        } else {
            HashMap hashMap = new HashMap();
            for (RelationMember relationMember : relation.getMembers()) {
                void var7_16;
                RoleInfo roleInfo;
                iterator = "";
                if (relationMember.hasRole()) {
                    iterator = relationMember.getRole();
                }
                if ((roleInfo = (RoleInfo)hashMap.get(iterator)) == null) {
                    RoleInfo roleInfo2 = new RoleInfo();
                }
                ((RoleInfo)var7_16).total++;
                if (relationMember.isRelation()) {
                    ((RoleInfo)var7_16).relations.add(relationMember.getRelation());
                } else if (relationMember.isWay()) {
                    ((RoleInfo)var7_16).ways.add(relationMember.getWay());
                    if (!relationMember.getWay().isClosed()) {
                        ((RoleInfo)var7_16).openways.add(relationMember.getWay());
                    }
                } else if (relationMember.isNode()) {
                    ((RoleInfo)var7_16).nodes.add(relationMember.getNode());
                }
                hashMap.put(iterator, var7_16);
            }
            if (hashMap.isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, relation));
            } else {
                Object object2;
                LinkedList<String> linkedList2 = new LinkedList<String>();
                String string = I18n.tr("Role verification problem", new Object[0]);
                for (TaggingPresetItems.Role role : linkedList) {
                    Object object3;
                    long l;
                    long l2;
                    linkedList2.add(role.key);
                    object2 = role.key;
                    if ("".equals(object2)) {
                        object2 = I18n.tr("<empty>", new Object[0]);
                    }
                    if ((l2 = (object = (RoleInfo)hashMap.get(role.key)) == null ? 0L : (long)((RoleInfo)object).total) != (l = role.getValidCount(l2))) {
                        if (l2 == 0L) {
                            object3 = I18n.marktr("Role {0} missing");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr((String)object3, object2), MessageFormat.format((String)object3, object2), 1706, relation));
                        } else if (l > l2) {
                            object3 = I18n.marktr("Number of {0} roles too low ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr((String)object3, object2, l2), MessageFormat.format((String)object3, object2, l2), 1705, relation));
                        } else {
                            object3 = I18n.marktr("Number of {0} roles too high ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr((String)object3, object2, l2), MessageFormat.format((String)object3, object2, l2), 1704, relation));
                        }
                    }
                    if (object == null) continue;
                    object3 = new HashSet();
                    if (role.types != null) {
                        if (!role.types.contains((Object)TaggingPresetType.WAY)) {
                            object3.addAll(role.types.contains((Object)TaggingPresetType.CLOSEDWAY) ? ((RoleInfo)object).openways : ((RoleInfo)object).ways);
                        }
                        if (!role.types.contains((Object)TaggingPresetType.NODE)) {
                            object3.addAll(((RoleInfo)object).nodes);
                        }
                        if (!role.types.contains((Object)TaggingPresetType.RELATION)) {
                            object3.addAll(((RoleInfo)object).relations);
                        }
                    }
                    if (role.memberExpression != null) {
                        for (Collection collection : Arrays.asList(((RoleInfo)object).nodes, ((RoleInfo)object).ways, ((RoleInfo)object).relations)) {
                            for (OsmPrimitive osmPrimitive : collection) {
                                if (!osmPrimitive.isUsable() || role.memberExpression.match(osmPrimitive)) continue;
                                object3.add(osmPrimitive);
                            }
                        }
                    }
                    if (object3.isEmpty()) continue;
                    String string2 = I18n.marktr("Member for role {0} of wrong type");
                    LinkedList<Relation> linkedList3 = new LinkedList<Relation>((Collection<Relation>)object3);
                    linkedList3.addFirst(relation);
                    this.errors.add(new TestError(this, Severity.WARNING, string, I18n.tr(string2, object2), MessageFormat.format(string2, object2), 1703, (Collection<? extends OsmPrimitive>)linkedList3, (Collection<?>)object3));
                }
                for (String string3 : hashMap.keySet()) {
                    if (linkedList2.contains(string3)) continue;
                    if (string3.length() > 0) {
                        object2 = I18n.marktr("Role {0} unknown");
                        this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr((String)object2, string3), MessageFormat.format((String)object2, string3), 1701, relation));
                        continue;
                    }
                    object2 = I18n.marktr("Empty role found");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, string, I18n.tr((String)object2, new Object[0]), (String)object2, 1702, relation));
                }
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total = 0;
        private Collection<Node> nodes = new LinkedList<Node>();
        private Collection<Way> ways = new LinkedList<Way>();
        private Collection<Way> openways = new LinkedList<Way>();
        private Collection<Relation> relations = new LinkedList<Relation>();

        private RoleInfo() {
        }
    }
}

