/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NodesDuplicatingWayTags
extends Test {
    protected static final int NODE_DUPING_PARENT_WAY_TAGS = 2401;

    public NodesDuplicatingWayTags() {
        super(I18n.tr("Nodes duplicating way tags", new Object[0]), I18n.tr("Checks for nodes that have the same tags as their parent way.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable() || !way.isTagged()) {
            return;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Node node : way.getNodes()) {
            if (!way.hasSameTags(node)) continue;
            hashSet.add(node);
        }
        if (!hashSet.isEmpty()) {
            hashSet.add(way);
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Nodes duplicating parent way tags", new Object[0]), 2401, hashSet));
        }
    }
}

