/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateRelation
extends Test {
    protected static final int DUPLICATE_RELATION = 1901;
    protected static final int SAME_RELATION = 1902;
    private MultiMap<RelationPair, OsmPrimitive> relations;
    private MultiMap<List<RelationMember>, OsmPrimitive> relations_nokeys;
    private final Set<String> ignoreKeys = new HashSet<String>(OsmPrimitive.getUninterestingKeys());

    public DuplicateRelation() {
        super(I18n.tr("Duplicated relations", new Object[0]), I18n.tr("This test checks that there are no relations with same tags and same members with same roles.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.relations = new MultiMap(1000);
        this.relations_nokeys = new MultiMap(1000);
    }

    @Override
    public void endTest() {
        TestError testError;
        super.endTest();
        for (Set<OsmPrimitive> set : this.relations.values()) {
            if (set.size() <= 1) continue;
            testError = new TestError((Test)this, Severity.ERROR, I18n.tr("Duplicated relations", new Object[0]), 1901, set);
            this.errors.add(testError);
        }
        this.relations = null;
        for (Set<OsmPrimitive> set : this.relations_nokeys.values()) {
            if (set.size() <= 1) continue;
            testError = new TestError((Test)this, Severity.WARNING, I18n.tr("Relations with same members", new Object[0]), 1902, set);
            this.errors.add(testError);
        }
        this.relations_nokeys = null;
    }

    @Override
    public void visit(Relation relation) {
        if (!relation.isUsable() || relation.hasIncompleteMembers()) {
            return;
        }
        List<RelationMember> list = relation.getMembers();
        Map<String, String> map = relation.getKeys();
        for (String string : this.ignoreKeys) {
            map.remove(string);
        }
        RelationPair relationPair = new RelationPair(list, map);
        this.relations.put(relationPair, relation);
        this.relations_nokeys.put(list, relation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Command fixError(TestError testError) {
        if (testError.getCode() == 1902) {
            return null;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isDeleted()) continue;
            hashSet.add((Relation)osmPrimitive);
        }
        if (hashSet.size() < 2) {
            return null;
        }
        long l = 0L;
        Relation relation = (Relation)hashSet.iterator().next();
        for (Relation object2 : hashSet) {
            if (object2.isNew() || l != 0L && object2.getId() >= l) continue;
            l = object2.getId();
            relation = object2;
        }
        Object object3 = null;
        Object var8_10 = null;
        for (Relation relation2 : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(relation2.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            if (object3 != null) {
                throw new AssertionError((Object)"Cannot fix duplicate relations: More than one relation is member of another relation.");
            }
            object3 = relation2;
            List<Relation> list2 = list;
        }
        LinkedList linkedList = new LinkedList();
        if (object3 != null && relation != object3) {
            void var8_11;
            for (List<Relation> list : var8_11) {
                Relation relation3 = new Relation((Relation)((Object)list));
                for (int i = 0; i < relation3.getMembers().size(); ++i) {
                    RelationMember relationMember = relation3.getMember(i);
                    if (!((OsmPrimitive)object3).equals(relationMember.getMember())) continue;
                    relation3.setMember(i, new RelationMember(relationMember.getRole(), relation));
                }
                linkedList.add(new ChangeCommand((OsmPrimitive)((Object)list), relation3));
            }
        }
        hashSet.remove(relation);
        linkedList.add(new DeleteCommand(hashSet));
        return new SequenceCommand(I18n.tr("Delete duplicate relations", new Object[0]), linkedList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateRelation) || testError.getCode() == 1902) {
            return false;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (OsmPrimitive object : collection) {
            if (!(object instanceof Relation)) continue;
            hashSet.add((Relation)object);
        }
        if (hashSet.size() < 2) {
            return false;
        }
        int n = 0;
        for (Relation relation : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(relation.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            ++n;
        }
        return n <= 1;
    }

    private class RelationPair {
        private RelationMembers members;
        private Map<String, String> keys;

        public RelationPair(List<RelationMember> list, Map<String, String> map) {
            this.members = new RelationMembers(list);
            this.keys = map;
        }

        public int hashCode() {
            return this.members.hashCode() + ((Object)this.keys).hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelationPair)) {
                return false;
            }
            RelationPair relationPair = (RelationPair)object;
            return relationPair.members.equals(this.members) && ((Object)relationPair.keys).equals(this.keys);
        }
    }

    private class RelationMembers {
        private List<RelMember> members;

        public RelationMembers(List<RelationMember> list) {
            this.members = new ArrayList<RelMember>(list.size());
            for (RelationMember relationMember : list) {
                this.members.add(new RelMember(relationMember));
            }
        }

        public int hashCode() {
            return ((Object)this.members).hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelationMembers)) {
                return false;
            }
            RelationMembers relationMembers = (RelationMembers)object;
            return ((Object)relationMembers.members).equals(this.members);
        }
    }

    public static class RelMember {
        private String role;
        private OsmPrimitiveType type;
        private Map<String, String> tags;
        private List<LatLon> coor;
        private long relId;

        public int hashCode() {
            return this.role.hashCode() + (int)this.relId + ((Object)this.tags).hashCode() + this.type.hashCode() + ((Object)this.coor).hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelMember)) {
                return false;
            }
            RelMember relMember = (RelMember)object;
            return relMember.role.equals(this.role) && relMember.type.equals((Object)this.type) && relMember.relId == this.relId && ((Object)relMember.tags).equals(this.tags) && ((Object)relMember.coor).equals(this.coor);
        }

        public RelMember(RelationMember relationMember) {
            OsmPrimitive osmPrimitive;
            this.role = relationMember.getRole();
            this.type = relationMember.getType();
            this.relId = 0L;
            this.coor = new ArrayList<LatLon>();
            if (relationMember.isNode()) {
                osmPrimitive = relationMember.getNode();
                this.tags = osmPrimitive.getKeys();
                this.coor = new ArrayList<LatLon>(1);
                this.coor.add(((Node)osmPrimitive).getCoor());
            }
            if (relationMember.isWay()) {
                osmPrimitive = relationMember.getWay();
                this.tags = osmPrimitive.getKeys();
                List<Node> list = ((Way)osmPrimitive).getNodes();
                this.coor = new ArrayList<LatLon>(list.size());
                for (Node node : list) {
                    this.coor.add(node.getCoor());
                }
            }
            if (relationMember.isRelation()) {
                osmPrimitive = relationMember.getRelation();
                this.tags = osmPrimitive.getKeys();
                this.relId = osmPrimitive.getId();
                this.coor = new ArrayList<LatLon>();
            }
        }
    }
}

