/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class CrossingWays
extends Test {
    protected static final int CROSSING_WAYS = 601;
    private Map<Point2D, List<ExtendedSegment>> cellSegments;
    private Set<WaySegment> errorSegments;
    private Map<List<Way>, List<WaySegment>> seenWays;

    public CrossingWays() {
        super(I18n.tr("Crossing ways.", new Object[0]), I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellSegments = new HashMap<Point2D, List<ExtendedSegment>>(1000);
        this.errorSegments = new HashSet<WaySegment>();
        this.seenWays = new HashMap<List<Way>, List<WaySegment>>(50);
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments = null;
        this.errorSegments = null;
        this.seenWays = null;
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("natural");
        String string2 = way.get("landuse");
        boolean bl = "water".equals(string) || "coastline".equals(string) || "reservoir".equals(string2);
        String string3 = way.get("highway");
        String string4 = way.get("railway");
        boolean bl2 = "subway".equals(string4);
        boolean bl3 = "tram".equals(string4);
        boolean bl4 = CrossingWays.isBuilding(way);
        String string5 = way.get("waterway");
        if (way.get("highway") == null && way.get("waterway") == null && (string4 == null || bl2 || bl3) && !bl && !bl4) {
            return;
        }
        String string6 = way.get("level");
        String string7 = way.get("layer");
        if ("0".equals(string7)) {
            string7 = null;
        }
        int n = way.getNodesCount();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            ExtendedSegment extendedSegment = new ExtendedSegment(waySegment, string7, string3, string4, bl, string5, string6);
            for (List<ExtendedSegment> list : this.getSegments(extendedSegment.n1, extendedSegment.n2)) {
                for (ExtendedSegment extendedSegment2 : list) {
                    if (this.errorSegments.contains(waySegment) && this.errorSegments.contains(extendedSegment2.ws)) continue;
                    String string8 = extendedSegment2.level;
                    String string9 = extendedSegment2.layer;
                    String string10 = extendedSegment2.highway;
                    String string11 = extendedSegment2.railway;
                    boolean bl5 = extendedSegment2.coastline;
                    if (string7 != null ? !string7.equals(string9) : string9 != null) continue;
                    if (string3 != null && string10 != null && string6 != null && string8 != null && !string6.equals(string8) || !extendedSegment.intersects(extendedSegment2) || bl2 && "subway".equals(string11) || bl3 && "tram".equals(string11) || bl != bl5 || "river".equals(string5) && "riverbank".equals(extendedSegment2.waterway) || "riverbank".equals(string5) && "river".equals(extendedSegment2.waterway) || "proposed".equals(extendedSegment.highway) || "proposed".equals(string10) || "proposed".equals(extendedSegment.railway) || "proposed".equals(string11) || "abandoned".equals(extendedSegment.railway) || "abandoned".equals(string11)) continue;
                    List<Way> list2 = Arrays.asList(((ExtendedSegment)extendedSegment).ws.way, ((ExtendedSegment)extendedSegment2).ws.way);
                    List<WaySegment> list3 = this.seenWays.get(list2);
                    if (list3 == null) {
                        list3 = new ArrayList<WaySegment>();
                        list3.add(extendedSegment.ws);
                        list3.add(extendedSegment2.ws);
                        String string12 = bl4 ? I18n.tr("Crossing buildings", new Object[0]) : (extendedSegment.waterway != null && extendedSegment2.waterway != null ? I18n.tr("Crossing waterways", new Object[0]) : (extendedSegment.waterway != null && extendedSegment2.highway != null || extendedSegment2.waterway != null && extendedSegment.highway != null ? I18n.tr("Crossing waterway/highway", new Object[0]) : I18n.tr("Crossing ways", new Object[0])));
                        this.errors.add(new TestError(this, Severity.WARNING, string12, 601, list2, list3));
                        this.seenWays.put(list2, list3);
                        continue;
                    }
                    list3.add(extendedSegment.ws);
                    list3.add(extendedSegment2.ws);
                }
                list.add(extendedSegment);
            }
        }
    }

    public List<List<ExtendedSegment>> getSegments(Node node, Node node2) {
        ArrayList<List<ExtendedSegment>> arrayList = new ArrayList<List<ExtendedSegment>>();
        for (Point2D point2D : ValUtil.getSegmentCells(node, node2, OsmValidator.griddetail)) {
            List<ExtendedSegment> list = this.cellSegments.get(point2D);
            if (list == null) {
                list = new ArrayList<ExtendedSegment>();
                this.cellSegments.put(point2D, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static class ExtendedSegment {
        private final Node n1;
        private final Node n2;
        private final WaySegment ws;
        private final String layer;
        private final String highway;
        private final String railway;
        private final String waterway;
        private final boolean coastline;
        private final String level;

        public ExtendedSegment(WaySegment waySegment, String string, String string2, String string3, boolean bl, String string4, String string5) {
            this.ws = waySegment;
            this.n1 = waySegment.way.getNodes().get(waySegment.lowerIndex);
            this.n2 = waySegment.way.getNodes().get(waySegment.lowerIndex + 1);
            this.layer = string;
            this.highway = string2;
            this.railway = string3;
            this.coastline = bl;
            this.waterway = string4;
            this.level = string5;
        }

        public boolean intersects(ExtendedSegment extendedSegment) {
            if (this.n1.equals(extendedSegment.n1) || this.n2.equals(extendedSegment.n2) || this.n1.equals(extendedSegment.n2) || this.n2.equals(extendedSegment.n1)) {
                return false;
            }
            return Line2D.linesIntersect(this.n1.getEastNorth().east(), this.n1.getEastNorth().north(), this.n2.getEastNorth().east(), this.n2.getEastNorth().north(), extendedSegment.n1.getEastNorth().east(), extendedSegment.n1.getEastNorth().north(), extendedSegment.n2.getEastNorth().east(), extendedSegment.n2.getEastNorth().north());
        }
    }
}

