/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

public class BuildingInBuilding
extends Test {
    protected static final int BUILDING_INSIDE_BUILDING = 2001;
    private final List<OsmPrimitive> primitivesToCheck = new LinkedList<OsmPrimitive>();
    private final QuadBuckets<Way> index = new QuadBuckets();

    public BuildingInBuilding() {
        super(I18n.tr("Building inside building", new Object[0]), I18n.tr("Checks for building areas inside of buildings.", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && BuildingInBuilding.isBuilding(node)) {
            this.primitivesToCheck.add(node);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable() && way.isClosed() && BuildingInBuilding.isBuilding(way)) {
            this.primitivesToCheck.add(way);
            this.index.add(way);
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isUsable() && relation.isMultipolygon() && BuildingInBuilding.isBuilding(relation)) {
            this.primitivesToCheck.add(relation);
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getRole().equals("outer") || !relationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                this.index.add(relationMember.getWay());
            }
        }
    }

    private static boolean isInPolygon(Node node, List<Node> list) {
        return Geometry.nodeInsidePolygon(node, list);
    }

    protected boolean sameLayers(Way way, Way way2) {
        String string = way.get("layer") != null ? way.get("layer") : "0";
        String string2 = way2.get("layer") != null ? way2.get("layer") : "0";
        return string.equals(string2);
    }

    protected boolean isWayInsideMultiPolygon(Way way, Relation relation) {
        MultiPolygonMembers multiPolygonMembers = new MultiPolygonMembers(relation);
        for (Way way2 : multiPolygonMembers.outers) {
            Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(way.getNodes(), way2.getNodes());
            if (polygonIntersection != Geometry.PolygonIntersection.FIRST_INSIDE_SECOND && polygonIntersection != Geometry.PolygonIntersection.CROSSING) continue;
            boolean bl = false;
            for (Way way3 : multiPolygonMembers.inners) {
                if (Geometry.polygonIntersection(way3.getNodes(), way2.getNodes()) != Geometry.PolygonIntersection.FIRST_INSIDE_SECOND || Geometry.polygonIntersection(way.getNodes(), way3.getNodes()) != Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) continue;
                bl = true;
                break;
            }
            if (bl || !this.sameLayers(way, way2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endTest() {
        for (final OsmPrimitive osmPrimitive : this.primitivesToCheck) {
            FilteredCollection<Way> filteredCollection = new FilteredCollection<Way>((Collection<Way>)this.index.search(osmPrimitive.getBBox()), new Predicate<Way>(){

                protected boolean evaluateNode(Node node, Way way) {
                    return BuildingInBuilding.isInPolygon(node, way.getNodes()) || way.getNodes().contains(node);
                }

                protected boolean evaluateWay(Way way, Way way2) {
                    if (way.equals(way2)) {
                        return false;
                    }
                    FilteredCollection<OsmPrimitive> filteredCollection = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)way2.getReferrers(), new Predicate<OsmPrimitive>(){

                        @Override
                        public boolean evaluate(OsmPrimitive osmPrimitive) {
                            return BuildingInBuilding.this.primitivesToCheck.contains(osmPrimitive);
                        }
                    });
                    if (filteredCollection.isEmpty()) {
                        Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(way.getNodes(), way2.getNodes());
                        return (polygonIntersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND || polygonIntersection == Geometry.PolygonIntersection.CROSSING) && BuildingInBuilding.this.sameLayers(way, way2);
                    }
                    for (OsmPrimitive osmPrimitive2 : filteredCollection) {
                        if (!(osmPrimitive2 instanceof Relation) || !BuildingInBuilding.this.isWayInsideMultiPolygon(way, (Relation)osmPrimitive2)) continue;
                        return true;
                    }
                    return false;
                }

                protected boolean evaluateRelation(Relation relation, Way way) {
                    MultiPolygonMembers multiPolygonMembers = new MultiPolygonMembers((Relation)osmPrimitive);
                    for (Way way2 : multiPolygonMembers.outers) {
                        if (!this.evaluateWay(way2, way)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean evaluate(Way way) {
                    if (osmPrimitive.equals(way)) {
                        return false;
                    }
                    if (osmPrimitive instanceof Node) {
                        return this.evaluateNode((Node)osmPrimitive, way);
                    }
                    if (osmPrimitive instanceof Way) {
                        return this.evaluateWay((Way)osmPrimitive, way);
                    }
                    if (osmPrimitive instanceof Relation) {
                        return this.evaluateRelation((Relation)osmPrimitive, way);
                    }
                    return false;
                }
            });
            if (filteredCollection.isEmpty()) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Building inside building", new Object[0]), 2001, osmPrimitive));
        }
        this.primitivesToCheck.clear();
        this.index.clear();
        super.endTest();
    }

    protected class MultiPolygonMembers {
        private final Set<Way> outers = new HashSet<Way>();
        private final Set<Way> inners = new HashSet<Way>();

        public MultiPolygonMembers(Relation relation) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                if (relationMember.getRole().equals("outer")) {
                    this.outers.add(relationMember.getWay());
                    continue;
                }
                if (!relationMember.getRole().equals("inner")) continue;
                this.inners.add(relationMember.getWay());
            }
        }
    }
}

