/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.Addresses;
import org.openstreetmap.josm.data.validation.tests.BarriersEntrances;
import org.openstreetmap.josm.data.validation.tests.BuildingInBuilding;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.DeprecatedTags;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateRelation;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.NodesDuplicatingWayTags;
import org.openstreetmap.josm.data.validation.tests.NodesWithSameName;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.OverlappingAreas;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.PowerLines;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WayConnectedToArea;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmValidator
implements MapView.LayerChangeListener {
    public static ValidatorLayer errorLayer = null;
    public ValidateAction validateAction = new ValidateAction();
    public static double griddetail;
    public static final Collection<String> ignoredErrors;
    private static final Class<Test>[] allAvailableTests;
    private static Map<String, Test> allTestsMap;

    public OsmValidator() {
        this.checkValidatorDir();
        this.initializeGridDetail();
        OsmValidator.initializeTests(OsmValidator.getTests());
        this.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        return Main.pref.getPreferencesDir() + "validator/";
    }

    private void checkValidatorDir() {
        try {
            File file = new File(OsmValidator.getValidatorDir());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadIgnoredErrors() {
        block9: {
            ignoredErrors.clear();
            if (Main.pref.getBoolean("validator.ignore", true)) {
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(OsmValidator.getValidatorDir() + "ignorederrors"));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        ignoredErrors.add(string);
                        string = bufferedReader.readLine();
                    }
                    Utils.close(bufferedReader);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Utils.close(bufferedReader);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Utils.close(bufferedReader);
                }
            }
        }
    }

    public static void addIgnoredError(String string) {
        ignoredErrors.add(string);
    }

    public static boolean hasIgnoredError(String string) {
        return ignoredErrors.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveIgnoredErrors() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(OsmValidator.getValidatorDir() + "ignorederrors"), false);
            for (String string : ignoredErrors) {
                printWriter.println(string);
            }
            Utils.close(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            Utils.close(printWriter);
        }
    }

    public static void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ValidatorLayer();
            Main.main.addLayer(errorLayer);
        }
    }

    public static Map<String, Test> getAllTestsMap() {
        OsmValidator.applyPrefs(allTestsMap, false);
        OsmValidator.applyPrefs(allTestsMap, true);
        return new HashMap<String, Test>(allTestsMap);
    }

    private static void applyPrefs(Map<String, Test> map, boolean bl) {
        Pattern pattern = Pattern.compile("(\\w+)=(true|false),?");
        Matcher matcher = pattern.matcher(Main.pref.get(bl ? "validator.testsBeforeUpload" : "validator.tests"));
        int n = 0;
        while (matcher.find(n)) {
            String string = matcher.group(1);
            Test test = map.get(string);
            if (test != null) {
                boolean bl2 = Boolean.valueOf(matcher.group(2));
                if (bl) {
                    test.testBeforeUpload = bl2;
                } else {
                    test.enabled = bl2;
                }
            }
            n = matcher.end();
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean bl) {
        Collection<Test> collection = OsmValidator.getTests();
        for (Test test : new ArrayList<Test>(collection)) {
            if (bl ? test.testBeforeUpload : test.enabled) continue;
            collection.remove(test);
        }
        return collection;
    }

    public static Class<Test>[] getAllAvailableTests() {
        return Arrays.copyOf(allAvailableTests, allAvailableTests.length);
    }

    public void initializeGridDetail() {
        String string = Main.getProjection().toCode();
        griddetail = Arrays.asList(ProjectionPreference.wgs84.allCodes()).contains(string) ? 10000.0 : (Arrays.asList(ProjectionPreference.mercator.allCodes()).contains(string) ? 0.01 : (Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(string) ? 0.1 : 1.0));
    }

    public static void initializeTests(Collection<Test> collection) {
        for (Test test : collection) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), exception), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer == errorLayer) {
            errorLayer = null;
            return;
        }
        if (Main.map.mapView.getLayersOfType(OsmDataLayer.class).isEmpty() && errorLayer != null) {
            Main.main.removeLayer(errorLayer);
        }
    }

    static {
        ignoredErrors = new TreeSet<String>();
        allAvailableTests = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.class, SimilarNamedWays.class, NodesWithSameName.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class, DuplicateRelation.class, BuildingInBuilding.class, DeprecatedTags.class, OverlappingAreas.class, WayConnectedToArea.class, NodesDuplicatingWayTags.class, PowerLines.class, Addresses.class, Highways.class, BarriersEntrances.class, OpeningHourTest.class};
        allTestsMap = new HashMap<String, Test>();
        for (Class<Test> clazz : allAvailableTests) {
            try {
                allTestsMap.put(clazz.getSimpleName(), clazz.newInstance());
            }
            catch (Exception exception) {
                Main.error(exception);
            }
        }
    }
}

