/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class DatasetConsistencyTest {
    private static final int MAX_ERRORS = 100;
    private final DataSet dataSet;
    private final PrintWriter writer;
    private int errorCount;

    public DatasetConsistencyTest(DataSet dataSet, Writer writer) {
        this.dataSet = dataSet;
        this.writer = new PrintWriter(writer);
    }

    private void printError(String string, String string2, Object ... objectArray) {
        ++this.errorCount;
        if (this.errorCount <= 100) {
            this.writer.println("[" + string + "] " + String.format(string2, objectArray));
        }
    }

    public void checkReferrers() {
        for (Way osmPrimitive : this.dataSet.getWays()) {
            if (osmPrimitive.isDeleted()) continue;
            for (Node node : osmPrimitive.getNodes()) {
                if (node.getDataSet() == null || node.getReferrers().contains(osmPrimitive)) continue;
                this.printError("WAY NOT IN REFERRERS", "%s is part of %s but is not in referrers", node, osmPrimitive);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            if (relation.isDeleted()) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().getDataSet() == null || relationMember.getMember().getReferrers().contains(relation)) continue;
                this.printError("RELATION NOT IN REFERRERS", "%s is part of %s but is not in referrers", relationMember.getMember(), relation);
            }
        }
    }

    public void checkCompleteWaysWithIncompleteNodes() {
        for (Way way : this.dataSet.getWays()) {
            if (!way.isUsable()) continue;
            for (Node node : way.getNodes()) {
                if (!node.isIncomplete()) continue;
                this.printError("USABLE HAS INCOMPLETE", "%s is usable but contains incomplete node '%s'", way, node);
            }
        }
    }

    public void checkCompleteNodesWithoutCoordinates() {
        for (Node node : this.dataSet.getNodes()) {
            if (node.isIncomplete() || !node.isVisible() || node.getCoor() != null && node.getEastNorth() != null) continue;
            this.printError("COMPLETE WITHOUT COORDINATES", "%s is not incomplete but has null coordinates", node);
        }
    }

    public void searchNodes() {
        for (Node node : this.dataSet.getNodes()) {
            BBox bBox;
            LatLon latLon;
            if (node.isIncomplete() || node.isDeleted() || (latLon = node.getCoor()) == null || this.dataSet.searchNodes(bBox = latLon.toBBox(1.0E-4)).contains(node)) continue;
            this.printError("SEARCH NODES", "%s not found using Dataset.searchNodes()", node);
        }
    }

    public void searchWays() {
        for (Way way : this.dataSet.getWays()) {
            if (way.isIncomplete() || way.isDeleted() || way.getNodesCount() < 2 || this.dataSet.searchWays(way.getBBox()).contains(way)) continue;
            this.printError("SEARCH WAYS", "%s not found using Dataset.searchWays()", way);
        }
    }

    private void checkReferredPrimitive(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive.getDataSet() == null) {
            this.printError("NO DATASET", "%s is referenced by %s but not found in dataset", osmPrimitive, osmPrimitive2);
        } else if (this.dataSet.getPrimitiveById(osmPrimitive) == null) {
            this.printError("REFERENCED BUT NOT IN DATA", "%s is referenced by %s but not found in dataset", osmPrimitive, osmPrimitive2);
        } else if (this.dataSet.getPrimitiveById(osmPrimitive) != osmPrimitive) {
            this.printError("DIFFERENT INSTANCE", "%s is different instance that referred by %s", osmPrimitive, osmPrimitive2);
        }
        if (osmPrimitive.isDeleted()) {
            this.printError("DELETED REFERENCED", "%s refers to deleted primitive %s", osmPrimitive2, osmPrimitive);
        }
    }

    public void referredPrimitiveNotInDataset() {
        for (Way osmPrimitive : this.dataSet.getWays()) {
            for (Node node : osmPrimitive.getNodes()) {
                this.checkReferredPrimitive(node, osmPrimitive);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            for (RelationMember relationMember : relation.getMembers()) {
                this.checkReferredPrimitive(relationMember.getMember(), relation);
            }
        }
    }

    public void checkZeroNodesWays() {
        for (Way way : this.dataSet.getWays()) {
            if (way.isUsable() && way.getNodesCount() == 0) {
                this.printError("WARN - ZERO NODES", "Way %s has zero nodes", way);
                continue;
            }
            if (!way.isUsable() || way.getNodesCount() != 1) continue;
            this.printError("WARN - NO NODES", "Way %s has only one node", way);
        }
    }

    public void runTest() {
        try {
            this.referredPrimitiveNotInDataset();
            this.checkReferrers();
            this.checkCompleteWaysWithIncompleteNodes();
            this.checkCompleteNodesWithoutCoordinates();
            this.searchNodes();
            this.searchWays();
            this.checkZeroNodesWays();
            if (this.errorCount > 100) {
                this.writer.println(this.errorCount - 100 + " more...");
            }
        }
        catch (Exception exception) {
            this.writer.println("Exception during dataset integrity test:");
            exception.printStackTrace(this.writer);
        }
    }

    public static String runTests(DataSet dataSet) {
        StringWriter stringWriter = new StringWriter();
        new DatasetConsistencyTest(dataSet, stringWriter).runTest();
        return stringWriter.toString();
    }
}

