/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.io.DownloadFileTask;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CustomConfigurator {
    private static StringBuilder summary = new StringBuilder();
    private static boolean busy = false;

    private CustomConfigurator() {
    }

    public static void log(String string, Object ... objectArray) {
        summary.append(String.format(string, objectArray));
    }

    public static void log(String string) {
        summary.append(string);
        summary.append("\n");
    }

    public static String getLog() {
        return summary.toString();
    }

    public static void readXML(String string, String string2) {
        CustomConfigurator.readXML(new File(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readXML(File file, Preferences preferences) {
        Class<CustomConfigurator> clazz = CustomConfigurator.class;
        synchronized (CustomConfigurator.class) {
            busy = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            new XMLCommandProcessor(preferences).openAndReadXML(file);
            clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                CustomConfigurator.class.notifyAll();
                busy = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static void readXML(File file) {
        CustomConfigurator.readXML(file, Main.pref);
    }

    public static void downloadFile(String string, String string2, String string3) {
        CustomConfigurator.processDownloadOperation(string, string2, CustomConfigurator.getDirectoryByAbbr(string3), true, false);
    }

    public static void downloadAndUnpackFile(String string, String string2, String string3) {
        CustomConfigurator.processDownloadOperation(string, string2, CustomConfigurator.getDirectoryByAbbr(string3), true, true);
    }

    public static void processDownloadOperation(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4 = string3;
        if (string2.contains("..") || string2.startsWith("/") || string2.contains(":")) {
            return;
        }
        File file = new File(string4, string2);
        DownloadFileTask downloadFileTask = new DownloadFileTask(Main.parent, string, file, bl, bl2);
        Main.worker.submit(downloadFileTask);
        CustomConfigurator.log("Info: downloading file from %s to %s in background ", string3, file.getAbsolutePath());
        if (bl2) {
            CustomConfigurator.log("and unpacking it");
        } else {
            CustomConfigurator.log("");
        }
    }

    public static void messageBox(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "plain";
        }
        switch (string.charAt(0)) {
            case 'i': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Information", new Object[0]), 1);
                break;
            }
            case 'w': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Warning", new Object[0]), 2);
                break;
            }
            case 'e': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Error", new Object[0]), 0);
                break;
            }
            case 'q': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Question", new Object[0]), 3);
                break;
            }
            case 'p': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Message", new Object[0]), -1);
            }
        }
    }

    public static int askForOption(String string, String string2) {
        Integer n;
        if (string2.length() > 0) {
            Object[] objectArray = string2.split(";");
            n = JOptionPane.showOptionDialog(Main.parent, string, "Question", 1, 3, null, objectArray, 0);
        } else {
            n = JOptionPane.showOptionDialog(Main.parent, string, "Question", 1, 3, null, null, 2);
        }
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static String askForText(String string) {
        String string2 = JOptionPane.showInputDialog(Main.parent, string, I18n.tr("Enter text", new Object[0]), 3);
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            return string2;
        }
        return "";
    }

    public static void exportPreferencesKeysToFile(String string, boolean bl, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, stringArray);
        CustomConfigurator.exportPreferencesKeysToFile(string, bl, hashSet);
    }

    public static void exportPreferencesKeysByPatternToFile(String string, boolean bl, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Preferences.Setting> map = Main.pref.getAllSettings();
        for (String string3 : map.keySet()) {
            if (!string3.matches(string2)) continue;
            arrayList.add(string3);
        }
        CustomConfigurator.exportPreferencesKeysToFile(string, bl, arrayList);
    }

    public static void exportPreferencesKeysToFile(String string, boolean bl, Collection<String> collection) {
        Object object;
        Object object2;
        Object object3;
        Element element = null;
        Document document = null;
        Document document2 = null;
        try {
            object3 = Main.pref.toXML(true);
            object2 = new ByteArrayInputStream(((String)object3).getBytes("UTF-8"));
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(false);
            ((DocumentBuilderFactory)object).setNamespaceAware(false);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            document = documentBuilder.parse((InputStream)object2);
            document2 = documentBuilder.newDocument();
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            Main.warn("Error getting preferences to save:" + exception.getMessage());
        }
        if (element == null) {
            return;
        }
        try {
            Object object4;
            object3 = document2.createElement("config");
            document2.appendChild((Node)object3);
            object2 = document2.createElement("preferences");
            object2.setAttribute("operation", bl ? "append" : "replace");
            object3.appendChild((Node)object2);
            object = element.getChildNodes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                object4 = object.item(i);
                if (object4.getNodeType() != 1 || !collection.contains(string2 = ((Element)object4).getAttribute("key"))) continue;
                Node node = document2.importNode((Node)object4, true);
                object2.appendChild(node);
            }
            File file = new File(string);
            object4 = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object4).setOutputProperty("indent", "yes");
            ((Transformer)object4).transform(new DOMSource(document2), new StreamResult(file.toURI().getPath()));
        }
        catch (Exception exception) {
            Main.warn("Error saving preferences part: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void deleteFile(String string, String string2) {
        String string3 = CustomConfigurator.getDirectoryByAbbr(string2);
        if (string3 == null) {
            CustomConfigurator.log("Error: Can not find base, use base=cache, base=prefs or base=plugins attribute.");
            return;
        }
        CustomConfigurator.log("Delete file: %s\n", string);
        if (string.contains("..") || string.startsWith("/") || string.contains(":")) {
            return;
        }
        File file = new File(string3, string);
        if (file.exists()) {
            CustomConfigurator.deleteFileOrDirectory(file);
        }
    }

    public static void deleteFileOrDirectory(String string) {
        CustomConfigurator.deleteFileOrDirectory(new File(string));
    }

    public static void deleteFileOrDirectory(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                CustomConfigurator.deleteFileOrDirectory(file2);
            }
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            CustomConfigurator.log("Warning: Can not delete file " + file.getPath());
        }
    }

    public static void pluginOperation(String string, String string2, String string3) {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        final ArrayList arrayList3 = new ArrayList();
        Collections.addAll(arrayList, string.toLowerCase().split(";"));
        Collections.addAll(arrayList2, string2.toLowerCase().split(";"));
        Collections.addAll(arrayList3, string3.toLowerCase().split(";"));
        arrayList.remove("");
        arrayList2.remove("");
        arrayList3.remove("");
        if (!arrayList.isEmpty()) {
            CustomConfigurator.log("Plugins install: " + arrayList);
        }
        if (!arrayList2.isEmpty()) {
            CustomConfigurator.log("Plugins turn off: " + arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            CustomConfigurator.log("Plugins delete: " + arrayList3);
        }
        final ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (readLocalPluginInformationTask.isCanceled()) {
                    return;
                }
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    try {
                        while (busy) {
                            CustomConfigurator.class.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Main.warn("InterruptedException while reading local plugin information");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object object;
                            List<PluginInformation> list = readLocalPluginInformationTask.getAvailablePlugins();
                            ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>();
                            ArrayList<PluginInformation> arrayList2 = new ArrayList<PluginInformation>();
                            ArrayList<PluginInformation> arrayList3 = new ArrayList<PluginInformation>();
                            for (PluginInformation iterator : list) {
                                String string = iterator.name.toLowerCase();
                                if (arrayList.contains(string)) {
                                    arrayList.add(iterator);
                                }
                                if (arrayList2.contains(string)) {
                                    arrayList2.add(iterator);
                                }
                                if (!arrayList3.contains(string)) continue;
                                arrayList3.add(iterator);
                            }
                            if (!arrayList.isEmpty()) {
                                object = new PluginDownloadTask(Main.parent, arrayList, I18n.tr("Installing plugins", new Object[0]));
                                Main.worker.submit((Runnable)object);
                            }
                            object = new ArrayList<String>(Main.pref.getCollection("plugins"));
                            for (PluginInformation pluginInformation : arrayList) {
                                if (object.contains(pluginInformation.name)) continue;
                                object.add(pluginInformation.name);
                            }
                            for (PluginInformation pluginInformation : arrayList2) {
                                object.remove(pluginInformation.name);
                            }
                            for (PluginInformation pluginInformation : arrayList3) {
                                object.remove(pluginInformation.name);
                                new File(Main.pref.getPluginsDirectory(), pluginInformation.name + ".jar").deleteOnExit();
                            }
                            Main.pref.putCollection("plugins", (Collection<String>)object);
                        }
                    });
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        Main.worker.submit(readLocalPluginInformationTask);
        Main.worker.submit(runnable);
    }

    private static String getDirectoryByAbbr(String string) {
        String string2 = "prefs".equals(string) || string.length() == 0 ? Main.pref.getPreferencesDir() : ("cache".equals(string) ? Main.pref.getCacheDirectory().getAbsolutePath() : ("plugins".equals(string) ? Main.pref.getPluginsDirectory().getAbsolutePath() : null));
        return string2;
    }

    public static Preferences clonePreferences(Preferences preferences) {
        Preferences preferences2 = new Preferences();
        preferences2.defaults.putAll(preferences.defaults);
        preferences2.properties.putAll(preferences.properties);
        preferences2.arrayDefaults.putAll(preferences.arrayDefaults);
        preferences2.arrayProperties.putAll(preferences.arrayProperties);
        preferences2.collectionDefaults.putAll(preferences.collectionDefaults);
        preferences2.collectionProperties.putAll(preferences.collectionProperties);
        preferences2.listOfStructsDefaults.putAll(preferences.listOfStructsDefaults);
        preferences2.listOfStructsProperties.putAll(preferences.listOfStructsProperties);
        preferences2.colornames.putAll(preferences.colornames);
        return preferences2;
    }

    public static class PreferencesUtils {
        private static void replacePreferences(Preferences preferences, Preferences preferences2) {
            for (Map.Entry<String, String> entry : preferences.properties.entrySet()) {
                preferences2.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : preferences.collectionProperties.entrySet()) {
                preferences2.putCollection(entry.getKey(), (Collection)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : preferences.arrayProperties.entrySet()) {
                ArrayList<Collection<String>> arrayList = new ArrayList<Collection<String>>();
                arrayList.addAll((Collection)entry.getValue());
                preferences2.putArray(entry.getKey(), arrayList);
            }
            for (Map.Entry<String, Object> entry : preferences.listOfStructsProperties.entrySet()) {
                preferences2.putListOfStructs(entry.getKey(), (Collection)entry.getValue());
            }
        }

        private static void appendPreferences(Preferences preferences, Preferences preferences2) {
            Collection<Object> collection;
            String string;
            for (Map.Entry<String, String> entry : preferences.properties.entrySet()) {
                preferences2.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : preferences.collectionProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getCollection(preferences2, string, true);
                if (collection == null) continue;
                for (Object object : (List)entry.getValue()) {
                    if (collection.contains(object)) continue;
                    collection.add(object);
                }
                preferences2.putCollection(entry.getKey(), collection);
            }
            for (Map.Entry<String, Object> entry : preferences.arrayProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getArray(preferences2, string, true);
                if (collection == null) continue;
                for (Object object : (List)entry.getValue()) {
                    if (collection.contains(object)) continue;
                    collection.add(object);
                }
                preferences2.putArray(entry.getKey(), collection);
            }
            for (Map.Entry<String, Object> entry : preferences.listOfStructsProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getListOfStructs(preferences2, string, true);
                if (collection == null) continue;
                for (Object object : (List)entry.getValue()) {
                    if (collection.contains(object)) continue;
                    collection.add(object);
                }
                preferences2.putListOfStructs(entry.getKey(), collection);
            }
        }

        private static void deletePreferenceValues(Preferences preferences, Preferences preferences2) {
            Iterator<Object> iterator;
            Object object2;
            Collection<Object> collection;
            String string;
            for (Map.Entry<String, String> entry : preferences.properties.entrySet()) {
                if (!entry.getValue().equals(preferences2.properties.get(entry.getKey()))) continue;
                preferences2.put(entry.getKey(), null);
            }
            for (Map.Entry<String, Object> entry : preferences.collectionProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getCollection(preferences2, string, true);
                if (collection == null) continue;
                for (Object object2 : (List)entry.getValue()) {
                    CustomConfigurator.log("Deleting preferences: from list %s: %s\n", string, object2);
                    collection.remove(object2);
                }
                preferences2.putCollection(entry.getKey(), collection);
            }
            for (Map.Entry<String, Object> entry : preferences.arrayProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getArray(preferences2, string, true);
                if (collection == null) continue;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (Collection)iterator.next();
                    for (Object object3 : (List)entry.getValue()) {
                        if (!object2.containsAll((Collection<?>)object3)) continue;
                        CustomConfigurator.log("Deleting preferences: list from lists %s: %s\n", string, object2);
                        iterator.remove();
                    }
                }
                preferences2.putArray(entry.getKey(), collection);
            }
            for (Map.Entry<String, Object> entry : preferences.listOfStructsProperties.entrySet()) {
                string = entry.getKey();
                collection = PreferencesUtils.getListOfStructs(preferences2, string, true);
                if (collection == null) continue;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (Map)iterator.next();
                    for (Object object3 : (List)entry.getValue()) {
                        if (!object2.entrySet().containsAll(object3.entrySet())) continue;
                        CustomConfigurator.log("Deleting preferences: deleting map from maps %s: %s\n", string, object2);
                        iterator.remove();
                    }
                }
                preferences2.putListOfStructs(entry.getKey(), collection);
            }
        }

        private static void deletePreferenceKeyByPattern(String string, Preferences preferences) {
            Map<String, Preferences.Setting> map = preferences.getAllSettings();
            for (Map.Entry<String, Preferences.Setting> entry : map.entrySet()) {
                String string2 = entry.getKey();
                if (!string2.matches(string)) continue;
                CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + string2);
                preferences.putSetting(string2, entry.getValue().getNullInstance());
            }
        }

        private static void deletePreferenceKey(String string, Preferences preferences) {
            Map<String, Preferences.Setting> map = preferences.getAllSettings();
            if (map.containsKey(string)) {
                CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + string);
                preferences.putSetting(string, map.get(string).getNullInstance());
            }
        }

        private static Collection<String> getCollection(Preferences preferences, String string, boolean bl) {
            Collection collection = (Collection)preferences.collectionProperties.get(string);
            Collection collection2 = (Collection)preferences.collectionDefaults.get(string);
            if (collection == null && collection2 == null) {
                if (bl) {
                    PreferencesUtils.defaultUnknownWarning(string);
                }
                return null;
            }
            return collection != null ? new ArrayList<String>(collection) : new ArrayList(collection2);
        }

        private static Collection<Collection<String>> getArray(Preferences preferences, String string, boolean bl) {
            Collection collection = (Collection)preferences.arrayProperties.get(string);
            Collection collection2 = (Collection)preferences.arrayDefaults.get(string);
            if (collection == null && collection2 == null) {
                if (bl) {
                    PreferencesUtils.defaultUnknownWarning(string);
                }
                return null;
            }
            return collection != null ? new ArrayList<Collection<String>>(collection) : new ArrayList(collection2);
        }

        private static List<Map<String, String>> getListOfStructs(Preferences preferences, String string, boolean bl) {
            Collection collection = (Collection)preferences.listOfStructsProperties.get(string);
            Collection collection2 = (Collection)preferences.listOfStructsDefaults.get(string);
            if (collection == null && collection2 == null) {
                if (bl) {
                    PreferencesUtils.defaultUnknownWarning(string);
                }
                return null;
            }
            return collection != null ? new ArrayList<Map<String, String>>(collection) : new ArrayList(collection2);
        }

        private static void defaultUnknownWarning(String string) {
            CustomConfigurator.log("Warning: Unknown default value of %s , skipped\n", string);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Settings file asks to append preferences to <b>{0}</b>,<br/> but its default value is unknown at this moment.<br/> Please activate corresponding function manually and retry importing.", string), I18n.tr("Warning", new Object[0]), 2);
        }

        private static void showPrefs(Preferences preferences) {
            Main.info("properties: " + preferences.properties);
            Main.info("collections: " + preferences.collectionProperties);
            Main.info("arrays: " + preferences.arrayProperties);
            Main.info("maps: " + preferences.listOfStructsProperties);
        }

        private static void modifyPreferencesByScript(ScriptEngine scriptEngine, Preferences preferences, String string) throws ScriptException {
            PreferencesUtils.loadPrefsToJS(scriptEngine, preferences, "API.pref", true);
            scriptEngine.eval(string);
            PreferencesUtils.readPrefsFromJS(scriptEngine, preferences, "API.pref");
        }

        public static void readPrefsFromJS(ScriptEngine scriptEngine, Preferences preferences, String string) throws ScriptException {
            String string2 = "stringMap = new java.util.TreeMap ;listMap =  new java.util.TreeMap ;listlistMap = new java.util.TreeMap ;listmapMap =  new java.util.TreeMap ;for (key in " + string + ") {" + "  val = " + string + "[key];" + "  type = typeof val == 'string' ? 'string' : val.type;" + "  if (type == 'string') {" + "    stringMap.put(key, val);" + "  } else if (type == 'list') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      l.add(java.lang.String.valueOf(val[i]));" + "    }" + "    listMap.put(key, l);" + "  } else if (type == 'listlist') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      list=val[i];" + "      jlist=new java.util.ArrayList;" + "      for (j=0; j<list.length; j++) {" + "         jlist.add(java.lang.String.valueOf(list[j]));" + "      }" + "      l.add(jlist);" + "    }" + "    listlistMap.put(key, l);" + "  } else if (type == 'listmap') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      map=val[i];" + "      jmap=new java.util.TreeMap;" + "      for (var key2 in map) {" + "         jmap.put(key2,java.lang.String.valueOf(map[key2]));" + "      }" + "      l.add(jmap);" + "    }" + "    listmapMap.put(key, l);" + "  }  else {" + "   org.openstreetmap.josm.data.CustomConfigurator.log('Unknown type:'+val.type+ '- use list, listlist or listmap'); }" + "  }";
            scriptEngine.eval(string2);
            Map map = (Map)scriptEngine.get("stringMap");
            SortedMap sortedMap = (SortedMap)scriptEngine.get("listMap");
            SortedMap sortedMap2 = (SortedMap)scriptEngine.get("listlistMap");
            SortedMap sortedMap3 = (SortedMap)scriptEngine.get("listmapMap");
            preferences.properties.clear();
            preferences.collectionProperties.clear();
            preferences.arrayProperties.clear();
            preferences.listOfStructsProperties.clear();
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getValue()).equals(preferences.defaults.get(entry.getKey()))) continue;
                preferences.properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                if (Preferences.equalCollection((Collection)entry.getValue(), (Collection)preferences.collectionDefaults.get(entry.getKey()))) continue;
                preferences.collectionProperties.put((String)entry.getKey(), (List<String>)entry.getValue());
            }
            for (Map.Entry entry : sortedMap2.entrySet()) {
                if (Preferences.equalArray((Collection)entry.getValue(), (Collection)preferences.arrayDefaults.get(entry.getKey()))) continue;
                List list = (List)entry.getValue();
                preferences.arrayProperties.put((String)entry.getKey(), list);
            }
            for (Map.Entry entry : sortedMap3.entrySet()) {
                if (Preferences.equalListOfStructs((Collection)entry.getValue(), (Collection)preferences.listOfStructsDefaults.get(entry.getKey()))) continue;
                preferences.listOfStructsProperties.put((String)entry.getKey(), (List<Map<String, String>>)entry.getValue());
            }
        }

        public static void loadPrefsToJS(ScriptEngine scriptEngine, Preferences preferences, String string, boolean bl) throws ScriptException {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            TreeMap<String, List<String>> treeMap2 = new TreeMap<String, List<String>>();
            TreeMap<String, List<List<String>>> treeMap3 = new TreeMap<String, List<List<String>>>();
            TreeMap<String, List<Map<String, String>>> treeMap4 = new TreeMap<String, List<Map<String, String>>>();
            if (bl) {
                treeMap.putAll(preferences.defaults);
                treeMap2.putAll(preferences.collectionDefaults);
                treeMap3.putAll(preferences.arrayDefaults);
                treeMap4.putAll(preferences.listOfStructsDefaults);
            }
            while (treeMap.values().remove(null)) {
            }
            while (treeMap2.values().remove(null)) {
            }
            while (treeMap3.values().remove(null)) {
            }
            while (treeMap4.values().remove(null)) {
            }
            treeMap.putAll(preferences.properties);
            treeMap2.putAll(preferences.collectionProperties);
            treeMap3.putAll(preferences.arrayProperties);
            treeMap4.putAll(preferences.listOfStructsProperties);
            scriptEngine.put("stringMap", treeMap);
            scriptEngine.put("listMap", treeMap2);
            scriptEngine.put("listlistMap", treeMap3);
            scriptEngine.put("listmapMap", treeMap4);
            String string2 = "function getJSList( javaList ) { var jsList; var i;  if (javaList == null) return null;jsList = [];  for (i = 0; i < javaList.size(); i++) {    jsList.push(String(list.get(i)));  }return jsList;}function getJSMap( javaMap ) { var jsMap; var it; var e;  if (javaMap == null) return null; jsMap = {}; for (it = javaMap.entrySet().iterator(); it.hasNext();) {    e = it.next();    jsMap[ String(e.getKey()) ] = String(e.getValue());   }  return jsMap;}for (it = stringMap.entrySet().iterator(); it.hasNext();) {  e = it.next();" + string + "[String(e.getKey())] = String(e.getValue());" + "}\n" + "for (it = listMap.entrySet().iterator(); it.hasNext();) {" + "  e = it.next();" + "  list = e.getValue();" + "  jslist = getJSList(list);" + "  jslist.type = 'list';" + string + "[String(e.getKey())] = jslist;" + "}\n" + "for (it = listlistMap.entrySet().iterator(); it.hasNext(); ) {" + "  e = it.next();" + "  listlist = e.getValue();" + "  jslistlist = [];" + "  for (it2 = listlist.iterator(); it2.hasNext(); ) {" + "    list = it2.next(); " + "    jslistlist.push(getJSList(list));" + "    }" + "  jslistlist.type = 'listlist';" + string + "[String(e.getKey())] = jslistlist;" + "}\n" + "for (it = listmapMap.entrySet().iterator(); it.hasNext();) {" + "  e = it.next();" + "  listmap = e.getValue();" + "  jslistmap = [];" + "  for (it2 = listmap.iterator(); it2.hasNext();) {" + "    map = it2.next();" + "    jslistmap.push(getJSMap(map));" + "    }" + "  jslistmap.type = 'listmap';" + string + "[String(e.getKey())] = jslistmap;" + "}\n";
            scriptEngine.eval(string2);
        }
    }

    public static class XMLCommandProcessor {
        Preferences mainPrefs;
        Map<String, Element> tasksMap = new HashMap<String, Element>();
        private boolean lastV;
        ScriptEngine engine;

        public void openAndReadXML(File file) {
            CustomConfigurator.log("-- Reading custom preferences from " + file.getAbsolutePath() + " --");
            try {
                String string = file.getParentFile().getAbsolutePath();
                if (string != null) {
                    this.engine.eval("scriptDir='" + this.normalizeDirName(string) + "';");
                }
                this.openAndReadXML(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (Exception exception) {
                CustomConfigurator.log("Error reading custom preferences: " + exception.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void openAndReadXML(InputStream inputStream) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    this.processXML(document);
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                CustomConfigurator.log("Error reading custom preferences: " + exception.getMessage());
            }
            finally {
                Utils.close(inputStream);
            }
            {
                CustomConfigurator.log("-- Reading complete --");
                return;
            }
        }

        public XMLCommandProcessor(Preferences preferences) {
            try {
                this.mainPrefs = preferences;
                summary = new StringBuilder();
                this.engine = new ScriptEngineManager().getEngineByName("rhino");
                this.engine.eval("API={}; API.pref={}; API.fragments={};");
                this.engine.eval("homeDir='" + this.normalizeDirName(Main.pref.getPreferencesDir()) + "';");
                this.engine.eval("josmVersion=" + Version.getInstance().getVersion() + ";");
                String string = CustomConfigurator.class.getName();
                this.engine.eval("API.messageBox=" + string + ".messageBox");
                this.engine.eval("API.askText=function(text) { return String(" + string + ".askForText(text));}");
                this.engine.eval("API.askOption=" + string + ".askForOption");
                this.engine.eval("API.downloadFile=" + string + ".downloadFile");
                this.engine.eval("API.downloadAndUnpackFile=" + string + ".downloadAndUnpackFile");
                this.engine.eval("API.deleteFile=" + string + ".deleteFile");
                this.engine.eval("API.plugin =" + string + ".pluginOperation");
                this.engine.eval("API.pluginInstall = function(names) { " + string + ".pluginOperation(names,'','');}");
                this.engine.eval("API.pluginUninstall = function(names) { " + string + ".pluginOperation('',names,'');}");
                this.engine.eval("API.pluginDelete = function(names) { " + string + ".pluginOperation('','',names);}");
            }
            catch (Exception exception) {
                CustomConfigurator.log("Error: initializing script engine: " + exception.getMessage());
            }
        }

        private void processXML(Document document) {
            Element element = document.getDocumentElement();
            this.processXmlFragment(element);
        }

        private void processXmlFragment(Element element) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string = node.getNodeName();
                Element element2 = (Element)node;
                if ("var".equals(string)) {
                    this.setVar(element2.getAttribute("name"), this.evalVars(element2.getAttribute("value")));
                    continue;
                }
                if ("task".equals(string)) {
                    this.tasksMap.put(element2.getAttribute("name"), element2);
                    continue;
                }
                if ("runtask".equals(string)) {
                    if (!this.processRunTaskElement(element2)) continue;
                    return;
                }
                if ("ask".equals(string)) {
                    this.processAskElement(element2);
                    continue;
                }
                if ("if".equals(string)) {
                    this.processIfElement(element2);
                    continue;
                }
                if ("else".equals(string)) {
                    this.processElseElement(element2);
                    continue;
                }
                if ("break".equals(string)) {
                    return;
                }
                if ("plugin".equals(string)) {
                    this.processPluginInstallElement(element2);
                    continue;
                }
                if ("messagebox".equals(string)) {
                    this.processMsgBoxElement(element2);
                    continue;
                }
                if ("preferences".equals(string)) {
                    this.processPreferencesElement(element2);
                    continue;
                }
                if ("download".equals(string)) {
                    this.processDownloadElement(element2);
                    continue;
                }
                if ("delete".equals(string)) {
                    this.processDeleteElement(element2);
                    continue;
                }
                if ("script".equals(string)) {
                    this.processScriptElement(element2);
                    continue;
                }
                CustomConfigurator.log("Error: Unknown element " + string);
            }
        }

        private void processPreferencesElement(Element element) {
            String string = this.evalVars(element.getAttribute("operation"));
            String string2 = this.evalVars(element.getAttribute("id"));
            if ("delete-keys".equals(string)) {
                String string3 = this.evalVars(element.getAttribute("pattern"));
                String string4 = this.evalVars(element.getAttribute("key"));
                if (string4 != null) {
                    PreferencesUtils.deletePreferenceKey(string4, this.mainPrefs);
                }
                if (string3 != null) {
                    PreferencesUtils.deletePreferenceKeyByPattern(string3, this.mainPrefs);
                }
                return;
            }
            Preferences preferences = this.readPreferencesFromDOMElement(element);
            PreferencesUtils.showPrefs(preferences);
            if (string2.length() > 0) {
                try {
                    String string5 = "API.fragments['" + string2 + "']";
                    this.engine.eval(string5 + "={};");
                    PreferencesUtils.loadPrefsToJS(this.engine, preferences, string5, false);
                }
                catch (ScriptException scriptException) {
                    CustomConfigurator.log("Error: can not load preferences fragment : " + scriptException.getMessage());
                }
            }
            if ("replace".equals(string)) {
                CustomConfigurator.log("Preferences replace: %d keys: %s\n", preferences.getAllSettings().size(), preferences.getAllSettings().keySet().toString());
                PreferencesUtils.replacePreferences(preferences, this.mainPrefs);
            } else if ("append".equals(string)) {
                CustomConfigurator.log("Preferences append: %d keys: %s\n", preferences.getAllSettings().size(), preferences.getAllSettings().keySet().toString());
                PreferencesUtils.appendPreferences(preferences, this.mainPrefs);
            } else if ("delete-values".equals(string)) {
                PreferencesUtils.deletePreferenceValues(preferences, this.mainPrefs);
            }
        }

        private void processDeleteElement(Element element) {
            String string = this.evalVars(element.getAttribute("path"));
            String string2 = this.evalVars(element.getAttribute("base"));
            CustomConfigurator.deleteFile(string2, string);
        }

        private void processDownloadElement(Element element) {
            String string = this.evalVars(element.getAttribute("url"));
            String string2 = this.evalVars(element.getAttribute("path"));
            String string3 = this.evalVars(element.getAttribute("unzip"));
            String string4 = this.evalVars(element.getAttribute("mkdir"));
            String string5 = this.evalVars(element.getAttribute("base"));
            String string6 = CustomConfigurator.getDirectoryByAbbr(string5);
            if (string6 == null) {
                CustomConfigurator.log("Error: Can not find directory to place file, use base=cache, base=prefs or base=plugins attribute.");
                return;
            }
            if (string2.contains("..") || string2.startsWith("/") || string2.contains(":")) {
                return;
            }
            if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
                CustomConfigurator.log("Error: Please specify url=\"where to get file\" and path=\"where to place it\"");
                return;
            }
            CustomConfigurator.processDownloadOperation(string, string2, string6, "true".equals(string4), "true".equals(string3));
        }

        private void processPluginInstallElement(Element element) {
            String string = element.getAttribute("install");
            String string2 = element.getAttribute("remove");
            String string3 = element.getAttribute("delete");
            CustomConfigurator.pluginOperation(string, string2, string3);
        }

        private void processMsgBoxElement(Element element) {
            String string = this.evalVars(element.getAttribute("text"));
            String string2 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (string2 != null && string2.length() > 0) {
                string = string2;
            }
            String string3 = this.evalVars(element.getAttribute("type"));
            CustomConfigurator.messageBox(string3, string);
        }

        private void processAskElement(Element element) {
            String string;
            String string2;
            String string3 = this.evalVars(element.getAttribute("text"));
            String string4 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (string4.length() > 0) {
                string3 = string4;
            }
            if ((string2 = element.getAttribute("var")).length() == 0) {
                string2 = "result";
            }
            if ("true".equals(string = this.evalVars(element.getAttribute("input")))) {
                this.setVar(string2, CustomConfigurator.askForText(string3));
            } else {
                String string5 = this.evalVars(element.getAttribute("options"));
                String string6 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".options"));
                if (string6.length() > 0) {
                    string5 = string6;
                }
                this.setVar(string2, String.valueOf(CustomConfigurator.askForOption(string3, string5)));
            }
        }

        public void setVar(String string, String string2) {
            try {
                this.engine.eval(string + "='" + string2 + "';");
            }
            catch (ScriptException scriptException) {
                CustomConfigurator.log("Error: Can not assign variable: %s=%s  : %s\n", string, string2, scriptException.getMessage());
            }
        }

        private void processIfElement(Element element) {
            String string = this.evalVars(element.getAttribute("test"));
            boolean bl = false;
            if ("true".equals(string)) {
                bl = true;
            } else if ("fales".equals(string)) {
                bl = true;
            } else {
                CustomConfigurator.log("Error: Illegal test expression in if: %s=%s\n", element.getAttribute("test"), string);
            }
            if (bl) {
                this.processXmlFragment(element);
            }
            this.lastV = bl;
        }

        private void processElseElement(Element element) {
            if (!this.lastV) {
                this.processXmlFragment(element);
            }
        }

        private boolean processRunTaskElement(Element element) {
            String string = element.getAttribute("name");
            Element element2 = this.tasksMap.get(string);
            if (element2 == null) {
                CustomConfigurator.log("Error: Can not execute task " + string);
                return true;
            }
            CustomConfigurator.log("EXECUTING TASK " + string);
            this.processXmlFragment(element2);
            return false;
        }

        private void processScriptElement(Element element) {
            String string = element.getChildNodes().item(0).getTextContent();
            CustomConfigurator.log("Processing script...");
            try {
                PreferencesUtils.modifyPreferencesByScript(this.engine, this.mainPrefs, string);
            }
            catch (ScriptException scriptException) {
                CustomConfigurator.messageBox("e", scriptException.getMessage());
                CustomConfigurator.log("JS error: " + scriptException.getMessage());
            }
            CustomConfigurator.log("Script finished");
        }

        private String evalVars(String string) {
            Pattern pattern = Pattern.compile("\\$\\{([^\\}]*)\\}");
            Matcher matcher = pattern.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                try {
                    String string2 = this.engine.eval(matcher.group(1)).toString();
                    matcher.appendReplacement(stringBuffer, string2);
                }
                catch (ScriptException scriptException) {
                    CustomConfigurator.log("Error: Can not evaluate expression %s : %s", matcher.group(1), scriptException.getMessage());
                }
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        private Preferences readPreferencesFromDOMElement(Element element) {
            Preferences preferences = new Preferences();
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                CharArrayWriter charArrayWriter = new CharArrayWriter(8192);
                StreamResult streamResult = new StreamResult(charArrayWriter);
                transformer.transform(new DOMSource(element), streamResult);
                String string = this.evalVars(charArrayWriter.toString());
                CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
                preferences.fromXML(charArrayReader);
            }
            catch (Exception exception) {
                CustomConfigurator.log("Error: can not read XML fragment :" + exception.getMessage());
            }
            return preferences;
        }

        private String normalizeDirName(String string) {
            String string2 = string.replace("\\", "/");
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
    }
}

