/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static final String SEPARATOR = "[:_]";
    private static final Collection<Pattern> ignoredKeys = new ArrayList<Pattern>();
    private static final StringSwitcher FORWARD_BACKWARD;
    private static final StringSwitcher UP_DOWN;
    private static final StringSwitcher[] stringSwitchers;

    private static final Pattern getPatternFor(String string) {
        return ReverseWayTagCorrector.getPatternFor(string, false);
    }

    private static final Pattern getPatternFor(String string, boolean bl) {
        if (bl) {
            return Pattern.compile("(^)(" + string + ")($)");
        }
        return Pattern.compile("(^|.*[:_])(" + string + ")(" + SEPARATOR + ".*|$)", 2);
    }

    public static boolean isReversible(Way way) {
        for (Tag tag : TagCollection.from(way)) {
            if (tag.equals(TagSwitcher.apply(tag))) continue;
            return false;
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>(list);
        for (Way way : list) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            arrayList.remove(way);
        }
        return arrayList;
    }

    public static String invertNumber(String string) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        string2 = string2.equals("-") ? "" : "-";
        return string2 + string3;
    }

    @Override
    public Collection<Command> execute(Way way, Way way2) throws UserCancelException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<TagCorrection> arrayList = new ArrayList<TagCorrection>();
        for (String object52 : way2.keySet()) {
            object4 = way2.get(object52);
            object3 = TagSwitcher.apply(object52, (String)object4);
            object2 = ((Tag)object3).getKey();
            object = ((Tag)object3).getValue();
            int n2 = n = !object52.equals(object2) ? 1 : 0;
            if (way2.get((String)object2) != null && way2.get((String)object2).equals(object)) {
                n = 0;
            }
            if (!((String)object4).equals(object)) {
                n = 1;
            }
            if (n == 0) continue;
            arrayList.add(new TagCorrection(object52, (String)object4, (String)object2, (String)object));
        }
        if (!arrayList.isEmpty()) {
            hashMap.put(way2, arrayList);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<RoleCorrection> arrayList2 = new ArrayList<RoleCorrection>();
        object4 = way.getReferrers();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (OsmPrimitive)object3.next();
            if (!(object2 instanceof Relation)) continue;
            object = (Relation)object2;
            n = 0;
            for (RelationMember relationMember : ((Relation)object).getMembers()) {
                if (!relationMember.getMember().hasEqualSemanticAttributes(way) || !relationMember.hasRole()) {
                    ++n;
                    continue;
                }
                boolean bl = false;
                String string = null;
                for (StringSwitcher stringSwitcher : stringSwitchers) {
                    string = stringSwitcher.apply(relationMember.getRole());
                    if (string.equals(relationMember.getRole())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    arrayList2.add(new RoleCorrection((Relation)object, n, relationMember, string));
                }
                ++n;
            }
        }
        if (!arrayList2.isEmpty()) {
            hashMap2.put(way2, arrayList2);
        }
        return this.applyCorrections(hashMap, hashMap2, I18n.tr("When reversing this way, the following changes are suggested in order to maintain data consistency.", new Object[0]));
    }

    private static boolean ignoreKeyForCorrection(String string) {
        for (Pattern pattern : ignoredKeys) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        for (String string : OsmPrimitive.getUninterestingKeys()) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string));
        }
        for (String string : new String[]{"name", "ref", "tiger:county"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string, false));
        }
        for (String string : new String[]{"tiger:county", "turn:lanes", "change:lanes", "placement"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string, true));
        }
        FORWARD_BACKWARD = new StringSwitcher("forward", "backward");
        UP_DOWN = new StringSwitcher("up", "down");
        stringSwitchers = new StringSwitcher[]{new StringSwitcher("left", "right"), new StringSwitcher("forwards", "backwards"), new StringSwitcher("east", "west"), new StringSwitcher("north", "south"), FORWARD_BACKWARD, UP_DOWN};
    }

    public static class TagSwitcher {
        public static final Tag apply(Tag tag) {
            return TagSwitcher.apply(tag.getKey(), tag.getValue());
        }

        public static final Tag apply(String string, String string2) {
            String string3;
            String string4;
            block9: {
                block7: {
                    block8: {
                        string4 = string;
                        string3 = string2;
                        if (!string.startsWith("oneway") && !string.endsWith("oneway")) break block7;
                        if (!OsmUtils.isReversed(string2)) break block8;
                        string3 = "yes";
                        break block9;
                    }
                    if (!OsmUtils.isTrue(string2)) break block9;
                    string3 = "-1";
                    break block9;
                }
                if (string.startsWith("incline") || string.endsWith("incline") || string.startsWith("direction") || string.endsWith("direction")) {
                    string3 = UP_DOWN.apply(string2);
                    if (string3.equals(string2)) {
                        string3 = ReverseWayTagCorrector.invertNumber(string2);
                    }
                } else if (string.endsWith(":forward") || string.endsWith(":backward")) {
                    string4 = FORWARD_BACKWARD.apply(string);
                } else if (!ReverseWayTagCorrector.ignoreKeyForCorrection(string)) {
                    StringSwitcher stringSwitcher;
                    StringSwitcher[] stringSwitcherArray = stringSwitchers;
                    int n = stringSwitcherArray.length;
                    for (int i = 0; i < n && string.equals(string4 = (stringSwitcher = stringSwitcherArray[i]).apply(string)) && string2.equals(string3 = stringSwitcher.apply(string2)); ++i) {
                    }
                }
            }
            return new Tag(string4, string3);
        }
    }

    private static class StringSwitcher {
        private final String a;
        private final String b;
        private final Pattern pattern;

        public StringSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.pattern = ReverseWayTagCorrector.getPatternFor(string + "|" + string2);
        }

        public String apply(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.lookingAt()) {
                String string2 = matcher.group(2).toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(2)));
                stringBuilder.append(string2.equals(this.a) ? this.b : this.a);
                stringBuilder.append(string.substring(matcher.end(2)));
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

