/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RotateCommand
extends TransformNodesCommand {
    private EastNorth pivot = this.getNodesCenter();
    private double startAngle = 0.0;
    private double rotationAngle = 0.0;

    public RotateCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        super(collection);
        this.startAngle = this.getAngle(eastNorth);
        this.rotationAngle = 0.0;
        this.handleEvent(eastNorth);
    }

    protected double getAngle(EastNorth eastNorth) {
        if (this.pivot == null) {
            return 0.0;
        }
        return Math.atan2(eastNorth.east() - this.pivot.east(), eastNorth.north() - this.pivot.north());
    }

    @Override
    public void handleEvent(EastNorth eastNorth) {
        double d = this.getAngle(eastNorth);
        this.rotationAngle = d - this.startAngle;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node node : this.nodes) {
            double d = Math.cos(this.rotationAngle);
            double d2 = Math.sin(this.rotationAngle);
            EastNorth eastNorth = ((Command.OldNodeState)this.oldStates.get((Object)node)).eastNorth;
            double d3 = eastNorth.east() - this.pivot.east();
            double d4 = eastNorth.north() - this.pivot.north();
            double d5 = d * d3 + d2 * d4 + this.pivot.east();
            double d6 = -d2 * d3 + d * d4 + this.pivot.north();
            node.setEastNorth(new EastNorth(d5, d6));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Rotate {0} node", "Rotate {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }
}

