/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectAction
extends MapMode
implements AWTEventListener,
SelectionManager.SelectionEnded {
    private boolean lassoMode = false;
    private MouseEvent oldEvent = null;
    private Mode mode = null;
    private SelectionManager selectionManager;
    private boolean cancelDrawMode = false;
    private boolean drawTargetHighlight;
    private boolean didMouseDrag = false;
    private final MapView mv;
    private Point startingDraggingPos;
    EastNorth startEN;
    private Point lastMousePos;
    private long mouseDownTime = 0L;
    private int mouseDownButton = 0;
    private long mouseReleaseTime = 0L;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    int previousModifiers;
    CycleManager cycleManager = new CycleManager();
    VirtualManager virtualManager = new VirtualManager();

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select", new Object[0]), "move/move", I18n.tr("Select, move, scale and rotate objects", new Object[0]), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select", new Object[0])), 83, 5003), mapFrame, ImageProvider.getCursor("normal", "selection"));
        this.mv = mapFrame.mapView;
        this.putValue("help", HelpUtil.ht("/Action/Select"));
        this.selectionManager = new SelectionManager(this, false, this.mv);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.cycleManager.init();
        this.virtualManager.init();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.removeHighlighting();
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.oldEvent == null) {
            return;
        }
        int n = ((InputEvent)aWTEvent).getModifiers();
        if (this.previousModifiers == n) {
            return;
        }
        this.previousModifiers = n;
        if (this.giveUserFeedback(this.oldEvent, ((InputEvent)aWTEvent).getModifiers())) {
            this.mv.repaint();
        }
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent) {
        return this.giveUserFeedback(mouseEvent, mouseEvent.getModifiers());
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent, int n) {
        Collection<OsmPrimitive> collection = MapView.asColl(this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate, true));
        this.updateKeyModifiers(n);
        this.determineMapMode(!collection.isEmpty());
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        this.virtualManager.clear();
        if (this.mode == Mode.move && !this.dragInProgress() && this.virtualManager.activateVirtualNodeNearPoint(mouseEvent.getPoint())) {
            DataSet dataSet = SelectAction.getCurrentDataSet();
            if (dataSet != null && this.drawTargetHighlight) {
                dataSet.setHighlightedVirtualNodes(this.virtualManager.virtualWays);
            }
            this.mv.setNewCursor(SelectActionCursor.virtual_node.cursor(), (Object)this);
            return this.repaintIfRequired(hashSet);
        }
        this.mv.setNewCursor(this.getCursor(collection), (Object)this);
        if (!this.drawTargetHighlight || this.mode != Mode.move || collection.isEmpty()) {
            return this.repaintIfRequired(hashSet);
        }
        boolean bl = this.ctrl && !this.dragInProgress();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!bl && osmPrimitive.isSelected()) continue;
            hashSet.add(osmPrimitive);
        }
        return this.repaintIfRequired(hashSet);
    }

    private Cursor getCursor(Collection<OsmPrimitive> collection) {
        String string = "rect";
        switch (this.mode) {
            case move: {
                OsmPrimitive osmPrimitive;
                if (this.virtualManager.hasVirtualNode()) {
                    string = "virtual_node";
                    break;
                }
                Iterator<OsmPrimitive> iterator = collection.iterator();
                OsmPrimitive osmPrimitive2 = osmPrimitive = iterator.hasNext() ? iterator.next() : null;
                if (this.dragInProgress()) {
                    if (!this.ctrl || SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty()) {
                        string = "move";
                        break;
                    }
                    boolean bl = osmPrimitive instanceof Node && !osmPrimitive.isSelected();
                    string = bl ? "merge_to_node" : "merge";
                    break;
                }
                string = osmPrimitive instanceof Node ? "node" : string;
                String string2 = string = osmPrimitive instanceof Way ? "way" : string;
                if (this.shift) {
                    string = string + "_add";
                    break;
                }
                if (!this.ctrl) break;
                string = string + (osmPrimitive == null || osmPrimitive.isSelected() ? "_rm" : "_add");
                break;
            }
            case rotate: {
                string = "rotate";
                break;
            }
            case scale: {
                string = "scale";
                break;
            }
            case select: {
                string = this.lassoMode ? "lasso" : "rect" + (this.shift ? "_add" : (this.ctrl ? "_rm" : ""));
            }
        }
        return SelectActionCursor.valueOf(string).cursor();
    }

    private boolean removeHighlighting() {
        boolean bl = false;
        DataSet dataSet = SelectAction.getCurrentDataSet();
        if (dataSet != null && !dataSet.getHighlightedVirtualNodes().isEmpty()) {
            bl = true;
            dataSet.clearHighlightedVirtualNodes();
        }
        if (this.oldHighlights.isEmpty()) {
            return bl;
        }
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
        return true;
    }

    private boolean repaintIfRequired(Set<OsmPrimitive> set) {
        if (!this.drawTargetHighlight) {
            return false;
        }
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : set) {
            if (this.oldHighlights.contains(osmPrimitive)) continue;
            bl = true;
            osmPrimitive.setHighlighted(true);
        }
        this.oldHighlights.removeAll(set);
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
            bl = true;
        }
        this.oldHighlights = set;
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDownButton = mouseEvent.getButton();
        if (!this.mv.isActiveLayerVisible() || !((Boolean)this.getValue("active")).booleanValue() || this.mouseDownButton != 1) {
            return;
        }
        this.mv.requestFocus();
        this.updateKeyModifiers(mouseEvent);
        this.cancelDrawMode = this.shift || this.ctrl;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = mouseEvent.getPoint();
        this.startEN = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        OsmPrimitive osmPrimitive = this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate, true);
        this.determineMapMode(osmPrimitive != null);
        switch (this.mode) {
            case rotate: 
            case scale: {
                if (!SelectAction.getCurrentDataSet().getSelected().isEmpty()) break;
                SelectAction.getCurrentDataSet().setSelected(MapView.asColl(osmPrimitive));
                break;
            }
            case move: {
                if (!this.cancelDrawMode && osmPrimitive instanceof Way) {
                    this.virtualManager.activateVirtualNodeNearPoint(mouseEvent.getPoint());
                }
                OsmPrimitive osmPrimitive2 = this.cycleManager.cycleSetup(osmPrimitive, mouseEvent.getPoint());
                this.selectPrims(NavigatableComponent.asColl(osmPrimitive2), false, false);
                this.useLastMoveCommandIfPossible();
                GuiHelper.scheduleTimer(this.initialMoveDelay + 1, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectAction.this.updateStatusLine();
                    }
                }, false);
                break;
            }
            default: {
                this.selectionManager.register(this.mv, this.lassoMode);
                this.selectionManager.mousePressed(mouseEvent);
            }
        }
        if (this.giveUserFeedback(mouseEvent)) {
            this.mv.repaint();
        }
        this.updateStatusLine();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (Main.platform instanceof PlatformHookOsx && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
            this.mouseDragged(mouseEvent);
            return;
        }
        this.oldEvent = mouseEvent;
        if (this.giveUserFeedback(mouseEvent)) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        if (this.mouseDownButton == 1 && this.mouseReleaseTime > this.mouseDownTime) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.rotate && this.mode != Mode.scale && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.move) {
            n = this.ctrl && !SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty() ? 1 : 0;
            Node node = n != 0 ? this.findNodeToMergeTo(mouseEvent.getPoint()) : null;
            boolean bl = this.removeHighlighting();
            if (node != null) {
                node.setHighlighted(true);
                this.oldHighlights.add(node);
                bl = true;
            }
            this.mv.setNewCursor(this.getCursor(MapView.asColl(node)), (Object)this);
            this.oldEvent = mouseEvent;
            if (bl) {
                this.mv.repaint();
            }
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.lastMousePos == null) {
            this.lastMousePos = mouseEvent.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            n = (int)this.lastMousePos.distance(mouseEvent.getX(), mouseEvent.getY());
            if (n < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        if (mouseEvent.getPoint().equals(this.lastMousePos)) {
            return;
        }
        EastNorth eastNorth = this.mv.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        if (this.virtualManager.hasVirtualWaysToBeConstructed()) {
            this.virtualManager.createMiddleNodeFromVirtual(eastNorth);
        } else if (!this.updateCommandWhileDragging(eastNorth)) {
            return;
        }
        this.mv.repaint();
        if (this.mode != Mode.scale) {
            this.lastMousePos = mouseEvent.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.removeHighlighting()) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        this.mouseReleaseTime = System.currentTimeMillis();
        if (this.mode == Mode.select) {
            this.selectionManager.unregister(this.mv);
            if (SelectAction.getCurrentDataSet().getSelected().isEmpty() && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                this.updateStatusLine();
                return;
            }
        }
        if (this.mode == Mode.move && mouseEvent.getButton() == 1) {
            if (!this.didMouseDrag) {
                this.virtualManager.clear();
                if (this.lastMousePos == null || this.lastMousePos.distanceSq(mouseEvent.getPoint()) < 100.0) {
                    this.updateKeyModifiers(mouseEvent);
                    this.selectPrims(this.cycleManager.cyclePrims(), true, false);
                    Collection<OsmPrimitive> collection = SelectAction.getCurrentDataSet().getSelected();
                    if (mouseEvent.getClickCount() >= 2 && collection.size() == 1 && collection.iterator().next() instanceof Node) {
                        Main.worker.execute(new Runnable(){

                            @Override
                            public void run() {
                                Main.map.selectDrawTool(true);
                            }
                        });
                        return;
                    }
                }
            } else {
                this.confirmOrUndoMovement(mouseEvent);
            }
        }
        this.mode = null;
        if (mouseEvent.getButton() == 2) {
            this.removeHighlighting();
        } else {
            this.giveUserFeedback(mouseEvent);
        }
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle rectangle, MouseEvent mouseEvent) {
        this.updateKeyModifiers(mouseEvent);
        this.selectPrims(this.selectionManager.getSelectedObjects(this.alt), true, true);
    }

    private void determineMapMode(boolean bl) {
        this.mode = this.shift && this.ctrl ? Mode.rotate : (this.alt && this.ctrl ? Mode.scale : (bl || this.dragInProgress() ? Mode.move : Mode.select));
    }

    private final boolean dragInProgress() {
        return this.didMouseDrag && this.startingDraggingPos != null;
    }

    private boolean updateCommandWhileDragging(EastNorth eastNorth) {
        Object object;
        Collection<OsmPrimitive> collection = SelectAction.getCurrentDataSet().getSelectedNodesAndWays();
        if (collection.isEmpty()) {
            object = this.mv.getNearestNodeOrWay(this.mv.getPoint(this.startEN), OsmPrimitive.isSelectablePredicate, true);
            SelectAction.getCurrentDataSet().setSelected(new PrimitiveId[]{object});
        }
        if ((object = AllNodesVisitor.getAllNodes(collection)).size() < 2 && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
            return false;
        }
        Command command = this.getLastCommand();
        if (this.mode == Mode.move) {
            if (this.startEN == null) {
                return false;
            }
            SelectAction.getCurrentDataSet().beginUpdate();
            if (command instanceof MoveCommand && object.equals(((MoveCommand)command).getParticipatingPrimitives())) {
                ((MoveCommand)command).saveCheckpoint();
                ((MoveCommand)command).applyVectorTo(eastNorth);
            } else {
                command = new MoveCommand(collection, this.startEN, eastNorth);
                Main.main.undoRedo.add(command);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                LatLon latLon = node.getCoor();
                if (latLon == null || !latLon.isOutSideWorld()) continue;
                ((MoveCommand)command).resetToCheckpoint();
                SelectAction.getCurrentDataSet().endUpdate();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                this.mv.setNewCursor(this.cursor, (Object)this);
                return false;
            }
        } else {
            this.startEN = eastNorth;
            if (this.mode != Mode.rotate && this.mode != Mode.scale) {
                return false;
            }
            SelectAction.getCurrentDataSet().beginUpdate();
            if (this.mode == Mode.rotate) {
                if (command instanceof RotateCommand && object.equals(((RotateCommand)command).getTransformedNodes())) {
                    ((RotateCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(collection, eastNorth));
                }
            } else if (this.mode == Mode.scale) {
                if (command instanceof ScaleCommand && object.equals(((ScaleCommand)command).getTransformedNodes())) {
                    ((ScaleCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new ScaleCommand(collection, eastNorth));
                }
            }
            Collection<Way> collection2 = SelectAction.getCurrentDataSet().getSelectedWays();
            if (this.doesImpactStatusLine((Collection<Node>)object, collection2)) {
                Main.map.statusLine.setDist(collection2);
            }
        }
        SelectAction.getCurrentDataSet().endUpdate();
        return true;
    }

    private boolean doesImpactStatusLine(Collection<Node> collection, Collection<Way> collection2) {
        for (Way way : collection2) {
            for (Node node : way.getNodes()) {
                if (!collection.contains(node)) continue;
                return true;
            }
        }
        return false;
    }

    private void useLastMoveCommandIfPossible() {
        Command command = this.getLastCommand();
        Collection<Node> collection = AllNodesVisitor.getAllNodes(SelectAction.getCurrentDataSet().getSelected());
        if (command instanceof MoveCommand && ((Object)collection).equals(((MoveCommand)command).getParticipatingPrimitives())) {
            ((MoveCommand)command).changeStartPoint(this.startEN);
        }
    }

    private Command getLastCommand() {
        Command command;
        Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        if (command instanceof SequenceCommand) {
            command = ((SequenceCommand)command).getLastCommand();
        }
        return command;
    }

    private void confirmOrUndoMovement(MouseEvent mouseEvent) {
        int n;
        int n2 = n = Main.pref.getInteger("warn.move.maxelements", 20);
        for (OsmPrimitive osmPrimitive : SelectAction.getCurrentDataSet().getSelected()) {
            if (osmPrimitive instanceof Way) {
                n2 -= ((Way)osmPrimitive).getNodes().size();
            }
            if (--n2 >= 0) continue;
            break;
        }
        if (n2 < 0) {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Move elements", new Object[0]), new String[]{I18n.tr("Move them", new Object[0]), I18n.tr("Undo move", new Object[0])});
            extendedDialog.setButtonIcons(new String[]{"reorder.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", n));
            extendedDialog.setCancelButton(2);
            extendedDialog.toggleEnable("movedManyElements");
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                Main.main.undoRedo.undo();
            }
        } else {
            this.updateKeyModifiers(mouseEvent);
            if (this.ctrl) {
                this.mergePrims(mouseEvent.getPoint());
            }
        }
        SelectAction.getCurrentDataSet().fireSelectionChanged();
    }

    private final void mergePrims(Point point) {
        Collection<Node> collection = SelectAction.getCurrentDataSet().getSelectedNodes();
        if (collection.isEmpty()) {
            return;
        }
        Node node = this.findNodeToMergeTo(point);
        if (node == null) {
            return;
        }
        LinkedList<Node> linkedList = new LinkedList<Node>(collection);
        linkedList.add(node);
        MergeNodesAction.doMergeNodes(Main.main.getEditLayer(), linkedList, node);
    }

    private final Node findNodeToMergeTo(Point point) {
        List<Node> list = this.mv.getNearestNodes(point, SelectAction.getCurrentDataSet().getSelectedNodes(), OsmPrimitive.isSelectablePredicate);
        return list.isEmpty() ? null : (Node)list.iterator().next();
    }

    private void selectPrims(Collection<OsmPrimitive> collection, boolean bl, boolean bl2) {
        DataSet dataSet = SelectAction.getCurrentDataSet();
        if (dataSet == null || this.shift && this.ctrl || this.ctrl && !bl || this.virtualManager.hasVirtualWaysToBeConstructed() && !bl) {
            return;
        }
        if (!bl) {
            this.shift |= dataSet.getSelected().containsAll(collection);
        }
        if (this.ctrl) {
            if (bl2) {
                dataSet.clearSelection(collection);
            } else {
                dataSet.toggleSelected(collection);
            }
        } else if (this.shift) {
            dataSet.addSelected(collection);
        } else {
            dataSet.setSelected(collection);
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.mouseDownButton == 1 && this.mouseReleaseTime < this.mouseDownTime) {
            if (this.mode == Mode.select) {
                return I18n.tr("Release the mouse button to select the objects in the rectangle.", new Object[0]);
            }
            if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime >= (long)this.initialMoveDelay) {
                boolean bl = SelectAction.getCurrentDataSet() != null && !SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty();
                String string = bl ? " " + I18n.tr("Ctrl to merge with nearest node.", new Object[0]) : "";
                return I18n.tr("Release the mouse button to stop moving.", new Object[0]) + string;
            }
            if (this.mode == Mode.rotate) {
                return I18n.tr("Release the mouse button to stop rotating.", new Object[0]);
            }
            if (this.mode == Mode.scale) {
                return I18n.tr("Release the mouse button to stop scaling.", new Object[0]);
            }
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; Alt-Ctrl to scale selected; or change selection", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    public void setLassoMode(boolean bl) {
        this.selectionManager.setLassoMode(bl);
        this.lassoMode = bl;
    }

    private class VirtualManager {
        private Node virtualNode = null;
        private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
        private int nodeVirtualSize;
        private int virtualSnapDistSq2;
        private int virtualSpace;

        private VirtualManager() {
        }

        private void init() {
            this.nodeVirtualSize = Main.pref.getInteger("mappaint.node.virtual-size", 8);
            int n = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
            this.virtualSnapDistSq2 = n * n;
            this.virtualSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        }

        private boolean activateVirtualNodeNearPoint(Point point) {
            if (this.nodeVirtualSize > 0) {
                LinkedList<WaySegment> linkedList = new LinkedList<WaySegment>();
                Pair pair = null;
                Pair<Object, Object> pair2 = new Pair<Object, Object>(null, null);
                Way way = null;
                for (WaySegment waySegment : SelectAction.this.mv.getNearestWaySegments(point, OsmPrimitive.isSelectablePredicate)) {
                    Point2D.Double double_;
                    way = waySegment.way;
                    pair2.a = way.getNode(waySegment.lowerIndex);
                    Point2D point2D = SelectAction.this.mv.getPoint2D((Node)pair2.a);
                    pair2.b = way.getNode(waySegment.lowerIndex + 1);
                    Point2D point2D2 = SelectAction.this.mv.getPoint2D((Node)pair2.b);
                    if (!WireframeMapRenderer.isLargeSegment(point2D, point2D2, this.virtualSpace) || !(point.distanceSq(double_ = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0)) < (double)this.virtualSnapDistSq2)) continue;
                    Pair.sort(pair2);
                    if (pair == null) {
                        pair = new Pair(pair2.a, pair2.b);
                        this.virtualNode = new Node(SelectAction.this.mv.getLatLon(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    }
                    if (!pair.equals(pair2)) continue;
                    (way.isSelected() ? linkedList : this.virtualWays).add(waySegment);
                }
                if (!linkedList.isEmpty()) {
                    this.virtualWays = linkedList;
                }
            }
            return !this.virtualWays.isEmpty();
        }

        private void createMiddleNodeFromVirtual(EastNorth eastNorth) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(this.virtualNode));
            for (WaySegment waySegment : this.virtualWays) {
                Way way = waySegment.way;
                Way way2 = new Way(way);
                way2.addNode(waySegment.lowerIndex + 1, this.virtualNode);
                linkedList.add(new ChangeCommand(way, way2));
            }
            linkedList.add(new MoveCommand((OsmPrimitive)this.virtualNode, SelectAction.this.startEN, eastNorth));
            String string = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            SelectAction.getCurrentDataSet().setSelected(Collections.singleton(this.virtualNode));
            this.clear();
        }

        private void clear() {
            this.virtualWays.clear();
            this.virtualNode = null;
        }

        private boolean hasVirtualNode() {
            return this.virtualNode != null;
        }

        private boolean hasVirtualWaysToBeConstructed() {
            return !this.virtualWays.isEmpty();
        }
    }

    private class CycleManager {
        private Collection<OsmPrimitive> cycleList = Collections.emptyList();
        private boolean cyclePrims = false;
        private OsmPrimitive cycleStart = null;
        private boolean waitForMouseUpParameter;
        private boolean multipleMatchesParameter;

        private CycleManager() {
        }

        private void init() {
            this.waitForMouseUpParameter = Main.pref.getBoolean("mappaint.select.waits-for-mouse-up", false);
            this.multipleMatchesParameter = Main.pref.getBoolean("selectaction.cycles.multiple.matches", false);
        }

        private OsmPrimitive cycleSetup(OsmPrimitive osmPrimitive, Point point) {
            OsmPrimitive osmPrimitive2 = null;
            if (osmPrimitive != null) {
                osmPrimitive2 = osmPrimitive;
                if (!SelectAction.this.alt && !this.multipleMatchesParameter) {
                    this.cycleList = MapView.asColl(osmPrimitive2);
                    if (this.waitForMouseUpParameter) {
                        osmPrimitive2 = SelectAction.this.mv.getNearestNodeOrWay(point, OsmPrimitive.isSelectablePredicate, true);
                    }
                } else {
                    this.cycleList = SelectAction.this.mv.getAllNearest(point, OsmPrimitive.isSelectablePredicate);
                    if (this.cycleList.size() > 1) {
                        this.cyclePrims = false;
                        OsmPrimitive osmPrimitive3 = osmPrimitive2;
                        for (OsmPrimitive osmPrimitive4 : this.cycleList) {
                            if (!osmPrimitive4.isSelected()) continue;
                            this.cyclePrims = true;
                            osmPrimitive2 = osmPrimitive4;
                            break;
                        }
                        if (!(this.cycleList.size() != 2 || this.waitForMouseUpParameter || osmPrimitive2.equals(osmPrimitive3) || osmPrimitive2.isNew() || SelectAction.this.ctrl)) {
                            this.cyclePrims = false;
                            osmPrimitive2 = osmPrimitive3;
                        }
                    }
                }
            }
            return osmPrimitive2;
        }

        private Collection<OsmPrimitive> cyclePrims() {
            OsmPrimitive osmPrimitive4 = null;
            if (this.cycleList.size() <= 1) {
                return this.cycleList;
            }
            DataSet dataSet = SelectAction.getCurrentDataSet();
            OsmPrimitive osmPrimitive2 = this.cycleList.iterator().next();
            OsmPrimitive osmPrimitive3 = null;
            osmPrimitive4 = osmPrimitive2;
            if (this.cyclePrims && SelectAction.this.shift) {
                for (OsmPrimitive osmPrimitive4 : this.cycleList) {
                    if (!osmPrimitive4.isSelected()) break;
                }
            } else {
                Iterator<OsmPrimitive> iterator = this.cycleList.iterator();
                while (iterator.hasNext()) {
                    osmPrimitive4 = iterator.next();
                    if (!osmPrimitive4.isSelected()) continue;
                    osmPrimitive3 = osmPrimitive4;
                    if (!this.cyclePrims && !SelectAction.this.ctrl) break;
                    dataSet.clearSelection(osmPrimitive3);
                    OsmPrimitive osmPrimitive5 = osmPrimitive4 = iterator.hasNext() ? iterator.next() : osmPrimitive2;
                    break;
                }
            }
            if (SelectAction.this.ctrl) {
                if (osmPrimitive3 != null) {
                    if (!this.cycleList.contains(this.cycleStart)) {
                        dataSet.clearSelection(this.cycleList);
                        this.cycleStart = osmPrimitive3;
                    } else if (this.cycleStart.equals(osmPrimitive4)) {
                        dataSet.addSelected(osmPrimitive4);
                    }
                } else {
                    this.cycleStart = osmPrimitive4 = this.cycleList.contains(this.cycleStart) ? this.cycleStart : osmPrimitive2;
                }
            } else {
                this.cycleStart = null;
            }
            return MapView.asColl(osmPrimitive4);
        }
    }

    private static enum SelectActionCursor {
        rect("normal", "selection"),
        rect_add("normal", "select_add"),
        rect_rm("normal", "select_remove"),
        way("normal", "select_way"),
        way_add("normal", "select_way_add"),
        way_rm("normal", "select_way_remove"),
        node("normal", "select_node"),
        node_add("normal", "select_node_add"),
        node_rm("normal", "select_node_remove"),
        virtual_node("normal", "addnode"),
        scale("scale", null),
        rotate("rotate", null),
        merge("crosshair", null),
        lasso("normal", "rope"),
        merge_to_node("crosshair", "joinnode"),
        move(13);

        private final Cursor c;

        private SelectActionCursor(String string2, String string3) {
            this.c = ImageProvider.getCursor(string2, string3);
        }

        private SelectActionCursor(int n2) {
            this.c = Cursor.getPredefinedCursor(n2);
        }

        public Cursor cursor() {
            return this.c;
        }
    }

    static enum Mode {
        move,
        rotate,
        scale,
        select;

    }
}

