/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes = false;
    private boolean nodeDragWithoutCtrl;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Node selectedNode = null;
    private Color mainColor;
    private Stroke mainStroke;
    private boolean ignoreSharedNodes;
    private Color helperColor;
    private Stroke helperStrokeDash;
    private Stroke helperStrokeRA;
    private Stroke oldLineStroke;
    private double symbolSize;
    private List<ReferenceSegment> possibleMoveDirections;
    private Collection<OsmPrimitive> movingNodeList;
    private ReferenceSegment activeMoveDirection;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private MoveCommand moveCommand;
    private final Cursor cursorCreateNew;
    private final Cursor cursorTranslate;
    private final Cursor cursorCreateNodes;
    private final AWTEventListener altKeyListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            boolean bl;
            if (!Main.isDisplayingMapView() || !Main.map.mapView.isActiveLayerDrawable()) {
                return;
            }
            InputEvent inputEvent = (InputEvent)aWTEvent;
            boolean bl2 = (inputEvent.getModifiers() & 0x28) != 0;
            boolean bl3 = (inputEvent.getModifiers() & 2) != 0;
            boolean bl4 = bl = (inputEvent.getModifiers() & 1) != 0;
            if (ExtrudeAction.this.mode == Mode.select) {
                Main.map.mapView.setNewCursor(bl3 ? ExtrudeAction.this.cursorTranslate : (bl2 ? ExtrudeAction.this.cursorCreateNew : (bl ? ExtrudeAction.this.cursorCreateNodes : ExtrudeAction.this.cursor)), (Object)this);
            }
        }
    };

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude", new Object[0]), "extrude/extrude", I18n.tr("Create areas", new Object[0]), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude", new Object[0])), 88, 5003), mapFrame, ImageProvider.getCursor("normal", "rectangle"));
        this.putValue("help", HelpUtil.ht("/Action/Extrude"));
        this.cursorCreateNew = ImageProvider.getCursor("normal", "rectangle_plus");
        this.cursorTranslate = ImageProvider.getCursor("normal", "rectangle_move");
        this.cursorCreateNodes = ImageProvider.getCursor("normal", "rectangle_plussmall");
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.", new Object[0]);
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]);
        }
        if (this.mode == Mode.create_new) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]);
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal, Alt-drag to create a new rectangle, double click to add a new node.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.altKeyListener, 8L);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.mainColor = Main.pref.getColor(I18n.marktr("Extrude: main line"), null);
        if (this.mainColor == null) {
            this.mainColor = PaintColors.SELECTED.get();
        }
        this.helperColor = Main.pref.getColor(I18n.marktr("Extrude: helper line"), Color.ORANGE);
        this.helperStrokeDash = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.stroke.helper-line", "1 4"));
        this.helperStrokeRA = new BasicStroke(1.0f);
        this.symbolSize = Main.pref.getDouble("extrude.angle-symbol-radius", 8.0);
        this.nodeDragWithoutCtrl = Main.pref.getBoolean("extrude.drag-nodes-without-ctrl", false);
        this.oldLineStroke = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.ctrl.stroke.old-line", "1"));
        this.mainStroke = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.stroke.main", "3"));
        this.ignoreSharedNodes = Main.pref.getBoolean("extrude.ignore-shared-nodes", true);
    }

    @Override
    public void exitMode() {
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.altKeyListener);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        super.exitMode();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(mouseEvent);
        this.selectedNode = Main.map.mapView.getNearestNode(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment == null && this.selectedNode == null) {
            return;
        }
        if (this.selectedNode != null) {
            if (this.ctrl || this.nodeDragWithoutCtrl) {
                this.movingNodeList = new ArrayList<OsmPrimitive>();
                this.movingNodeList.add(this.selectedNode);
                this.calculatePossibleDirectionsByNode();
                if (this.possibleMoveDirections.isEmpty()) {
                    return;
                }
                this.mode = Mode.translate_node;
            }
        } else {
            if (this.ctrl) {
                this.mode = Mode.translate;
                this.movingNodeList = new ArrayList<OsmPrimitive>();
                this.movingNodeList.add(this.selectedSegment.getFirstNode());
                this.movingNodeList.add(this.selectedSegment.getSecondNode());
            } else if (this.alt) {
                this.mode = Mode.create_new;
                ExtrudeAction.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = true;
            } else {
                this.mode = Mode.extrude;
                ExtrudeAction.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = this.shift;
            }
            this.calculatePossibleDirectionsBySegment();
        }
        this.newN1en = null;
        this.newN2en = null;
        this.moveCommand = null;
        Main.map.mapView.addTemporaryLayer(this);
        this.updateStatusLine();
        Main.map.mapView.repaint();
        this.mouseDownTime = System.currentTimeMillis();
        this.initialMousePos = mouseEvent.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            EastNorth eastNorth2 = this.calculateBestMovement(eastNorth);
            this.newN1en = new EastNorth(this.initialN1en.getX() + eastNorth2.getX(), this.initialN1en.getY() + eastNorth2.getY());
            this.newN2en = new EastNorth(this.initialN2en.getX() + eastNorth2.getX(), this.initialN2en.getY() + eastNorth2.getY());
            double d = Main.getProjection().eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.getProjection().eastNorth2latlon(this.newN1en));
            Main.map.statusLine.setDist(d);
            this.updateStatusLine();
            Main.map.mapView.setNewCursor(13, (Object)this);
            if (this.mode != Mode.extrude && this.mode != Mode.create_new && (this.mode == Mode.translate_node || this.mode == Mode.translate)) {
                if (this.moveCommand == null) {
                    this.moveCommand = new MoveCommand(this.movingNodeList, eastNorth2.getX(), eastNorth2.getY());
                    Main.main.undoRedo.add(this.moveCommand);
                } else {
                    this.moveCommand.moveAgainTo(eastNorth2.getX(), eastNorth2.getY());
                }
            }
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.create_new) {
                if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    this.createNewRectangle();
                }
            } else if (this.mode == Mode.extrude) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getPoint().equals(this.initialMousePos)) {
                    this.addNewNode(mouseEvent);
                } else if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null && this.selectedSegment != null) {
                    this.performExtrusion();
                }
            } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                // empty if block
            }
            boolean bl = (mouseEvent.getModifiers() & 0x28) != 0;
            boolean bl2 = (mouseEvent.getModifiers() & 2) != 0;
            boolean bl3 = (mouseEvent.getModifiers() & 1) != 0;
            Main.map.mapView.setNewCursor(bl2 ? this.cursorTranslate : (bl ? this.cursorCreateNew : (bl3 ? this.cursorCreateNodes : this.cursor)), (Object)this);
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    private void addNewNode(MouseEvent mouseEvent) {
        WaySegment waySegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (waySegment != null) {
            Node node = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
            EastNorth eastNorth = waySegment.getFirstNode().getEastNorth();
            EastNorth eastNorth2 = waySegment.getSecondNode().getEastNorth();
            node.setEastNorth(Geometry.closestPointToSegment(eastNorth, eastNorth2, node.getEastNorth()));
            Way way = new Way(waySegment.way);
            way.addNode(waySegment.lowerIndex + 1, node);
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Add a new node to an existing way", new Object[0]), new AddCommand(node), new ChangeCommand(waySegment.way, way));
            Main.main.undoRedo.add(sequenceCommand);
        }
    }

    private void createNewRectangle() {
        if (this.selectedSegment == null) {
            return;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Node node = new Node(this.newN2en);
        Node node2 = new Node(this.newN1en);
        Way way = new Way();
        way.addNode(this.selectedSegment.getFirstNode());
        way.addNode(this.selectedSegment.getSecondNode());
        way.addNode(node);
        way.addNode(node2);
        way.addNode(this.selectedSegment.getFirstNode());
        linkedList.add(new AddCommand(node));
        linkedList.add(new AddCommand(node2));
        linkedList.add(new AddCommand(way));
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), linkedList);
        Main.main.undoRedo.add(sequenceCommand);
        ExtrudeAction.getCurrentDataSet().setSelected(way);
    }

    private void performExtrusion() {
        Object object;
        Node node;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Way way = new Way(this.selectedSegment.way);
        boolean bl = false;
        boolean bl2 = way.getNodesCount() == 2;
        int n = this.selectedSegment.lowerIndex + 1;
        Node node2 = this.getPreviousNode(this.selectedSegment.lowerIndex);
        boolean bl3 = node2 != null && Geometry.segmentsParallel(this.initialN1en, node2.getEastNorth(), this.initialN1en, this.newN1en);
        boolean bl4 = node2 != null && Math.abs(Geometry.getCornerAngle(node2.getEastNorth(), this.initialN1en, this.newN1en)) < 1.0E-5;
        boolean bl5 = this.hasNodeOtherWays(this.selectedSegment.getFirstNode(), this.selectedSegment.way);
        if (bl3 && !this.alwaysCreateNodes && !bl5) {
            node = this.selectedSegment.getFirstNode();
            linkedList.add(new MoveCommand(node, Main.getProjection().eastNorth2latlon(this.newN1en)));
        } else if (this.ignoreSharedNodes && bl4 && !this.alwaysCreateNodes && bl5) {
            node = this.selectedSegment.getFirstNode();
            object = new Node(Main.getProjection().eastNorth2latlon(this.newN1en));
            way.addNode(n, (Node)object);
            way.removeNode(node);
            bl = true;
            linkedList.add(new AddCommand((OsmPrimitive)object));
        } else {
            node = new Node(Main.getProjection().eastNorth2latlon(this.newN1en));
            way.addNode(n, node);
            bl = true;
            ++n;
            linkedList.add(new AddCommand(node));
        }
        node = this.getNextNode(this.selectedSegment.lowerIndex + 1);
        bl3 = node != null && Geometry.segmentsParallel(this.initialN2en, node.getEastNorth(), this.initialN2en, this.newN2en);
        bl4 = node != null && Math.abs(Geometry.getCornerAngle(node.getEastNorth(), this.initialN2en, this.newN2en)) < 1.0E-5;
        bl5 = this.hasNodeOtherWays(this.selectedSegment.getSecondNode(), this.selectedSegment.way);
        if (bl3 && !this.alwaysCreateNodes && !bl5) {
            object = this.selectedSegment.getSecondNode();
            linkedList.add(new MoveCommand((Node)object, Main.getProjection().eastNorth2latlon(this.newN2en)));
        } else if (this.ignoreSharedNodes && bl4 && !this.alwaysCreateNodes && bl5) {
            object = this.selectedSegment.getSecondNode();
            Node node3 = new Node(Main.getProjection().eastNorth2latlon(this.newN2en));
            way.addNode(n, node3);
            way.removeNode((Node)object);
            bl = true;
            linkedList.add(new AddCommand(node3));
        } else {
            object = new Node(Main.getProjection().eastNorth2latlon(this.newN2en));
            way.addNode(n, (Node)object);
            bl = true;
            ++n;
            linkedList.add(new AddCommand((OsmPrimitive)object));
        }
        if (bl2) {
            way.addNode(this.selectedSegment.getFirstNode());
            bl = true;
        }
        if (bl) {
            linkedList.add(new ChangeCommand(this.selectedSegment.way, way));
        }
        object = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), linkedList);
        Main.main.undoRedo.add((Command)object);
    }

    private boolean hasNodeOtherWays(Node node, Way way) {
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || !osmPrimitive.isUsable() || osmPrimitive == way) continue;
            return true;
        }
        return false;
    }

    private EastNorth calculateBestMovement(EastNorth eastNorth) {
        EastNorth eastNorth2 = Main.map.mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
        EastNorth eastNorth3 = eastNorth2.sub(eastNorth);
        double d = Double.POSITIVE_INFINITY;
        EastNorth eastNorth4 = null;
        this.activeMoveDirection = null;
        for (ReferenceSegment referenceSegment : this.possibleMoveDirections) {
            double d2;
            EastNorth eastNorth5 = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, referenceSegment.en, eastNorth);
            if (eastNorth5 == null || !(d > (d2 = eastNorth5.distance(eastNorth3)))) continue;
            d = d2;
            this.activeMoveDirection = referenceSegment;
            eastNorth4 = eastNorth5;
        }
        return eastNorth4;
    }

    private static EastNorth calculateSegmentOffset(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        EastNorth eastNorth5 = eastNorth.distanceSq(eastNorth2) > 1.0E-7 ? Geometry.getLineLineIntersection(eastNorth, eastNorth2, eastNorth4, eastNorth4.add(eastNorth3)) : Geometry.closestPointToLine(eastNorth4, eastNorth4.add(eastNorth3), eastNorth);
        if (eastNorth5 == null) {
            return null;
        }
        return eastNorth5.sub(eastNorth4);
    }

    private void calculatePossibleDirectionsBySegment() {
        Object object;
        this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
        this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.initialN1en, this.initialN2en, true));
        Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
        if (node != null) {
            object = node.getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - ((EastNorth)object).getX(), this.initialN1en.getY() - ((EastNorth)object).getY()), this.initialN1en, (EastNorth)object, false));
        }
        if ((object = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
            EastNorth eastNorth = ((Node)object).getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN2en.getX() - eastNorth.getX(), this.initialN2en.getY() - eastNorth.getY()), this.initialN2en, eastNorth, false));
        }
    }

    private void calculatePossibleDirectionsByNode() {
        this.initialN2en = this.initialN1en = this.selectedNode.getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        for (OsmPrimitive osmPrimitive : this.selectedNode.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || !osmPrimitive.isUsable()) continue;
            for (Node node : ((Way)osmPrimitive).getNeighbours(this.selectedNode)) {
                EastNorth eastNorth = node.getEastNorth();
                this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - eastNorth.getX(), this.initialN1en.getY() - eastNorth.getY()), this.initialN1en, eastNorth, false));
            }
        }
    }

    private int getPreviousNodeIndex(int n) {
        if (n > 0) {
            return n - 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNodesCount() - 2;
        }
        return -1;
    }

    private Node getPreviousNode(int n) {
        int n2 = this.getPreviousNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    private int getNextNodeIndex(int n) {
        int n2 = this.selectedSegment.way.getNodesCount();
        if (n < n2 - 1) {
            return n + 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return 1;
        }
        return -1;
    }

    private Node getNextNode(int n) {
        int n2 = this.getNextNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Graphics2D graphics2D2 = graphics2D;
        if (this.mode != Mode.select) {
            if (this.newN1en != null) {
                Point point = mapView.getPoint(this.initialN1en);
                Point point2 = mapView.getPoint(this.initialN2en);
                Point point3 = mapView.getPoint(this.newN1en);
                Point point4 = mapView.getPoint(this.newN2en);
                Point2D point2D = this.getNormalUniVector();
                if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                    graphics2D2.setColor(this.mainColor);
                    graphics2D2.setStroke(this.mainStroke);
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(point.x, point.y);
                    generalPath.lineTo(point3.x, point3.y);
                    generalPath.lineTo(point4.x, point4.y);
                    generalPath.lineTo(point2.x, point2.y);
                    generalPath.lineTo(point.x, point.y);
                    graphics2D2.draw(generalPath);
                    if (this.activeMoveDirection != null) {
                        Point point5 = mapView.getPoint(this.activeMoveDirection.p1);
                        Point point6 = mapView.getPoint(this.activeMoveDirection.p2);
                        generalPath = new GeneralPath();
                        generalPath.moveTo(point5.x, point5.y);
                        generalPath.lineTo(point6.x, point6.y);
                        graphics2D2.setColor(this.helperColor);
                        graphics2D2.setStroke(this.helperStrokeDash);
                        graphics2D2.draw(generalPath);
                        if (this.activeMoveDirection.perpendicular) {
                            double d;
                            double d2 = this.activeMoveDirection.p1.heading(this.activeMoveDirection.p2);
                            double d3 = d2 - (d = Math.atan2(point2D.getY(), point2D.getX()));
                            if (d3 < 0.0) {
                                d3 += Math.PI * 2;
                            }
                            boolean bl = Math.abs(d3 - Math.PI) > 1.0E-5;
                            this.drawAngleSymbol(graphics2D2, point5, point2D, bl);
                        }
                    }
                } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                    Line2D line2D;
                    graphics2D2.setColor(this.mainColor);
                    if (point.distance(point2) < 3.0) {
                        graphics2D2.setStroke(this.mainStroke);
                        graphics2D2.drawOval((int)((double)point.x - this.symbolSize / 2.0), (int)((double)point.y - this.symbolSize / 2.0), (int)this.symbolSize, (int)this.symbolSize);
                    } else {
                        line2D = new Line2D.Double(point, point2);
                        graphics2D2.setStroke(this.oldLineStroke);
                        graphics2D2.draw(line2D);
                    }
                    if (this.activeMoveDirection != null) {
                        graphics2D2.setColor(this.helperColor);
                        graphics2D2.setStroke(this.helperStrokeDash);
                        Point2D.Double double_ = new Point2D.Double((point.getX() + point2.getX()) * 0.5, (point.getY() + point2.getY()) * 0.5);
                        line2D = ExtrudeAction.createSemiInfiniteLine(double_, point2D, graphics2D2);
                        graphics2D2.draw(line2D);
                        if (this.activeMoveDirection.perpendicular) {
                            graphics2D2.setStroke(this.helperStrokeRA);
                            graphics2D2.setColor(this.mainColor);
                            this.drawAngleSymbol(graphics2D2, double_, point2D, false);
                        }
                    }
                }
            }
            graphics2D2.setStroke(this.helperStrokeRA);
        }
    }

    private Point2D getNormalUniVector() {
        double d = 1.0 / this.activeMoveDirection.en.length();
        Point2D.Double double_ = new Point2D.Double(this.activeMoveDirection.en.getX() * d, this.activeMoveDirection.en.getY() * d);
        if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != ((Point2D)double_).getX() > -0.0) {
            double_ = new Point2D.Double(-((Point2D)double_).getX(), -((Point2D)double_).getY());
        }
        ((Point2D)double_).setLocation(((Point2D)double_).getX(), -((Point2D)double_).getY());
        return double_;
    }

    private void drawAngleSymbol(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, boolean bl) {
        double d = 1.0 / graphics2D.getTransform().getScaleX();
        double d2 = this.symbolSize * d * point2D2.getX();
        double d3 = this.symbolSize * d * point2D2.getY();
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = bl ? -1 : 1;
        Point2D.Double double_ = new Point2D.Double(d4 + d2, d5 + d3);
        Point2D.Double double_2 = new Point2D.Double(d4 - d3 * d6, d5 + d2 * d6);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() - d3 * d6, ((Point2D)double_).getY() + d2 * d6);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        graphics2D.setStroke(this.helperStrokeRA);
        graphics2D.draw(generalPath);
    }

    private static Line2D createSemiInfiniteLine(Point2D point2D, Point2D point2D2, Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getDeviceConfiguration().getBounds();
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            Point2D point2D3 = affineTransform.deltaTransform(new Point2D.Double(rectangle.width, 0.0), null);
            Point2D point2D4 = affineTransform.deltaTransform(new Point2D.Double(0.0, rectangle.height), null);
            double d = Math.abs(point2D3.getX()) + Math.abs(point2D3.getY()) + Math.abs(point2D4.getX()) + Math.abs(point2D4.getY());
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * d, point2D.getY() + point2D2.getY() * d));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * 10.0, point2D.getY() + point2D2.getY() * 10.0));
        }
    }

    private class ReferenceSegment {
        public final EastNorth en;
        public final EastNorth p1;
        public final EastNorth p2;
        public final boolean perpendicular;

        public ReferenceSegment(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, boolean bl) {
            this.en = eastNorth;
            this.p1 = eastNorth2;
            this.p2 = eastNorth3;
            this.perpendicular = bl;
        }
    }

    static enum Mode {
        extrude,
        translate,
        select,
        create_new,
        translate_node;

    }
}

