/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SessionLoadAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DownloadSessionTask
extends AbstractDownloadTask {
    private static final String PATTERN_SESSION = "https?://.*/.*\\.jo(s|z)";
    private SessionLoadAction.Loader loader;

    @Override
    public String getTitle() {
        return I18n.tr("Download session", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_SESSION};
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        if (string != null && string.matches(PATTERN_SESSION)) {
            try {
                URL uRL = new URL(string);
                this.loader = new SessionLoadAction.Loader(Utils.openURL(uRL), uRL.toURI(), string.endsWith(".joz"));
                return Main.worker.submit(this.loader);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }
}

