/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    private File file;

    public SaveActionBase(String string, String string2, String string3, Shortcut shortcut) {
        super(string, string2, string3, shortcut);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = this.doSave();
        if (bl) {
            this.addToFileOpenHistory();
        }
    }

    public boolean doSave() {
        Layer layer;
        if (Main.isDisplayingMapView() && (layer = Main.map.mapView.getActiveLayer()) != null && layer.isSavable()) {
            return this.doSave(layer);
        }
        return false;
    }

    public boolean doSave(Layer layer) {
        if (!layer.checkSaveConditions()) {
            return false;
        }
        this.file = this.getFile(layer);
        return SaveActionBase.doInternalSave(layer, this.file);
    }

    public static boolean doSave(Layer layer, File file) {
        if (!layer.checkSaveConditions()) {
            return false;
        }
        return SaveActionBase.doInternalSave(layer, file);
    }

    private static boolean doInternalSave(Layer layer, File file) {
        if (file == null) {
            return false;
        }
        try {
            boolean bl = false;
            for (FileExporter fileExporter : ExtensionFileFilter.exporters) {
                if (!fileExporter.acceptFile(file, layer)) continue;
                fileExporter.exportData(file, layer);
                bl = true;
                break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No Exporter found! Nothing saved.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return false;
            }
            layer.setName(file.getName());
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
            Main.parent.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    protected abstract File getFile(Layer var1);

    @Override
    protected void updateEnabledState() {
        boolean bl;
        if (Main.applet) {
            this.setEnabled(false);
            return;
        }
        boolean bl2 = bl = Main.isDisplayingMapView() && Main.map.mapView.getActiveLayer() != null;
        if (!bl) {
            this.setEnabled(false);
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        this.setEnabled(layer != null && layer.isSavable());
    }

    public static File createAndOpenSaveFileChooser(String string, ExtensionFileFilter extensionFileFilter) {
        JFileChooser jFileChooser = SaveActionBase.createAndOpenFileChooser(false, false, string, extensionFileFilter, 0, null);
        return SaveActionBase.checkFileAndConfirmOverWrite(jFileChooser, extensionFileFilter.getDefaultExtension());
    }

    public static File createAndOpenSaveFileChooser(String string, String string2) {
        JFileChooser jFileChooser = SaveActionBase.createAndOpenFileChooser(false, false, string, string2);
        return SaveActionBase.checkFileAndConfirmOverWrite(jFileChooser, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static File checkFileAndConfirmOverWrite(JFileChooser jFileChooser, String string) {
        if (jFileChooser == null) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (!fileFilter.accept(file)) {
            void var4_8;
            for (FileFilter fileFilter2 : jFileChooser.getChoosableFileFilters()) {
                if (!fileFilter2.accept(file)) continue;
                jFileChooser.setFileFilter(fileFilter2);
                return file;
            }
            String string2 = file.getPath();
            if (fileFilter instanceof ExtensionFileFilter) {
                String string3 = string2 + "." + ((ExtensionFileFilter)fileFilter).getDefaultExtension();
            } else if (string != null) {
                String string4 = string2 + "." + string;
            }
            file = new File((String)var4_8);
            if (!SaveActionBase.confirmOverwrite(file)) {
                return null;
            }
        }
        return file;
    }

    public static boolean confirmOverwrite(File file) {
        if (file == null || file.exists()) {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])});
            extendedDialog.setContent(I18n.tr("File exists. Overwrite?", new Object[0]));
            extendedDialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            extendedDialog.showDialog();
            return extendedDialog.getValue() == 1;
        }
        return true;
    }

    protected void addToFileOpenHistory() {
        String string;
        try {
            string = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        int n = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
        Collection<String> collection = Main.pref.getCollection("file-open.history");
        LinkedList<String> linkedList = new LinkedList<String>(collection);
        linkedList.remove(string);
        linkedList.add(0, string);
        Main.pref.putCollectionBounded("file-open.history", n, linkedList);
    }
}

