/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer", new Object[0]), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer", new Object[0]), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge", new Object[0])), 77, 5006), true, "action/mergelayer", true);
        this.putValue("help", HelpUtil.ht("/Action/MergeLayer"));
    }

    protected void doMerge(List<Layer> list, final Collection<Layer> collection) {
        final Layer layer = this.askTargetLayer(list);
        if (layer == null) {
            return;
        }
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (Layer layer2 : collection) {
                    if (layer2 == null || layer2 == layer) continue;
                    if (layer2 instanceof OsmDataLayer && layer instanceof OsmDataLayer && ((OsmDataLayer)layer2).isUploadDiscouraged() != ((OsmDataLayer)layer).isUploadDiscouraged() && MergeLayerAction.warnMergingUploadDiscouragedLayers(layer2, layer)) break;
                    layer.mergeFrom(layer2);
                    Main.main.removeLayer(layer2);
                    bl = true;
                }
                if (bl) {
                    Main.map.mapView.setActiveLayer(layer);
                }
            }
        });
    }

    public void merge(List<Layer> list) {
        this.doMerge(list, list);
    }

    public void merge(Layer layer) {
        if (layer == null) {
            return;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(layer);
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(layer);
            return;
        }
        this.doMerge(list, Collections.singleton(layer));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        this.merge(osmDataLayer);
    }

    @Override
    protected void updateEnabledState() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (JosmAction.getEditLayer() == null) {
                    MergeLayerAction.this.setEnabled(false);
                    return;
                }
                MergeLayerAction.this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(JosmAction.getEditLayer()).isEmpty());
            }
        });
    }

    public static final boolean warnMergingUploadDiscouragedLayers(Layer layer, Layer layer2) {
        return GuiHelper.warnUser(I18n.tr("Merging layers with different upload policies", new Object[0]), "<html>" + I18n.tr("You are about to merge data between layers ''{0}'' and ''{1}''.<br /><br />These layers have different upload policies and should not been merged as it.<br />Merging them will result to enforce the stricter policy (upload discouraged) to ''{1}''.<br /><br /><b>This is not the recommended way of merging such data</b>.<br />You should instead check and merge each object, one by one, by using ''<i>Merge selection</i>''.<br /><br />Are you sure you want to continue?", layer.getName(), layer2.getName(), layer2.getName()) + "</html>", ImageProvider.get("dialogs", "mergedown"), I18n.tr("Ignore this hint and merge anyway", new Object[0]));
    }
}

