/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class JoinAreasAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;

    public JoinAreasAction() {
        super(I18n.tr("Join overlapping Areas", new Object[0]), "joinareas", I18n.tr("Joins areas that overlap each other", new Object[0]), Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tool: {0}", I18n.tr("Join overlapping Areas", new Object[0])), 74, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LinkedList<Way> linkedList = new LinkedList<Way>(Main.main.getCurrentDataSet().getSelectedWays());
        if (linkedList.isEmpty()) {
            new Notification(I18n.tr("Please select at least one closed way that should be joined.", new Object[0])).setIcon(1).show();
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Way way : linkedList) {
            if (!way.isClosed()) {
                new Notification(I18n.tr("One of the selected ways is not closed and therefore cannot be joined.", new Object[0])).setIcon(1).show();
                return;
            }
            arrayList.addAll(way.getNodes());
        }
        Area area = Main.main.getCurrentDataSet().getDataSourceArea();
        boolean bl = Command.checkAndConfirmOutlyingOperation("joinarea", I18n.tr("Join area confirmation", new Object[0]), I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", linkedList.size(), new Object[0]) + "<br/>" + I18n.tr("This can lead to nodes being deleted accidentally.", new Object[0]) + "<br/>" + I18n.tr("Are you really sure to continue?", new Object[0]) + I18n.tr("Please abort if you are not sure", new Object[0]), I18n.tr("The selected area is incomplete. Continue?", new Object[0]), area, arrayList, null);
        if (!bl) {
            return;
        }
        List<Multipolygon> list = this.collectMultipolygons(linkedList);
        if (list == null) {
            return;
        }
        if (!this.testJoin(list)) {
            new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            return;
        }
        if (!this.resolveTagConflicts(list)) {
            return;
        }
        try {
            JoinAreasResult joinAreasResult = this.joinAreas(list);
            if (joinAreasResult.hasChanges) {
                ArrayList<Way> arrayList2 = new ArrayList<Way>();
                for (Multipolygon multipolygon : joinAreasResult.polygons) {
                    arrayList2.add(multipolygon.outerWay);
                    arrayList2.addAll(multipolygon.innerWays);
                }
                DataSet dataSet = Main.main.getCurrentDataSet();
                dataSet.setSelected(arrayList2);
                Main.map.mapView.repaint();
            } else {
                new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            }
        }
        catch (UserCancelException userCancelException) {
            this.makeCommitsOneAction(I18n.tr("Reverting changes", new Object[0]));
            Main.main.undoRedo.undo();
            Main.main.undoRedo.redoCommands.clear();
        }
    }

    private boolean testJoin(List<Multipolygon> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Multipolygon multipolygon : list) {
            arrayList.add(multipolygon.outerWay);
            arrayList.addAll(multipolygon.innerWays);
        }
        Set<Node> set = Geometry.addIntersections(arrayList, true, this.cmds);
        return !set.isEmpty();
    }

    private JoinAreasResult joinAreas(List<Multipolygon> list) throws UserCancelException {
        List<Object> list2;
        Set<Node> set;
        JoinAreasResult joinAreasResult = new JoinAreasResult();
        joinAreasResult.hasChanges = false;
        ArrayList<Way> arrayList = new ArrayList<Way>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        for (Multipolygon object32 : list) {
            arrayList3.add(object32.outerWay);
            arrayList2.addAll(object32.innerWays);
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        boolean bl = false;
        if (bl |= this.removeDuplicateNodes(arrayList)) {
            joinAreasResult.hasChanges = true;
            this.commitCommands(I18n.marktr("Removed duplicate nodes"));
        }
        if ((set = Geometry.addIntersections(arrayList, false, this.cmds)).isEmpty()) {
            return joinAreasResult;
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> arrayList4 = new ArrayList<RelationRole>();
        for (Way way : arrayList) {
            arrayList4.addAll(this.removeFromAllRelations(way));
        }
        boolean bl2 = !arrayList4.isEmpty() && arrayList.size() > 1;
        ArrayList<WayInPolygon> arrayList5 = new ArrayList<WayInPolygon>();
        for (Way way : arrayList3) {
            list2 = this.splitWayOnNodes(way, set);
            arrayList5.addAll(this.markWayInsideSide(list2, false));
        }
        for (Way way : arrayList2) {
            list2 = this.splitWayOnNodes(way, set);
            arrayList5.addAll(this.markWayInsideSide(list2, true));
        }
        ArrayList arrayList6 = new ArrayList();
        List<AssembledPolygon> list3 = JoinAreasAction.findBoundaryPolygons(arrayList5, arrayList6);
        list2 = this.findPolygons(list3);
        ArrayList<Multipolygon> arrayList7 = new ArrayList<Multipolygon>();
        LinkedHashSet<Relation> linkedHashSet = new LinkedHashSet<Relation>();
        for (Object object2 : list2) {
            Multipolygon multipolygon = this.joinPolygon((AssembledMultipolygon)object2);
            RelationRole relationRole = this.addOwnMultigonRelation(multipolygon.innerWays, multipolygon.outerWay);
            this.fixRelations(arrayList4, multipolygon.outerWay, relationRole, linkedHashSet);
            this.stripTags(multipolygon.innerWays);
            arrayList7.add(multipolygon);
        }
        this.commitCommands(I18n.marktr("Assemble new polygons"));
        Object object = linkedHashSet.iterator();
        while (object.hasNext()) {
            Object object2;
            object2 = (Relation)object.next();
            this.cmds.add(new DeleteCommand((OsmPrimitive)object2));
        }
        this.commitCommands(I18n.marktr("Delete relations"));
        if (!arrayList6.isEmpty() && (object = DeleteCommand.delete(Main.main.getEditLayer(), arrayList6, true)) != null) {
            this.cmds.add((Command)object);
            this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        }
        this.makeCommitsOneAction(I18n.marktr("Joined overlapping areas"));
        if (bl2) {
            new Notification(I18n.tr("Some of the ways were part of relations that have been modified.<br>Please verify no errors have been introduced.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
        }
        joinAreasResult.hasChanges = true;
        joinAreasResult.polygons = arrayList7;
        return joinAreasResult;
    }

    private boolean resolveTagConflicts(List<Multipolygon> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Multipolygon multipolygon : list) {
            arrayList.add(multipolygon.outerWay);
            arrayList.addAll(multipolygon.innerWays);
        }
        if (arrayList.size() < 2) {
            return true;
        }
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(arrayList);
        try {
            this.cmds.addAll(CombinePrimitiveResolverDialog.launchIfNecessary(tagCollection, arrayList, arrayList));
            this.commitCommands(I18n.marktr("Fix tag conflicts"));
            return true;
        }
        catch (UserCancelException userCancelException) {
            return false;
        }
    }

    private boolean removeDuplicateNodes(List<Way> list) {
        TreeMap<Node, Node> treeMap = new TreeMap<Node, Node>(new NodePositionComparator());
        int n = 0;
        for (Way way : list) {
            if (way.getNodes().size() < 2) continue;
            int n2 = 0;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node = null;
            for (Node node2 : way.getNodes()) {
                if (!treeMap.containsKey(node2)) {
                    treeMap.put(node2, node2);
                    if (node != node2) {
                        arrayList.add(node2);
                    } else {
                        ++n2;
                    }
                } else {
                    Node node3 = (Node)treeMap.get(node2);
                    if (node3 != node2) {
                        ++n2;
                    }
                    if (node != node3) {
                        arrayList.add(node3);
                    }
                }
                node = node2;
            }
            if (n2 <= 0) continue;
            if (arrayList.size() == 1) {
                arrayList.add((Node)arrayList.get(0));
            }
            Way way2 = new Way(way);
            way2.setNodes(arrayList);
            this.cmds.add(new ChangeCommand(way, way2));
            n += n2;
        }
        return n > 0;
    }

    private void commitCommands(String string) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr(string, new Object[0]), this.cmds);
                Main.main.undoRedo.add(sequenceCommand);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    /*
     * WARNING - void declaration
     */
    private List<WayInPolygon> markWayInsideSide(List<Way> list, boolean bl) {
        Node node;
        boolean bl2;
        Node node2;
        Object object;
        ArrayList<WayInPolygon> arrayList = new ArrayList<WayInPolygon>();
        HashMap<Way, Way> hashMap = new HashMap<Way, Way>();
        HashMap<Way, Way> hashMap2 = new HashMap<Way, Way>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).lastNode().equals(list.get((i + 1) % list.size()).firstNode())) {
                throw new RuntimeException("Way not circular");
            }
            hashMap.put(list.get(i), list.get((i + 1) % list.size()));
            hashMap2.put(list.get(i), list.get((i + list.size() - 1) % list.size()));
        }
        Way osmPrimitive = null;
        OsmPrimitive osmPrimitive2 = null;
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        for (Way object22 : list) {
            for (int i = 0; i < object22.getNodesCount(); ++i) {
                object = object22.getNode(i);
                if (!(((Node)object).getEastNorth().getY() < d)) continue;
                d = ((Node)object).getEastNorth().getY();
                osmPrimitive = object22;
                osmPrimitive2 = object;
                n = i;
            }
        }
        if (osmPrimitive2.equals(osmPrimitive.firstNode()) || osmPrimitive2.equals(osmPrimitive.lastNode())) {
            Object var12_14 = null;
            node2 = null;
            bl2 = false;
            OsmPrimitive osmPrimitive3 = osmPrimitive2;
            node2 = new Node(new EastNorth(((Node)osmPrimitive3).getEastNorth().getX(), ((Node)osmPrimitive3).getEastNorth().getY() - 100000.0));
            osmPrimitive = null;
            bl2 = false;
            object = null;
            for (Way way : list) {
                if (way.firstNode().equals(osmPrimitive3)) {
                    node = way.getNode(1);
                    if (osmPrimitive == null || !Geometry.isToTheRightSideOfLine(node2, (Node)osmPrimitive3, (Node)object, node)) {
                        osmPrimitive = way;
                        bl2 = true;
                        object = node;
                    }
                }
                if (!way.lastNode().equals(osmPrimitive3)) continue;
                node = way.getNode(way.getNodesCount() - 2);
                if (osmPrimitive != null && Geometry.isToTheRightSideOfLine(node2, (Node)osmPrimitive3, (Node)object, node)) continue;
                osmPrimitive = way;
                bl2 = false;
                object = node;
            }
        } else {
            Node node3 = osmPrimitive.getNode(n - 1);
            node2 = osmPrimitive.getNode(n + 1);
            bl2 = Geometry.angleIsClockwise(node3, (Node)osmPrimitive2, node2);
        }
        Way way = osmPrimitive;
        boolean bl3 = bl2 ^ bl;
        while (true) {
            void var12_19;
            object = new WayInPolygon((Way)var12_19, bl3);
            arrayList.add((WayInPolygon)object);
            Way way2 = (Way)hashMap.get(var12_19);
            Node node4 = var12_19.getNode(var12_19.getNodesCount() - 2);
            node = var12_19.lastNode();
            Node node5 = way2.getNode(1);
            if (way2 == osmPrimitive) break;
            int n2 = 0;
            for (Way way3 : list) {
                boolean bl4;
                if (way3 == var12_19 || !way3.lastNode().equals(node)) continue;
                Way way4 = (Way)hashMap.get(way3);
                Node node6 = way3.getNode(way3.getNodesCount() - 2);
                Node node7 = way4.getNode(1);
                boolean bl5 = Geometry.isToTheRightSideOfLine(node4, node, node5, node6);
                if (bl5 == (bl4 = Geometry.isToTheRightSideOfLine(node4, node, node5, node7))) continue;
                ++n2;
            }
            if (n2 % 2 != 0) {
                bl3 = !bl3;
            }
            Way way5 = way2;
        }
        return arrayList;
    }

    private List<Way> splitWayOnNodes(Way way, Set<Node> set) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        List<List<Node>> list = this.buildNodeChunks(way, set);
        if (list.size() > 1) {
            SplitWayAction.SplitWayResult splitWayResult = SplitWayAction.splitWay(Main.main.getEditLayer(), way, list, Collections.emptyList());
            this.cmds.add(splitWayResult.getCommand());
            this.commitCommands(I18n.marktr("Split ways into fragments"));
            arrayList.add(splitWayResult.getOriginalWay());
            arrayList.addAll(splitWayResult.getNewWays());
        } else {
            arrayList.add(way);
        }
        return arrayList;
    }

    private List<List<Node>> buildNodeChunks(Way way, Collection<Node> collection) {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (Node node : way.getNodes()) {
            arrayList2.add(node);
            if (arrayList2.size() <= 1 || !collection.contains(node)) continue;
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
            arrayList2.add(node);
        }
        if (arrayList2.size() > 1) {
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private List<AssembledMultipolygon> findPolygons(Collection<AssembledPolygon> collection) {
        List<PolygonLevel> list = this.findOuterWaysImpl(0, collection);
        ArrayList<AssembledMultipolygon> arrayList = new ArrayList<AssembledMultipolygon>();
        for (PolygonLevel polygonLevel : list) {
            if (polygonLevel.level % 2 != 0) continue;
            arrayList.add(polygonLevel.pol);
        }
        return arrayList;
    }

    private List<PolygonLevel> findOuterWaysImpl(int n, Collection<AssembledPolygon> collection) {
        ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
        for (AssembledPolygon assembledPolygon : collection) {
            boolean bl = true;
            ArrayList<AssembledPolygon> arrayList2 = new ArrayList<AssembledPolygon>();
            for (AssembledPolygon assembledPolygon2 : collection) {
                if (assembledPolygon2 == assembledPolygon) continue;
                if (JoinAreasAction.wayInsideWay(assembledPolygon, assembledPolygon2)) {
                    bl = false;
                    break;
                }
                if (!JoinAreasAction.wayInsideWay(assembledPolygon2, assembledPolygon)) continue;
                arrayList2.add(assembledPolygon2);
            }
            if (!bl) continue;
            AssembledMultipolygon assembledMultipolygon = new AssembledMultipolygon(assembledPolygon);
            PolygonLevel polygonLevel = new PolygonLevel(assembledMultipolygon, n);
            if (!arrayList2.isEmpty()) {
                List<PolygonLevel> list = this.findOuterWaysImpl(n + 1, arrayList2);
                arrayList.addAll(list);
                for (PolygonLevel polygonLevel2 : list) {
                    if (polygonLevel2.level != n + 1) continue;
                    assembledMultipolygon.innerWays.add(polygonLevel2.pol.outerWay);
                }
            }
            arrayList.add(polygonLevel);
        }
        return arrayList;
    }

    public static List<AssembledPolygon> findBoundaryPolygons(Collection<WayInPolygon> collection, List<Way> list) {
        WayInPolygon wayInPolygon;
        ArrayList<WayInPolygon> arrayList = new ArrayList<WayInPolygon>();
        HashSet hashSet = new HashSet();
        WayTraverser wayTraverser = new WayTraverser(collection);
        for (WayInPolygon object3 : collection) {
            if (hashSet.contains(object3)) continue;
            wayTraverser.startNewWay(object3);
            ArrayList<WayInPolygon> arrayList2 = new ArrayList<WayInPolygon>();
            wayInPolygon = object3;
            while (true) {
                boolean bl;
                arrayList2.add(wayInPolygon);
                WayInPolygon wayInPolygon2 = wayTraverser.advanceNextLeftmostWay();
                boolean bl2 = bl = wayInPolygon2 == null ? false : wayTraverser.isLastWayInsideToTheRight();
                if (wayInPolygon2 == null || hashSet.contains(wayInPolygon2) || !bl) {
                    wayInPolygon = null;
                    break;
                }
                if (arrayList2.contains(wayInPolygon2)) {
                    wayInPolygon = wayInPolygon2;
                    break;
                }
                wayInPolygon = wayInPolygon2;
            }
            if (wayInPolygon != null) {
                hashSet.addAll(arrayList2);
                while (arrayList2.get(0) != wayInPolygon) {
                    arrayList.add((WayInPolygon)arrayList2.get(0));
                    arrayList2.remove(0);
                }
                continue;
            }
            arrayList.addAll(arrayList2);
            hashSet.addAll(arrayList2);
        }
        wayTraverser.removeWays(arrayList);
        List<AssembledPolygon> list2 = new ArrayList();
        while (wayTraverser.hasWays()) {
            WayInPolygon wayInPolygon3 = wayTraverser.startNewWay();
            ArrayList<WayInPolygon> arrayList3 = new ArrayList<WayInPolygon>();
            wayInPolygon = wayInPolygon3;
            do {
                arrayList3.add(wayInPolygon);
                wayInPolygon = wayTraverser.advanceNextRightmostWay();
                if (wayInPolygon != null && wayTraverser.isLastWayInsideToTheRight()) continue;
                throw new RuntimeException("Join areas internal error.");
            } while (wayInPolygon != wayInPolygon3);
            wayTraverser.removeWays(arrayList3);
            list2.add(new AssembledPolygon(arrayList3));
        }
        for (WayInPolygon wayInPolygon4 : arrayList) {
            list.add(wayInPolygon4.way);
        }
        list2 = JoinAreasAction.fixTouchingPolygons(list2);
        return list2;
    }

    public static List<AssembledPolygon> fixTouchingPolygons(List<AssembledPolygon> list) {
        ArrayList<AssembledPolygon> arrayList = new ArrayList<AssembledPolygon>();
        for (AssembledPolygon assembledPolygon : list) {
            WayTraverser wayTraverser = new WayTraverser(assembledPolygon.ways);
            while (wayTraverser.hasWays()) {
                WayInPolygon wayInPolygon = wayTraverser.startNewWay();
                ArrayList<WayInPolygon> arrayList2 = new ArrayList<WayInPolygon>();
                WayInPolygon wayInPolygon2 = wayInPolygon;
                Node node = wayTraverser.getLastWayStartNode();
                arrayList2.add(wayInPolygon2);
                while (node != wayTraverser.getLastWayEndNode()) {
                    wayInPolygon2 = wayTraverser.advanceNextLeftmostWay();
                    arrayList2.add(wayInPolygon2);
                    if (wayInPolygon2 != null && wayTraverser.isLastWayInsideToTheRight()) continue;
                    throw new RuntimeException("Join areas internal error.");
                }
                wayTraverser.removeWays(arrayList2);
                arrayList.add(new AssembledPolygon(arrayList2));
            }
        }
        return arrayList;
    }

    public static boolean wayInsideWay(AssembledPolygon assembledPolygon, AssembledPolygon assembledPolygon2) {
        HashSet<Node> hashSet = new HashSet<Node>(assembledPolygon2.getNodes());
        List<Node> list = assembledPolygon.getNodes();
        for (Node node : list) {
            if (hashSet.contains(node)) continue;
            return Geometry.nodeInsidePolygon(node, assembledPolygon2.getNodes());
        }
        return false;
    }

    private Multipolygon joinPolygon(AssembledMultipolygon assembledMultipolygon) throws UserCancelException {
        Multipolygon multipolygon = new Multipolygon(this.joinWays(assembledMultipolygon.outerWay.ways));
        for (AssembledPolygon assembledPolygon : assembledMultipolygon.innerWays) {
            multipolygon.innerWays.add(this.joinWays(assembledPolygon.ways));
        }
        return multipolygon;
    }

    private Way joinWays(List<WayInPolygon> list) throws UserCancelException {
        WayInPolygon wayInPolygon;
        boolean bl = true;
        Object object = list.iterator();
        while (object.hasNext()) {
            wayInPolygon = object.next();
            bl &= !wayInPolygon.insideToTheRight;
        }
        if (bl) {
            object = list.iterator();
            while (object.hasNext()) {
                wayInPolygon = (WayInPolygon)object.next();
                wayInPolygon.insideToTheRight = !wayInPolygon.insideToTheRight;
            }
        }
        if ((object = this.joinOrientedWays(list)) == null || !((Way)object).isClosed()) {
            throw new RuntimeException("Join areas internal error.");
        }
        return object;
    }

    private Way joinOrientedWays(List<WayInPolygon> list) throws UserCancelException {
        if (list.size() < 2) {
            return list.get((int)0).way;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>(list.size());
        for (WayInPolygon wayInPolygon : list) {
            arrayList.add(wayInPolygon.way);
            if (wayInPolygon.insideToTheRight) continue;
            ReverseWayAction.ReverseWayResult reverseWayResult = ReverseWayAction.reverseWay(wayInPolygon.way);
            Main.main.undoRedo.add(reverseWayResult.getReverseCommand());
            ++this.cmdsCount;
        }
        Pair<Way, Command> pair = CombineWayAction.combineWaysWorker(arrayList);
        Main.main.undoRedo.add((Command)pair.b);
        ++this.cmdsCount;
        return (Way)pair.a;
    }

    private List<Multipolygon> collectMultipolygons(List<Way> list) {
        ArrayList<Multipolygon> arrayList = new ArrayList<Multipolygon>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        LinkedHashSet<Way> linkedHashSet2 = new LinkedHashSet<Way>();
        for (Relation osmPrimitive : OsmPrimitive.getParentRelations(list)) {
            if (osmPrimitive.isDeleted() || !osmPrimitive.isMultipolygon()) continue;
            boolean bl = false;
            arrayList2.clear();
            arrayList3.clear();
            for (RelationMember relationMember : osmPrimitive.getMembers()) {
                if (relationMember.getRole().equalsIgnoreCase("outer")) {
                    arrayList2.add(relationMember.getWay());
                    bl |= list.contains(relationMember.getWay());
                    continue;
                }
                if (!relationMember.getRole().equalsIgnoreCase("inner")) continue;
                arrayList3.add(relationMember.getWay());
            }
            if (!bl) continue;
            if (arrayList2.size() > 1) {
                new Notification(I18n.tr("Sorry. Cannot handle multipolygon relations with multiple outer ways.", new Object[0])).setIcon(1).show();
                return null;
            }
            Way way = (Way)arrayList2.get(0);
            arrayList3.retainAll(list);
            if (linkedHashSet.contains(way)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is outer in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            if (linkedHashSet2.contains(way)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            for (Way way2 : arrayList3) {
                if (linkedHashSet.contains(way2)) {
                    new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                    return null;
                }
                if (!linkedHashSet2.contains(way2)) continue;
                new Notification(I18n.tr("Sorry. Cannot handle way that is inner in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            linkedHashSet.add(way);
            linkedHashSet2.addAll(arrayList3);
            Multipolygon multipolygon = new Multipolygon(way);
            multipolygon.innerWays.addAll(arrayList3);
            arrayList.add(multipolygon);
        }
        for (Way way : list) {
            if (linkedHashSet.contains(way) || linkedHashSet2.contains(way)) continue;
            arrayList.add(new Multipolygon(way));
        }
        return arrayList;
    }

    private RelationRole addOwnMultigonRelation(Collection<Way> collection, Way way) {
        if (collection.isEmpty()) {
            return null;
        }
        Relation relation = new Relation();
        relation.put("type", "multipolygon");
        for (Way way2 : collection) {
            relation.addMember(new RelationMember("inner", way2));
        }
        this.cmds.add(new AddCommand(relation));
        return new RelationRole(relation, "outer");
    }

    private List<RelationRole> removeFromAllRelations(OsmPrimitive osmPrimitive) {
        ArrayList<RelationRole> arrayList = new ArrayList<RelationRole>();
        block0: for (Relation relation : Main.main.getCurrentDataSet().getRelations()) {
            if (relation.isDeleted()) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember() != osmPrimitive) continue;
                Relation relation2 = new Relation(relation);
                List<RelationMember> list = relation2.getMembers();
                list.remove(relationMember);
                relation2.setMembers(list);
                this.cmds.add(new ChangeCommand(relation, relation2));
                RelationRole relationRole = new RelationRole(relation, relationMember.getRole());
                if (arrayList.contains(relationRole)) continue block0;
                arrayList.add(relationRole);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return arrayList;
    }

    private void fixRelations(List<RelationRole> list, Way way, RelationRole relationRole, Set<Relation> set) {
        Object object;
        ArrayList<RelationRole> arrayList = new ArrayList<RelationRole>();
        if (relationRole != null) {
            arrayList.add(relationRole);
        }
        for (RelationRole object2 : list) {
            if (object2.rel.isMultipolygon() && object2.role.equalsIgnoreCase("outer")) {
                arrayList.add(object2);
                continue;
            }
            Object object3 = new Relation(object2.rel);
            ((Relation)object3).addMember(new RelationMember(object2.role, way));
            this.cmds.add(new ChangeCommand(object2.rel, (OsmPrimitive)object3));
        }
        switch (arrayList.size()) {
            case 0: {
                return;
            }
            case 1: {
                object = new Relation(((RelationRole)arrayList.get((int)0)).rel);
                ((Relation)object).addMember(new RelationMember(((RelationRole)arrayList.get((int)0)).role, way));
                this.cmds.add(new ChangeCommand(((RelationRole)arrayList.get((int)0)).rel, (OsmPrimitive)object));
                return;
            }
        }
        object = new Relation();
        for (Object object3 : arrayList) {
            for (RelationMember relationMember : ((RelationRole)object3).rel.getMembers()) {
                if (((Relation)object).getMembers().contains(relationMember)) continue;
                ((Relation)object).addMember(relationMember);
            }
            for (String string : ((RelationRole)object3).rel.keySet()) {
                ((OsmPrimitive)object).put(string, ((RelationRole)object3).rel.get(string));
            }
            set.add(((RelationRole)object3).rel);
        }
        ((Relation)object).addMember(new RelationMember("outer", way));
        this.cmds.add(new AddCommand((OsmPrimitive)object));
    }

    private void stripTags(Collection<Way> collection) {
        for (Way way : collection) {
            this.stripTags(way);
        }
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    private void stripTags(Way way) {
        Way way2 = new Way(way);
        for (String string : way.keySet()) {
            way2.remove(string);
        }
        this.cmds.add(new ChangeCommand(way, way2));
    }

    private void makeCommitsOneAction(String string) {
        int n;
        UndoRedoHandler undoRedoHandler = Main.main.undoRedo;
        this.cmds.clear();
        for (n = Math.max(undoRedoHandler.commands.size() - this.cmdsCount, 0); n < undoRedoHandler.commands.size(); ++n) {
            this.cmds.add(undoRedoHandler.commands.get(n));
        }
        for (n = 0; n < this.cmds.size(); ++n) {
            undoRedoHandler.undo();
        }
        this.commitCommands(string == null ? I18n.marktr("Join Areas Function") : string);
        this.cmdsCount = 0;
    }

    @Override
    protected void updateEnabledState() {
        if (JoinAreasAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(JoinAreasAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    static class PolygonLevel {
        public final int level;
        public final AssembledMultipolygon pol;

        public PolygonLevel(AssembledMultipolygon assembledMultipolygon, int n) {
            this.pol = assembledMultipolygon;
            this.level = n;
        }
    }

    private static class WayTraverser {
        private Set<WayInPolygon> availableWays;
        private WayInPolygon lastWay;
        private boolean lastWayReverse;

        public WayTraverser(Collection<WayInPolygon> collection) {
            this.availableWays = new HashSet<WayInPolygon>(collection);
            this.lastWay = null;
        }

        public void removeWays(Collection<WayInPolygon> collection) {
            this.availableWays.removeAll(collection);
        }

        public boolean hasWays() {
            return !this.availableWays.isEmpty();
        }

        public WayInPolygon startNewWay(WayInPolygon wayInPolygon) {
            this.lastWay = wayInPolygon;
            this.lastWayReverse = !this.lastWay.insideToTheRight;
            return this.lastWay;
        }

        public WayInPolygon startNewWay() {
            if (this.availableWays.isEmpty()) {
                this.lastWay = null;
            } else {
                this.lastWay = this.availableWays.iterator().next();
                this.lastWayReverse = !this.lastWay.insideToTheRight;
            }
            return this.lastWay;
        }

        public WayInPolygon advanceNextLeftmostWay() {
            return this.advanceNextWay(false);
        }

        public WayInPolygon advanceNextRightmostWay() {
            return this.advanceNextWay(true);
        }

        private WayInPolygon advanceNextWay(boolean bl) {
            Node node = !this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
            Node node2 = !this.lastWayReverse ? this.lastWay.way.getNode(this.lastWay.way.getNodesCount() - 2) : this.lastWay.way.getNode(1);
            WayInPolygon wayInPolygon = null;
            Node node3 = null;
            boolean bl2 = false;
            for (WayInPolygon wayInPolygon2 : this.availableWays) {
                Node node4;
                if (wayInPolygon2.way.firstNode().equals(node) && !(node4 = wayInPolygon2.way.getNode(1)).equals(node2) && (wayInPolygon == null || Geometry.isToTheRightSideOfLine(node2, node, node3, node4) == bl)) {
                    wayInPolygon = wayInPolygon2;
                    bl2 = false;
                    node3 = node4;
                }
                if (!wayInPolygon2.way.lastNode().equals(node) || (node4 = wayInPolygon2.way.getNode(wayInPolygon2.way.getNodesCount() - 2)).equals(node2) || wayInPolygon != null && Geometry.isToTheRightSideOfLine(node2, node, node3, node4) != bl) continue;
                wayInPolygon = wayInPolygon2;
                bl2 = true;
                node3 = node4;
            }
            this.lastWay = wayInPolygon;
            this.lastWayReverse = bl2;
            return this.lastWay;
        }

        public boolean isLastWayInsideToTheRight() {
            return this.lastWayReverse != this.lastWay.insideToTheRight;
        }

        public Node getLastWayStartNode() {
            return this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
        }

        public Node getLastWayEndNode() {
            return this.lastWayReverse ? this.lastWay.way.firstNode() : this.lastWay.way.lastNode();
        }
    }

    public static class AssembledMultipolygon {
        public AssembledPolygon outerWay;
        public List<AssembledPolygon> innerWays;

        public AssembledMultipolygon(AssembledPolygon assembledPolygon) {
            this.outerWay = assembledPolygon;
            this.innerWays = new ArrayList<AssembledPolygon>();
        }
    }

    public static class AssembledPolygon {
        public List<WayInPolygon> ways;

        public AssembledPolygon(List<WayInPolygon> list) {
            this.ways = list;
        }

        public List<Node> getNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (WayInPolygon wayInPolygon : this.ways) {
                int n;
                if (wayInPolygon.insideToTheRight) {
                    for (n = 0; n < wayInPolygon.way.getNodesCount() - 1; ++n) {
                        arrayList.add(wayInPolygon.way.getNode(n));
                    }
                    continue;
                }
                for (n = wayInPolygon.way.getNodesCount() - 1; n > 0; --n) {
                    arrayList.add(wayInPolygon.way.getNode(n));
                }
            }
            return arrayList;
        }
    }

    public static class WayInPolygon {
        public final Way way;
        public boolean insideToTheRight;

        public WayInPolygon(Way way, boolean bl) {
            this.way = way;
            this.insideToTheRight = bl;
        }

        public int hashCode() {
            return this.way.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof WayInPolygon)) {
                return false;
            }
            WayInPolygon wayInPolygon = (WayInPolygon)object;
            return wayInPolygon.way.equals(this.way) && wayInPolygon.insideToTheRight == this.insideToTheRight;
        }
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        public RelationRole(Relation relation, String string) {
            this.rel = relation;
            this.role = string;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelationRole)) {
                return false;
            }
            RelationRole relationRole = (RelationRole)object;
            return relationRole.role.equals(this.role) && relationRole.rel.equals(this.rel);
        }
    }

    public static class Multipolygon {
        public Way outerWay;
        public List<Way> innerWays;

        public Multipolygon(Way way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<Way>();
        }
    }

    public static class JoinAreasResult {
        public boolean hasChanges;
        public List<Multipolygon> polygons;
    }
}

