/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "createcircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private double calcang(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            return 0.0;
        }
        double d5 = Math.abs(d4 - d2);
        if (d5 == 0.0 && d < d3) {
            return 0.0;
        }
        if (d5 == 0.0 && d > d3) {
            return Math.PI;
        }
        double d6 = Math.abs(d3 - d);
        double d7 = Math.atan2(d6, d5);
        if (d4 > d2) {
            d7 = Math.PI - d7;
        }
        if (d3 < d) {
            d7 = -d7;
        }
        if ((d7 = 4.71238898038469 + d7) < 0.0) {
            d7 += Math.PI * 2;
        }
        if (d7 >= Math.PI * 2) {
            d7 -= Math.PI * 2;
        }
        return d7;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OsmPrimitive osmPrimitive2;
        if (!this.isEnabled()) {
            return;
        }
        int n = Main.pref.getInteger("createcircle.nodecount", 8);
        if (n < 1) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        Collection<OsmPrimitive> collection = CreateCircleAction.getCurrentDataSet().getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Way way = null;
        for (OsmPrimitive osmPrimitive2 : collection) {
            if (!(osmPrimitive2 instanceof Node)) continue;
            linkedList.add((Node)osmPrimitive2);
        }
        if (linkedList.isEmpty() && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive2 : collection) {
                if (!(osmPrimitive2 instanceof Way)) continue;
                way = (Way)osmPrimitive2;
                for (Node node : ((Way)osmPrimitive2).getNodes()) {
                    if (linkedList.contains(node)) continue;
                    linkedList.add(node);
                }
            }
        }
        Iterator<OsmPrimitive> iterator = new LinkedList();
        if (linkedList.size() == 2) {
            Object object;
            double d;
            osmPrimitive2 = (Node)linkedList.get(0);
            double d2 = ((Node)osmPrimitive2).getEastNorth().east();
            double d3 = ((Node)osmPrimitive2).getEastNorth().north();
            OsmPrimitive osmPrimitive3 = (Node)linkedList.get(1);
            double d4 = osmPrimitive3.getEastNorth().east();
            double d5 = osmPrimitive3.getEastNorth().north();
            double d6 = 0.5 * (d2 + d4);
            double d7 = 0.5 * (d3 + d5);
            double d8 = Math.sqrt(Math.pow(d6 - d2, 2.0) + Math.pow(d7 - d3, 2.0));
            double d9 = this.calcang(d6, d7, d2, d3);
            if (d9 < (d = this.calcang(d6, d7, d4, d5))) {
                double d10 = d9;
                OsmPrimitive osmPrimitive4 = osmPrimitive2;
                d9 = d;
                osmPrimitive2 = osmPrimitive3;
                d = d10;
                osmPrimitive3 = osmPrimitive4;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(n + 1);
            for (int i = 1; i <= n; ++i) {
                double d11 = d + Math.PI * 2 * (1.0 - (double)i / (double)n);
                if (d9 < 999.0 && d9 > d11 - 1.0E-9 && d9 < d11 + 1.0E-9) {
                    arrayList.add((Node)osmPrimitive2);
                    d9 = 999.0;
                    continue;
                }
                if (d < 999.0 && d > d11 - 1.0E-9 && d < d11 + 1.0E-9) {
                    arrayList.add((Node)osmPrimitive3);
                    d = 999.0;
                    continue;
                }
                double d12 = d6 + d8 * Math.cos(d11);
                double d13 = d7 + d8 * Math.sin(d11);
                Node node = new Node(Main.getProjection().eastNorth2latlon(new EastNorth(d12, d13)));
                arrayList.add(node);
                iterator.add((OsmPrimitive)((Object)new AddCommand(node)));
            }
            arrayList.add((Node)arrayList.get(0));
            if (way == null) {
                object = new Way();
                ((Way)object).setNodes(arrayList);
                iterator.add((OsmPrimitive)((Object)new AddCommand((OsmPrimitive)object)));
            } else {
                object = new Way(way);
                ((Way)object).setNodes(arrayList);
                iterator.add((OsmPrimitive)((Object)new ChangeCommand(way, (OsmPrimitive)object)));
            }
            if (d9 < 999.0 && ((object = osmPrimitive2.getReferrers()).isEmpty() || object.size() == 1 && object.contains(way))) {
                iterator.add((OsmPrimitive)((Object)new DeleteCommand(osmPrimitive2)));
            }
        } else if (linkedList.size() == 3) {
            OsmPrimitive osmPrimitive5;
            double d;
            osmPrimitive2 = (Node)linkedList.get(0);
            double d14 = ((Node)osmPrimitive2).getEastNorth().east();
            double d15 = ((Node)osmPrimitive2).getEastNorth().north();
            OsmPrimitive osmPrimitive6 = (Node)linkedList.get(1);
            double d16 = osmPrimitive6.getEastNorth().east();
            double d17 = osmPrimitive6.getEastNorth().north();
            OsmPrimitive osmPrimitive7 = (Node)linkedList.get(2);
            double d18 = osmPrimitive7.getEastNorth().east();
            double d19 = osmPrimitive7.getEastNorth().north();
            double d20 = 0.5 * ((d16 - d18) * (d14 - d18) - (d17 - d19) * (d19 - d15));
            double d21 = (d14 - d16) * (d19 - d15) - (d17 - d15) * (d14 - d18);
            if (d21 == 0.0) {
                new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
                return;
            }
            double d22 = 0.5 * (d14 + d16) + (d20 /= d21) * (d17 - d15);
            double d23 = 0.5 * (d15 + d17) + d20 * (d14 - d16);
            double d24 = Math.sqrt(Math.pow(d22 - d14, 2.0) + Math.pow(d23 - d15, 2.0));
            double d25 = this.calcang(d22, d23, d14, d15);
            double d26 = this.calcang(d22, d23, d16, d17);
            double d27 = this.calcang(d22, d23, d18, d19);
            if (d25 < d26) {
                d = d25;
                osmPrimitive5 = osmPrimitive2;
                d25 = d26;
                osmPrimitive2 = osmPrimitive6;
                d26 = d;
                osmPrimitive6 = osmPrimitive5;
            }
            if (d26 < d27) {
                d = d26;
                osmPrimitive5 = osmPrimitive6;
                d26 = d27;
                osmPrimitive6 = osmPrimitive7;
                d27 = d;
                osmPrimitive7 = osmPrimitive5;
            }
            if (d25 < d26) {
                d = d25;
                osmPrimitive5 = osmPrimitive2;
                d25 = d26;
                osmPrimitive2 = osmPrimitive6;
                d26 = d;
                osmPrimitive6 = osmPrimitive5;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 1; i <= n; ++i) {
                double d28 = Math.PI * 2 * (1.0 - (double)i / (double)n);
                if (d25 < 999.0 && d25 > d28) {
                    arrayList.add((Node)osmPrimitive2);
                    d25 = 999.0;
                }
                if (d26 < 999.0 && d26 > d28) {
                    arrayList.add((Node)osmPrimitive6);
                    d26 = 999.0;
                }
                if (d27 < 999.0 && d27 > d28) {
                    arrayList.add((Node)osmPrimitive7);
                    d27 = 999.0;
                }
                double d29 = d22 + d24 * Math.cos(d28);
                double d30 = d23 + d24 * Math.sin(d28);
                Node node = new Node(Main.getProjection().eastNorth2latlon(new EastNorth(d29, d30)));
                arrayList.add(node);
                iterator.add((OsmPrimitive)((Object)new AddCommand(node)));
            }
            arrayList.add((Node)arrayList.get(0));
            if (way == null) {
                Way way2 = new Way();
                way2.setNodes(arrayList);
                iterator.add((OsmPrimitive)((Object)new AddCommand(way2)));
            } else {
                Way way3 = new Way(way);
                way3.setNodes(arrayList);
                iterator.add((OsmPrimitive)((Object)new ChangeCommand(way, way3)));
            }
        } else {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), (Collection<Command>)((Object)iterator)));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (CreateCircleAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateCircleAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

