/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class TransformableElement
extends SVGElement {
    AffineTransform xform = null;

    public TransformableElement() {
    }

    public TransformableElement(String string, SVGElement sVGElement) {
        super(string, sVGElement);
    }

    public AffineTransform getXForm() {
        return this.xform != null ? new AffineTransform(this.xform) : null;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("transform"))) {
            this.xform = TransformableElement.parseTransform(styleAttribute.getStringValue());
        }
    }

    protected Shape shapeToParent(Shape shape) {
        if (this.xform == null) {
            return shape;
        }
        return this.xform.createTransformedShape(shape);
    }

    protected Rectangle2D boundsToParent(Rectangle2D rectangle2D) {
        if (this.xform == null) {
            return rectangle2D;
        }
        return this.xform.createTransformedShape(rectangle2D).getBounds2D();
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        AffineTransform affineTransform;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("transform")) && !(affineTransform = TransformableElement.parseTransform(styleAttribute.getStringValue())).equals(this.xform)) {
            this.xform = affineTransform;
            return true;
        }
        return false;
    }
}

