/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;

public class FontFace
extends SVGElement {
    public static final String TAG_NAME = "fontface";
    String fontFamily;
    int unitsPerEm = 1000;
    int ascent = -1;
    int descent = -1;
    int accentHeight = -1;
    int underlinePosition = -1;
    int underlineThickness = -1;
    int strikethroughPosition = -1;
    int strikethroughThickness = -1;
    int overlinePosition = -1;
    int overlineThickness = -1;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("font-family"))) {
            this.fontFamily = styleAttribute.getStringValue();
        }
        if (this.getPres(styleAttribute.setName("units-per-em"))) {
            this.unitsPerEm = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("ascent"))) {
            this.ascent = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("descent"))) {
            this.descent = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("accent-height"))) {
            this.accentHeight = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("underline-position"))) {
            this.underlinePosition = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("underline-thickness"))) {
            this.underlineThickness = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("strikethrough-position"))) {
            this.strikethroughPosition = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("strikethrough-thickenss"))) {
            this.strikethroughThickness = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("overline-position"))) {
            this.overlinePosition = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("overline-thickness"))) {
            this.overlineThickness = styleAttribute.getIntValue();
        }
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }

    public int getAscent() {
        if (this.ascent == -1) {
            this.ascent = this.unitsPerEm - ((Font)this.parent).getVertOriginY();
        }
        return this.ascent;
    }

    public int getDescent() {
        if (this.descent == -1) {
            this.descent = ((Font)this.parent).getVertOriginY();
        }
        return this.descent;
    }

    public int getAccentHeight() {
        if (this.accentHeight == -1) {
            this.accentHeight = this.getAscent();
        }
        return this.accentHeight;
    }

    public int getUnderlinePosition() {
        if (this.underlinePosition == -1) {
            this.underlinePosition = this.unitsPerEm * 5 / 6;
        }
        return this.underlinePosition;
    }

    public int getUnderlineThickness() {
        if (this.underlineThickness == -1) {
            this.underlineThickness = this.unitsPerEm / 20;
        }
        return this.underlineThickness;
    }

    public int getStrikethroughPosition() {
        if (this.strikethroughPosition == -1) {
            this.strikethroughPosition = this.unitsPerEm * 3 / 6;
        }
        return this.strikethroughPosition;
    }

    public int getStrikethroughThickness() {
        if (this.strikethroughThickness == -1) {
            this.strikethroughThickness = this.unitsPerEm / 20;
        }
        return this.strikethroughThickness;
    }

    public int getOverlinePosition() {
        if (this.overlinePosition == -1) {
            this.overlinePosition = this.unitsPerEm * 5 / 6;
        }
        return this.overlinePosition;
    }

    public int getOverlineThickness() {
        if (this.overlineThickness == -1) {
            this.overlineThickness = this.unitsPerEm / 20;
        }
        return this.overlineThickness;
    }

    @Override
    public boolean updateTime(double d) {
        return false;
    }
}

