/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;

public class JpegReader
implements MetadataReader {
    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        JpegDirectory jpegDirectory = metadata.getOrCreateDirectory(JpegDirectory.class);
        try {
            short s = bufferReader.getUInt8(0);
            jpegDirectory.setInt(0, s);
            int n = bufferReader.getUInt16(1);
            jpegDirectory.setInt(1, n);
            int n2 = bufferReader.getUInt16(3);
            jpegDirectory.setInt(3, n2);
            int n3 = bufferReader.getUInt8(5);
            jpegDirectory.setInt(5, n3);
            int n4 = 6;
            for (int i = 0; i < n3; ++i) {
                short s2 = bufferReader.getUInt8(n4++);
                short s3 = bufferReader.getUInt8(n4++);
                short s4 = bufferReader.getUInt8(n4++);
                JpegComponent jpegComponent = new JpegComponent(s2, s3, s4);
                jpegDirectory.setObject(6 + i, jpegComponent);
            }
        }
        catch (BufferBoundsException bufferBoundsException) {
            jpegDirectory.addError(bufferBoundsException.getMessage());
        }
    }
}

