/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.lockingfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sourceforge.jnlp.util.lockingfile.LockedFile;
import net.sourceforge.jnlp.util.lockingfile.StorageIoException;

public abstract class LockingReaderWriter {
    private LockedFile lockedFile;

    public LockingReaderWriter(File file) {
        this.lockedFile = LockedFile.getInstance(file);
    }

    public File getBackingFile() {
        return this.lockedFile.getFile();
    }

    public boolean isReadOnly() {
        return this.lockedFile.isReadOnly();
    }

    public void lock() {
        try {
            this.lockedFile.lock();
        }
        catch (IOException e) {
            throw new StorageIoException(e);
        }
    }

    public void unlock() {
        try {
            this.lockedFile.unlock();
        }
        catch (IOException e) {
            throw new StorageIoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContents() throws IOException {
        if (!this.getBackingFile().isFile()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getBackingFile()), "UTF-8"));
            this.writeContent(writer);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected abstract void writeContent(BufferedWriter var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readContents() throws IOException {
        if (!this.getBackingFile().isFile()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getBackingFile()), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                this.readLine(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected synchronized void readContentsLocked() throws IOException {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    LockingReaderWriter.this.readContents();
                }
                catch (IOException ex) {
                    throw new StorageIoException(ex);
                }
            }
        });
    }

    protected synchronized void writeContentsLocked() throws IOException {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    LockingReaderWriter.this.writeContents();
                }
                catch (IOException ex) {
                    throw new StorageIoException(ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLocked(Runnable r) {
        this.lock();
        try {
            r.run();
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void readLine(String var1);
}

