/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class UrlUtils {
    private static final String UTF8 = "utf-8";

    public static URL normalizeUrlAndStripParams(URL url, boolean encodeFileUrls) {
        try {
            String[] urlParts = url.toString().split("\\?");
            URL strippedUrl = new URL(urlParts[0]);
            return UrlUtils.normalizeUrl(strippedUrl, encodeFileUrls);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static URL normalizeUrlAndStripParams(URL url) {
        return UrlUtils.normalizeUrlAndStripParams(url, false);
    }

    public static boolean isLocalFile(URL url) {
        return !(!url.getProtocol().equals("file") || url.getAuthority() != null && !url.getAuthority().equals("") || url.getHost() != null && !url.getHost().equals(""));
    }

    public static URL decodeUrlQuietly(URL url) {
        try {
            return new URL(URLDecoder.decode(url.toString(), UTF8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return url;
        }
    }

    public static boolean isValidRFC2396Url(URL url) {
        try {
            url.toURI();
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URL normalizeUrl(URL url, boolean encodeFileUrls) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        boolean shouldEncode;
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        boolean bl = shouldEncode = encodeFileUrls || !"file".equals(protocol);
        if (protocol == null || !shouldEncode || url.getPath() == null || UrlUtils.isValidRFC2396Url(url)) {
            return url;
        }
        URL decodedURL = new URL(URLDecoder.decode(url.toString(), UTF8));
        URI uri = new URI(decodedURL.getProtocol(), null, decodedURL.getHost(), decodedURL.getPort(), decodedURL.getPath(), decodedURL.getQuery(), null);
        URL encodedURL = new URL(uri.toASCIIString());
        return encodedURL;
    }

    public static URL normalizeUrl(URL url) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        return UrlUtils.normalizeUrl(url, false);
    }

    public static URL normalizeUrlQuietly(URL url, boolean encodeFileUrls) {
        try {
            return UrlUtils.normalizeUrl(url, encodeFileUrls);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static URL normalizeUrlQuietly(URL url) {
        return UrlUtils.normalizeUrlQuietly(url, false);
    }

    public static File decodeUrlAsFile(URL url) {
        return new File(UrlUtils.decodeUrlQuietly(url).getFile());
    }
}

