/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen;

import net.sourceforge.jnlp.runtime.AppletEnvironment;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashErrorPanel;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.impls.DefaultErrorSplashScreen2012;
import net.sourceforge.jnlp.splashscreen.impls.DefaultSplashScreen2012;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;

public class SplashUtils {
    static final String ICEDTEA_WEB_PLUGIN_SPLASH = "ICEDTEA_WEB_PLUGIN_SPLASH";
    static final String ICEDTEA_WEB_SPLASH = "ICEDTEA_WEB_SPLASH";
    static final String NONE = "none";
    static final String DEFAULT = "default";

    public static void showErrorCaught(Throwable ex, AppletInstance appletInstance) {
        block2: {
            try {
                SplashUtils.showError(ex, appletInstance);
            }
            catch (Throwable t) {
                if (!JNLPRuntime.isDebug()) break block2;
                t.printStackTrace();
            }
        }
    }

    public static void showError(Throwable ex, AppletInstance appletInstance) {
        if (appletInstance == null) {
            return;
        }
        AppletEnvironment ae = appletInstance.getAppletEnvironment();
        SplashUtils.showError(ex, ae);
    }

    public static void showError(Throwable ex, AppletEnvironment ae) {
        if (ae == null) {
            return;
        }
        SplashController p = ae.getSplashControler();
        SplashUtils.showError(ex, p);
    }

    public static void showError(Throwable ex, SplashController f) {
        if (f == null) {
            return;
        }
        f.replaceSplash(SplashUtils.getErrorSplashScreen(f.getSplashWidth(), f.getSplashHeigth(), ex));
    }

    private static SplashReason getReason() {
        if (JNLPRuntime.isWebstartApplication()) {
            return SplashReason.JAVAWS;
        }
        return SplashReason.APPLET;
    }

    public static SplashPanel getSplashScreen(int width, int height) {
        return SplashUtils.getSplashScreen(width, height, SplashUtils.getReason());
    }

    public static SplashErrorPanel getErrorSplashScreen(int width, int height, Throwable ex) {
        return SplashUtils.getErrorSplashScreen(width, height, SplashUtils.getReason(), ex);
    }

    static SplashPanel getSplashScreen(int width, int height, SplashReason splashReason) {
        return SplashUtils.getSplashScreen(width, height, splashReason, null, false);
    }

    static SplashErrorPanel getErrorSplashScreen(int width, int height, SplashReason splashReason, Throwable ex) {
        return (SplashErrorPanel)SplashUtils.getSplashScreen(width, height, splashReason, ex, true);
    }

    static SplashPanel getSplashScreen(int width, int height, SplashReason splashReason, Throwable loadingException, boolean isError) {
        String splashEnvironmetVar = null;
        String pluginSplashEnvironmetVar = null;
        try {
            pluginSplashEnvironmetVar = System.getenv(ICEDTEA_WEB_PLUGIN_SPLASH);
            splashEnvironmetVar = System.getenv(ICEDTEA_WEB_SPLASH);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BasicComponentSplashScreen sp = null;
        if (SplashReason.JAVAWS.equals((Object)splashReason)) {
            if (NONE.equals(splashEnvironmetVar)) {
                return null;
            }
            if (DEFAULT.equals(splashEnvironmetVar)) {
                sp = isError ? new DefaultErrorSplashScreen2012(width, height, splashReason, loadingException) : new DefaultSplashScreen2012(width, height, splashReason);
            }
        }
        if (SplashReason.APPLET.equals((Object)splashReason)) {
            if (NONE.equals(pluginSplashEnvironmetVar)) {
                return null;
            }
            if (DEFAULT.equals(pluginSplashEnvironmetVar)) {
                sp = isError ? new DefaultErrorSplashScreen2012(width, height, splashReason, loadingException) : new DefaultSplashScreen2012(width, height, splashReason);
            }
        }
        sp = isError ? new DefaultErrorSplashScreen2012(width, height, splashReason, loadingException) : new DefaultSplashScreen2012(width, height, splashReason);
        sp.setVersion(Boot.version);
        return sp;
    }

    public static enum SplashReason {
        APPLET,
        JAVAWS;


        public String toString() {
            switch (this) {
                case APPLET: {
                    return "IcedTea-Web Plugin";
                }
                case JAVAWS: {
                    return "IcedTea-Web";
                }
            }
            return "unknown";
        }
    }
}

