/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.CertPath;
import java.util.Map;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.tools.JarCertVerifier;

public class JNLPAppVerifier
implements AppVerifier {
    @Override
    public boolean hasAlreadyTrustedPublisher(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        int sumOfSignableEntries = JarCertVerifier.getTotalJarEntries(signedJars);
        for (CertInformation certInfo : certs.values()) {
            Map<String, Integer> certSignedJars = certInfo.getSignedJars();
            if (JarCertVerifier.getTotalJarEntries(certSignedJars) != sumOfSignableEntries || !certInfo.isPublisherAlreadyTrusted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRootInCacerts(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        int sumOfSignableEntries = JarCertVerifier.getTotalJarEntries(signedJars);
        for (CertInformation certInfo : certs.values()) {
            Map<String, Integer> certSignedJars = certInfo.getSignedJars();
            if (JarCertVerifier.getTotalJarEntries(certSignedJars) != sumOfSignableEntries || !certInfo.isRootInCacerts()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullySigned(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        int sumOfSignableEntries = JarCertVerifier.getTotalJarEntries(signedJars);
        for (CertPath cPath : certs.keySet()) {
            if (!this.hasCompletelySignedApp(certs.get(cPath), sumOfSignableEntries)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkTrustWithUser(JarCertVerifier jcv, JNLPFile file) throws LaunchException {
        int sumOfSignableEntries = JarCertVerifier.getTotalJarEntries(jcv.getJarSignableEntries());
        for (CertPath cPath : jcv.getCertsList()) {
            jcv.setCurrentlyUsedCertPath(cPath);
            CertInformation info = jcv.getCertInformation(cPath);
            if (!this.hasCompletelySignedApp(info, sumOfSignableEntries)) continue;
            if (info.isPublisherAlreadyTrusted()) {
                return;
            }
            SecurityDialogs.AccessType dialogType = info.isRootInCacerts() && !info.hasSigningIssues() ? SecurityDialogs.AccessType.VERIFIED : (info.isRootInCacerts() ? SecurityDialogs.AccessType.SIGNING_ERROR : SecurityDialogs.AccessType.UNVERIFIED);
            boolean wasApproved = SecurityDialogs.showCertWarningDialog(dialogType, file, jcv);
            if (!wasApproved) continue;
            return;
        }
        throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCancelOnUserRequest"), "");
    }

    public boolean hasCompletelySignedApp(CertInformation info, int sumOfSignableEntries) {
        return JarCertVerifier.getTotalJarEntries(info.getSignedJars()) == sumOfSignableEntries;
    }
}

