/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import javax.swing.event.EventListenerList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.event.ApplicationEvent;
import net.sourceforge.jnlp.event.ApplicationListener;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.XDesktopEntry;
import sun.awt.AppContext;

public class ApplicationInstance {
    private JNLPFile file;
    private ThreadGroup group;
    private ClassLoader loader;
    private AppContext appContext;
    private boolean stopped = false;
    private WeakList<Window> weakWindows = new WeakList();
    private EventListenerList listeners = new EventListenerList();
    private boolean isSigned = false;

    public ApplicationInstance(JNLPFile file, ThreadGroup group, ClassLoader loader) {
        this.file = file;
        this.group = group;
        this.loader = loader;
        this.isSigned = ((JNLPClassLoader)loader).getSigning();
        this.appContext = AppContext.getAppContext();
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.listeners.add(ApplicationListener.class, listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(ApplicationListener.class, listener);
    }

    protected void fireDestroyed() {
        Object[] list = this.listeners.getListenerList();
        ApplicationEvent event = null;
        for (int i = list.length - 1; i > 0; i -= 2) {
            if (event == null) {
                event = new ApplicationEvent(this);
            }
            ((ApplicationListener)list[i]).applicationDestroyed(event);
        }
    }

    public void initialize() {
        this.installEnvironment();
        this.addMenuAndDesktopEntries();
    }

    private void addMenuAndDesktopEntries() {
        XDesktopEntry entry = new XDesktopEntry(this.file);
        ShortcutDesc sd = this.file.getInformation().getShortcut();
        File possibleDesktopFile = entry.getLinuxDesktopIconFile();
        if (possibleDesktopFile.exists()) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("ApplicationInstance.addMenuAndDesktopEntries(): file - " + possibleDesktopFile.getAbsolutePath() + " already exists. Not proceeding with desktop additions");
            }
            return;
        }
        if (this.shouldCreateShortcut(sd)) {
            entry.createDesktopShortcut();
        }
        if (sd != null && sd.getMenu() != null && JNLPRuntime.isDebug()) {
            System.err.println("ApplicationInstance.addMenuAndDesktopEntries(): Adding menu entries NOT IMPLEMENTED");
        }
    }

    private boolean shouldCreateShortcut(ShortcutDesc sd) {
        if (JNLPRuntime.isTrustAll()) {
            return sd != null && sd.onDesktop();
        }
        String currentSetting = JNLPRuntime.getConfiguration().getProperty("deployment.javaws.shortcut");
        boolean createShortcut = false;
        if (currentSetting.equals("NEVER")) {
            createShortcut = false;
        } else if (currentSetting.equals("ALWAYS")) {
            createShortcut = true;
        } else if (currentSetting.equals("ASK_USER")) {
            if (SecurityDialogs.showAccessWarningDialog(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file)) {
                createShortcut = true;
            }
        } else if (currentSetting.equals("ASK_IF_HINTED")) {
            if (sd != null && sd.onDesktop() && SecurityDialogs.showAccessWarningDialog(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file)) {
                createShortcut = true;
            }
        } else if (currentSetting.equals("ALWAYS_IF_HINTED") && sd != null && sd.onDesktop()) {
            createShortcut = true;
        }
        return createShortcut;
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] props = this.file.getResources().getProperties();
        CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
        JNLPClassLoader loader = (JNLPClassLoader)this.loader;
        SecurityDesc s = loader.getSecurity();
        ProtectionDomain pd = new ProtectionDomain(cs, s.getPermissions(cs), null, null);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        PrivilegedAction<Object> installProps = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (PropertyDesc propDesc : props) {
                    System.setProperty(propDesc.getKey(), propDesc.getValue());
                }
                return null;
            }
        };
        AccessController.doPrivileged(installProps, acc);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int i;
            for (Window w : this.weakWindows) {
                if (w == null) continue;
                w.dispose();
            }
            this.weakWindows.clear();
            Thread[] threads = new Thread[this.group.activeCount() * 2];
            int nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Interrupt thread: " + threads[i]);
                }
                threads[i].interrupt();
            }
            Thread.currentThread();
            Thread.yield();
            nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Stop thread: " + threads[i]);
                }
                threads[i].stop();
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }
}

