/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.UnsignedAppletActionTableModel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExtendedAppletSecurityHelp;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;
import net.sourceforge.jnlp.security.appletextendedsecurity.impl.UnsignedAppletActionStorageExtendedImpl;
import net.sourceforge.jnlp.util.ScreenFinder;

public class UnsignedAppletsTrustingListPanel
extends JPanel {
    private JButton helpButton;
    private JButton deleteButton;
    private JButton addRowButton;
    private JButton validateTableButton;
    private JButton testUrlButton;
    private JButton invertSelectionButton;
    private JButton moveRowUpButton;
    private JButton moveRowDownButton;
    private JCheckBox askBeforeActionCheckBox;
    private JCheckBox filterRegexesCheckBox;
    private JComboBox mainPolicyComboBox;
    private JComboBox deleteTypeComboBox;
    private JComboBox viewFilter;
    private JLabel globalBehaviourLabel;
    private JLabel securityLevelLabel;
    private JScrollPane userTableScrollPane;
    private JTabbedPane mainTabPanel;
    private JTable userTable;
    private JScrollPane globalTableScrollPane;
    private JTable globalTable;
    private final UnsignedAppletActionStorageExtendedImpl customBackEnd;
    private final UnsignedAppletActionStorageExtendedImpl globalBackEnd;
    private final UnsignedAppletActionTableModel customModel;
    private final UnsignedAppletActionTableModel globalModel;
    private final ByPermanencyFilter customFilter;
    private final ByPermanencyFilter globalFilter;
    private final DeploymentConfiguration conf;
    private JTable currentTable;
    private UnsignedAppletActionTableModel currentModel;
    private String lastDoc;
    private String lastCode;
    private final UnsignedAppletsTrustingListPanel self = this;

    public static void main(String[] args) {
        String defaultDir = System.getProperty("user.home") + "/Desktop/";
        String defaultFileName1 = "terrorList1";
        String defaultFileName2 = "terrorList2";
        final String defaultFile1 = defaultDir + "terrorList1";
        final String defaultFile2 = defaultDir + "terrorList2";
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFrame f = new JFrame();
                    f.setSize(700, 300);
                    f.setLayout(new BorderLayout());
                    f.setDefaultCloseOperation(3);
                    DeploymentConfiguration cc = new DeploymentConfiguration();
                    cc.load();
                    File ff1 = new File(defaultFile1);
                    File ff2 = new File(defaultFile2);
                    f.add(new UnsignedAppletsTrustingListPanel(ff2, ff1, cc));
                    f.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public UnsignedAppletsTrustingListPanel(File globalSettings, File customSettings, DeploymentConfiguration conf) {
        this.customBackEnd = new UnsignedAppletActionStorageExtendedImpl(customSettings);
        this.globalBackEnd = new UnsignedAppletActionStorageExtendedImpl(globalSettings);
        this.customModel = new UnsignedAppletActionTableModel(this.customBackEnd);
        this.globalModel = new UnsignedAppletActionTableModel(this.globalBackEnd);
        this.customFilter = new ByPermanencyFilter(this.customModel);
        this.globalFilter = new ByPermanencyFilter(this.globalModel);
        this.initComponents();
        this.userTable.setRowSorter(this.customFilter);
        this.globalTable.setRowSorter(this.globalFilter);
        this.conf = conf;
        AppletSecurityLevel gs = AppletSecurityLevel.getDefault();
        String s = conf.getProperty("deployment.security.level");
        if (s != null) {
            gs = AppletSecurityLevel.fromString(s);
        }
        this.mainPolicyComboBox.setSelectedItem((Object)gs);
        this.userTable.getSelectionModel().addListSelectionListener(new SingleSelectionListenerImpl(this.userTable));
        this.globalTable.getSelectionModel().addListSelectionListener(new SingleSelectionListenerImpl(this.globalTable));
        this.userTable.addKeyListener(new DeleteAdapter(this.userTable));
        this.globalTable.addKeyListener(new DeleteAdapter(this.globalTable));
        this.currentTable = this.userTable;
        this.currentModel = this.customModel;
        this.setButtons(!this.currentModel.back.isReadOnly());
    }

    public String appletItemsToCaption(List<UnsignedAppletActionEntry> ii, String caption) {
        StringBuilder sb = new StringBuilder();
        for (UnsignedAppletActionEntry i : ii) {
            sb.append(UnsignedAppletsTrustingListPanel.appletItemToCaption(i, caption)).append("\n");
        }
        return sb.toString();
    }

    public static String appletItemToCaption(UnsignedAppletActionEntry i, String caption) {
        return Translator.R("APPEXTSECguiPanelAppletInfoHederPart1", caption, i.getDocumentBase().getFilteredRegEx()) + "\n  (" + Translator.R("APPEXTSECguiPanelAppletInfoHederPart2", new Object[]{i.getUnsignedAppletAction(), DateFormat.getInstance().format(i.getTimeStamp())}) + "\n    " + Translator.R("APPEXTSECguiTableModelTableColumnDocumentBase") + ": " + i.getDocumentBase().getFilteredRegEx() + "\n    " + Translator.R("APPEXTSECguiTableModelTableColumnCodeBase") + ": " + i.getCodeBase().getFilteredRegEx() + "\n    " + Translator.R("APPEXTSECguiTableModelTableColumnArchives") + ": " + UnsignedAppletActionEntry.createArchivesString(i.getArchives());
    }

    public void removeSelectedFromTable(JTable table) {
        UnsignedAppletsTrustingListPanel.removeSelectedFromTable(table, this.askBeforeActionCheckBox.isSelected(), this.currentModel, this);
    }

    public static void removeSelectedFromTable(JTable table, boolean ask, UnsignedAppletActionTableModel data, Component forDialog) {
        int[] originalIndexes = table.getSelectedRows();
        ArrayList<Integer> newIndexes = new ArrayList<Integer>(originalIndexes.length);
        for (int i = 0; i < originalIndexes.length; ++i) {
            int modelRow = table.convertRowIndexToModel(originalIndexes[i]);
            newIndexes.add(modelRow);
        }
        Collections.sort(newIndexes);
        if (ask) {
            String s = Translator.R("APPEXTSECguiPanelConfirmDeletionOf", newIndexes.size()) + ": \n";
            UnsignedAppletActionEntry[] items = data.back.toArray();
            for (int i = 0; i < newIndexes.size(); ++i) {
                Integer integer = (Integer)newIndexes.get(i);
                s = s + UnsignedAppletsTrustingListPanel.appletItemToCaption(items[integer], "  ") + "\n";
            }
            int a = JOptionPane.showConfirmDialog(forDialog, s);
            if (a != 0) {
                return;
            }
        }
        int sub = 0;
        for (int i = 0; i < newIndexes.size(); ++i) {
            Integer integer = (Integer)newIndexes.get(i);
            data.removeRow(integer + sub);
            --sub;
        }
    }

    public void removeAllItemsFromTable(JTable table, UnsignedAppletActionTableModel model) {
        table.clearSelection();
        if (this.askBeforeActionCheckBox.isSelected()) {
            UnsignedAppletActionEntry[] items = model.back.toArray();
            String s = Translator.R("APPEXTSECguiPanelConfirmDeletionOf", items.length) + ": \n";
            for (int i = 0; i < items.length; ++i) {
                s = s + UnsignedAppletsTrustingListPanel.appletItemToCaption(items[i], "  ") + "\n";
            }
            int a = JOptionPane.showConfirmDialog(this, s);
            if (a != 0) {
                return;
            }
        }
        model.clear();
    }

    private void initComponents() {
        this.userTableScrollPane = new JScrollPane();
        this.globalTableScrollPane = new JScrollPane();
        this.userTable = this.createTbale(this.customModel);
        this.globalTable = this.createTbale(this.globalModel);
        this.helpButton = new JButton();
        this.mainPolicyComboBox = new JComboBox<AppletSecurityLevel>(new AppletSecurityLevel[]{AppletSecurityLevel.DENY_ALL, AppletSecurityLevel.DENY_UNSIGNED, AppletSecurityLevel.ASK_UNSIGNED, AppletSecurityLevel.ALLOW_UNSIGNED});
        this.mainPolicyComboBox.setSelectedItem((Object)AppletSecurityLevel.getDefault());
        this.securityLevelLabel = new JLabel();
        this.globalBehaviourLabel = new JLabel();
        this.deleteTypeComboBox = new JComboBox();
        this.viewFilter = new JComboBox();
        this.deleteButton = new JButton();
        this.testUrlButton = new JButton();
        this.addRowButton = new JButton();
        this.validateTableButton = new JButton();
        this.askBeforeActionCheckBox = new JCheckBox();
        this.filterRegexesCheckBox = new JCheckBox();
        this.invertSelectionButton = new JButton();
        this.moveRowUpButton = new JButton();
        this.moveRowDownButton = new JButton();
        this.mainTabPanel = new JTabbedPane();
        this.userTableScrollPane.setViewportView(this.userTable);
        this.globalTableScrollPane.setViewportView(this.globalTable);
        this.helpButton.setText(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.helpButtonActionPerformed(evt);
            }
        });
        this.mainPolicyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.mainPolicyComboBoxActionPerformed(evt);
            }
        });
        this.viewFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsignedAppletsTrustingListPanel.this.userTable.getRowSorter().setSortKeys(null);
                UnsignedAppletsTrustingListPanel.this.userTable.getRowSorter().setSortKeys(null);
                int i = UnsignedAppletsTrustingListPanel.this.viewFilter.getSelectedIndex();
                switch (i) {
                    case 0: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showPermanents);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showPermanents);
                        break;
                    }
                    case 1: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showTemporarilyDecisions);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showTemporarilyDecisions);
                        break;
                    }
                    case 2: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showAll);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showAll);
                        break;
                    }
                    case 3: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showPermanentA);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showPermanentA);
                        break;
                    }
                    case 4: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showPermanentN);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showPermanentN);
                        break;
                    }
                    case 5: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showHasChosenYes);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showHasChosenYes);
                        break;
                    }
                    case 6: {
                        UnsignedAppletsTrustingListPanel.this.customFilter.setRowFilter(ByPermanencyFilter.showHasChosenNo);
                        UnsignedAppletsTrustingListPanel.this.globalFilter.setRowFilter(ByPermanencyFilter.showHasChosenNo);
                    }
                }
            }
        });
        this.securityLevelLabel.setText(Translator.R("APPEXTSECguiPanelSecurityLevel"));
        this.globalBehaviourLabel.setText(Translator.R("APPEXTSECguiPanelGlobalBehaviourCaption"));
        this.deleteTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{Translator.R("APPEXTSECguiPanelDeleteMenuSelected"), Translator.R("APPEXTSECguiPanelDeleteMenuAllA"), Translator.R("APPEXTSECguiPanelDeleteMenuAllN"), Translator.R("APPEXTSECguiPanelDeleteMenuAlly"), Translator.R("APPEXTSECguiPanelDeleteMenuAlln"), Translator.R("APPEXTSECguiPanelDeleteMenuAllAll")}));
        this.viewFilter.setModel(new DefaultComboBoxModel<String>(new String[]{Translator.R("APPEXTSECguiPanelShowOnlyPermanent"), Translator.R("APPEXTSECguiPanelShowOnlyTemporal"), Translator.R("APPEXTSECguiPanelShowAll"), Translator.R("APPEXTSECguiPanelShowOnlyPermanentA"), Translator.R("APPEXTSECguiPanelShowOnlyPermanentN"), Translator.R("APPEXTSECguiPanelShowOnlyTemporalY"), Translator.R("APPEXTSECguiPanelShowOnlyTemporalN")}));
        this.deleteButton.setText(Translator.R("APPEXTSECguiPanelDeleteButton"));
        this.deleteButton.setToolTipText(Translator.R("APPEXTSECguiPanelDeleteButtonToolTip"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.testUrlButton.setText(Translator.R("APPEXTSECguiPanelTestUrlButton"));
        this.testUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.testUrlButtonActionPerformed(evt);
            }
        });
        this.addRowButton.setText(Translator.R("APPEXTSECguiPanelAddRowButton"));
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.addRowButtonActionPerformed(evt);
            }
        });
        this.validateTableButton.setText(Translator.R("APPEXTSECguiPanelValidateTableButton"));
        this.validateTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.validateTableButtonActionPerformed(evt);
            }
        });
        this.askBeforeActionCheckBox.setSelected(true);
        this.askBeforeActionCheckBox.setText(Translator.R("APPEXTSECguiPanelAskeforeActionBox"));
        this.filterRegexesCheckBox.setText(Translator.R("APPEXTSECguiPanelShowRegExesBox"));
        this.filterRegexesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.filterRegexesCheckBoxActionPerformed(evt);
            }
        });
        this.invertSelectionButton.setText(Translator.R("APPEXTSECguiPanelInverSelection"));
        this.invertSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.invertSelectionButtonActionPerformed(evt);
            }
        });
        this.moveRowUpButton.setText(Translator.R("APPEXTSECguiPanelMoveRowUp"));
        this.moveRowUpButton.setEnabled(false);
        this.moveRowUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.moveRowUpButtonActionPerformed(evt);
            }
        });
        this.moveRowDownButton.setText(Translator.R("APPEXTSECguiPanelMoveRowDown"));
        this.moveRowDownButton.setEnabled(false);
        this.moveRowDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsignedAppletsTrustingListPanel.this.moveRowDownButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainTabPanel, GroupLayout.Alignment.LEADING, -1, 583, Short.MAX_VALUE).addComponent(this.globalBehaviourLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.securityLevelLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainPolicyComboBox, 0, 474, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.addRowButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.validateTableButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.testUrlButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE).addComponent(this.moveRowDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveRowUpButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.invertSelectionButton)).addGroup(layout.createSequentialGroup().addComponent(this.askBeforeActionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterRegexesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 93, Short.MAX_VALUE).addComponent(this.viewFilter))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton, -2, 108, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.globalBehaviourLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.securityLevelLabel).addComponent(this.mainPolicyComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deleteButton).addComponent(this.deleteTypeComboBox).addComponent(this.invertSelectionButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.askBeforeActionCheckBox).addComponent(this.filterRegexesCheckBox).addComponent(this.viewFilter))).addComponent(this.helpButton, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mainTabPanel, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addRowButton).addComponent(this.validateTableButton).addComponent(this.testUrlButton).addComponent(this.moveRowUpButton).addComponent(this.moveRowDownButton)).addContainerGap()));
        JPanel userPanel = new JPanel(new BorderLayout());
        JPanel globalPanel = new JPanel(new BorderLayout());
        userPanel.add(this.userTableScrollPane);
        globalPanel.add(this.globalTableScrollPane);
        this.mainTabPanel.add(userPanel);
        this.mainTabPanel.add(globalPanel);
        this.mainTabPanel.setTitleAt(0, Translator.R("APPEXTSECguiPanelCustomDefs"));
        this.mainTabPanel.setTitleAt(1, Translator.R("APPEXTSECguiPanelGlobalDefs"));
        this.mainTabPanel.setToolTipTextAt(0, DeploymentConfiguration.getAppletTrustUserSettingsPath().getAbsolutePath());
        this.mainTabPanel.setToolTipTextAt(1, DeploymentConfiguration.getAppletTrustGlobalSettingsPath().getAbsolutePath());
        this.mainTabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (UnsignedAppletsTrustingListPanel.this.mainTabPanel.getSelectedIndex()) {
                    case 0: {
                        UnsignedAppletsTrustingListPanel.this.currentModel = UnsignedAppletsTrustingListPanel.this.customModel;
                        UnsignedAppletsTrustingListPanel.this.currentTable = UnsignedAppletsTrustingListPanel.this.userTable;
                        break;
                    }
                    case 1: {
                        UnsignedAppletsTrustingListPanel.this.currentModel = UnsignedAppletsTrustingListPanel.this.globalModel;
                        UnsignedAppletsTrustingListPanel.this.currentTable = UnsignedAppletsTrustingListPanel.this.globalTable;
                    }
                }
                UnsignedAppletsTrustingListPanel.this.setButtons(!((UnsignedAppletsTrustingListPanel)UnsignedAppletsTrustingListPanel.this).currentModel.back.isReadOnly());
            }
        });
    }

    private void mainPolicyComboBoxActionPerformed(ActionEvent evt) {
        try {
            this.conf.setProperty("deployment.security.level", ((AppletSecurityLevel)((Object)this.mainPolicyComboBox.getSelectedItem())).toChars());
            this.conf.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.deleteTypeComboBox.getSelectedIndex() == 0) {
            this.removeSelectedFromTable(this.currentTable);
        }
        if (this.deleteTypeComboBox.getSelectedIndex() == 1) {
            this.removeByBehaviour(ExecuteUnsignedApplet.ALWAYS);
        }
        if (this.deleteTypeComboBox.getSelectedIndex() == 2) {
            this.removeByBehaviour(ExecuteUnsignedApplet.NEVER);
        }
        if (this.deleteTypeComboBox.getSelectedIndex() == 3) {
            this.removeByBehaviour(ExecuteUnsignedApplet.YES);
        }
        if (this.deleteTypeComboBox.getSelectedIndex() == 4) {
            this.removeByBehaviour(ExecuteUnsignedApplet.NO);
        }
        if (this.deleteTypeComboBox.getSelectedIndex() == 5) {
            this.removeAllItemsFromTable(this.currentTable, this.customModel);
        }
    }

    private void testUrlButtonActionPerformed(ActionEvent evt) {
        String s1 = JOptionPane.showInputDialog(Translator.R("APPEXTSECguiPanelDocTest"), (Object)this.lastDoc);
        String s2 = JOptionPane.showInputDialog(Translator.R("APPEXTSECguiPanelCodeTest"), (Object)this.lastCode);
        this.lastDoc = s1;
        this.lastCode = s2;
        try {
            List<UnsignedAppletActionEntry> i = this.currentModel.back.getMatchingItems(s1, s2, null);
            if (i == null || i.isEmpty()) {
                JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelNoMatch"));
            } else {
                JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelMatchingNote") + "\n" + this.appletItemsToCaption(i, Translator.R("APPEXTSECguiPanelMatched") + ": "));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelMatchingError", ex));
        }
    }

    private void addRowButtonActionPerformed(ActionEvent evt) {
        this.currentModel.addRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTableButtonActionPerformed(ActionEvent evt) {
        File f = null;
        try {
            f = File.createTempFile("appletTable", "validation");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelCanNOtValidate", ex.toString()));
            return;
        }
        try {
            this.currentModel.back.writeContentsLocked();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            this.currentModel.back.writeContent(bw);
            bw.flush();
            bw.close();
            UnsignedAppletActionStorageExtendedImpl copy = new UnsignedAppletActionStorageExtendedImpl(f);
            UnsignedAppletActionEntry[] items = copy.toArray();
            for (int i = 0; i < items.length; ++i) {
                UnsignedAppletActionEntry unsignedAppletActionEntry = items[i];
                if (unsignedAppletActionEntry.getDocumentBase() == null || unsignedAppletActionEntry.getDocumentBase().getRegEx().trim().isEmpty()) {
                    throw new RuntimeException(Translator.R("APPEXTSECguiPanelEmptyDoc"));
                }
                Pattern p = Pattern.compile(unsignedAppletActionEntry.getDocumentBase().getRegEx());
                p.matcher("someInput").find();
                if (unsignedAppletActionEntry.getCodeBase() == null || unsignedAppletActionEntry.getCodeBase().getRegEx().trim().isEmpty()) {
                    throw new RuntimeException(Translator.R("APPEXTSECguiPanelEmptyCode"));
                }
                p = Pattern.compile(unsignedAppletActionEntry.getCodeBase().getRegEx());
                p.matcher("someInput").find();
                UnsignedAppletActionEntry.createArchivesString(UnsignedAppletActionEntry.createArchivesList(UnsignedAppletActionEntry.createArchivesString(unsignedAppletActionEntry.getArchives())));
            }
            JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelTableValid"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, Translator.R("APPEXTSECguiPanelTableInvalid ", ex.toString()));
        }
        finally {
            f.delete();
        }
    }

    private void filterRegexesCheckBoxActionPerformed(ActionEvent evt) {
        this.reloadTable();
    }

    private void invertSelectionButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndexs = this.currentTable.getSelectedRows();
        this.currentTable.selectAll();
        block0: for (int i = 0; i < this.currentTable.getRowCount(); ++i) {
            for (int selectedIndex : selectedIndexs) {
                if (selectedIndex != i) continue;
                this.currentTable.removeRowSelectionInterval(i, i);
                continue block0;
            }
        }
    }

    private void moveRowUpButtonActionPerformed(ActionEvent evt) {
        int nwx;
        int i;
        int orig = this.currentTable.getSelectedRow();
        if (orig < 0 || orig >= this.currentTable.getRowCount()) {
            return;
        }
        int nw = 0;
        do {
            i = this.currentTable.convertRowIndexToModel(orig);
            nwx = this.currentModel.moveUp(i);
            this.reloadTable();
            nw = this.currentTable.convertRowIndexToView(nwx);
        } while (i != nwx && nw == orig);
        if (nw != orig) {
            if (orig >= 1) {
                this.currentTable.getSelectionModel().setSelectionInterval(orig - 1, orig - 1);
            }
        } else {
            this.currentTable.getSelectionModel().setSelectionInterval(orig, orig);
        }
    }

    private void moveRowDownButtonActionPerformed(ActionEvent evt) {
        int nwx;
        int i;
        int orig = this.currentTable.getSelectedRow();
        if (orig < 0 || orig >= this.currentTable.getRowCount()) {
            return;
        }
        int nw = 0;
        do {
            i = this.currentTable.convertRowIndexToModel(orig);
            nwx = this.currentModel.moveDown(i);
            this.reloadTable();
            nw = this.currentTable.convertRowIndexToView(nwx);
        } while (i != nwx && nw == orig);
        if (nw != orig) {
            if (orig < this.currentModel.getRowCount()) {
                this.currentTable.getSelectionModel().setSelectionInterval(orig + 1, orig + 1);
            }
        } else {
            this.currentTable.getSelectionModel().setSelectionInterval(orig, orig);
        }
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        ExtendedAppletSecurityHelp d = new ExtendedAppletSecurityHelp(null, false);
        ScreenFinder.centerWindowsToCurrentScreen(d);
        d.setVisible(true);
    }

    private void setButtons(boolean b) {
        this.deleteButton.setEnabled(b);
        this.addRowButton.setEnabled(b);
        this.invertSelectionButton.setEnabled(b);
        this.moveRowUpButton.setEnabled(b);
        this.moveRowDownButton.setEnabled(b);
    }

    private JTable createTbale(final TableModel model) {
        JTable jt = new JTable(){

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                int columnx = this.convertColumnIndexToModel(column);
                if (columnx == 0) {
                    return new DefaultCellEditor(new JComboBox<ExecuteUnsignedApplet>(new ExecuteUnsignedApplet[]{ExecuteUnsignedApplet.ALWAYS, ExecuteUnsignedApplet.NEVER, ExecuteUnsignedApplet.YES, ExecuteUnsignedApplet.NO}));
                }
                if (columnx == 2) {
                    column = this.convertColumnIndexToModel(column);
                    row = this.convertRowIndexToModel(row);
                    return new DefaultCellEditor(new MyTextField((UrlRegEx)model.getValueAt(row, column)));
                }
                if (columnx == 3) {
                    column = this.convertColumnIndexToModel(column);
                    row = this.convertRowIndexToModel(row);
                    return new DefaultCellEditor(new MyTextField((UrlRegEx)model.getValueAt(row, column)));
                }
                return super.getCellEditor(row, column);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                int columnx = this.convertColumnIndexToModel(column);
                if (columnx == 1) {
                    column = this.convertColumnIndexToModel(column);
                    row = this.convertRowIndexToModel(row);
                    return new UrlRegexCellRenderer.MyDateCellRenderer((Date)model.getValueAt(row, column));
                }
                if (columnx == 2 && !UnsignedAppletsTrustingListPanel.this.filterRegexesCheckBox.isSelected()) {
                    column = this.convertColumnIndexToModel(column);
                    row = this.convertRowIndexToModel(row);
                    return new UrlRegexCellRenderer((UrlRegEx)model.getValueAt(row, column));
                }
                if (columnx == 3 && !UnsignedAppletsTrustingListPanel.this.filterRegexesCheckBox.isSelected()) {
                    column = this.convertColumnIndexToModel(column);
                    row = this.convertRowIndexToModel(row);
                    return new UrlRegexCellRenderer((UrlRegEx)model.getValueAt(row, column));
                }
                return super.getCellRenderer(row, column);
            }
        };
        jt.setRowHeight(jt.getRowHeight() + jt.getRowHeight() / 2);
        jt.setModel(model);
        return jt;
    }

    private void reloadTable() {
        List<RowSorter.SortKey> l = this.currentTable.getRowSorter().getSortKeys();
        this.currentTable.setModel(new DefaultTableModel());
        this.currentTable.setModel(this.currentModel);
        this.currentTable.getRowSorter().setSortKeys(l);
    }

    private void removeByBehaviour(ExecuteUnsignedApplet unsignedAppletAction) {
        UnsignedAppletActionEntry[] items = this.currentModel.back.toArray();
        if (this.askBeforeActionCheckBox.isSelected()) {
            ArrayList<UnsignedAppletActionEntry> toBeDeleted = new ArrayList<UnsignedAppletActionEntry>();
            for (int i = 0; i < items.length; ++i) {
                UnsignedAppletActionEntry unsignedAppletActionEntry = items[i];
                if (unsignedAppletActionEntry.getUnsignedAppletAction() != unsignedAppletAction) continue;
                toBeDeleted.add(unsignedAppletActionEntry);
            }
            String s = Translator.R("APPEXTSECguiPanelConfirmDeletionOf", toBeDeleted.size()) + ": \n";
            for (int i = 0; i < toBeDeleted.size(); ++i) {
                s = s + UnsignedAppletsTrustingListPanel.appletItemToCaption((UnsignedAppletActionEntry)toBeDeleted.get(i), "  ") + "\n";
            }
            int a = JOptionPane.showConfirmDialog(this, s);
            if (a != 0) {
                return;
            }
        }
        this.currentModel.removeByBehaviour(unsignedAppletAction);
    }

    private static final class ByPermanencyFilter
    extends TableRowSorter<UnsignedAppletActionTableModel> {
        public static final ShowAll showAll = new ShowAll();
        public static final ShowPermanents showPermanents = new ShowPermanents();
        public static final ShowPermanentA showPermanentA = new ShowPermanentA();
        public static final ShowPermanentN showPermanentN = new ShowPermanentN();
        public static final ShowTemporarilyDecisions showTemporarilyDecisions = new ShowTemporarilyDecisions();
        public static final ShowHasChosenYes showHasChosenYes = new ShowHasChosenYes();
        public static final ShowHasChosenNo showHasChosenNo = new ShowHasChosenNo();

        public ByPermanencyFilter(UnsignedAppletActionTableModel model) {
            super(model);
            this.setRowFilter(showPermanents);
        }

        private static final class ShowHasChosenNo
        extends MyCommonSorter {
            private ShowHasChosenNo() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.NO);
            }
        }

        private static final class ShowHasChosenYes
        extends MyCommonSorter {
            private ShowHasChosenYes() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.YES);
            }
        }

        private static final class ShowTemporarilyDecisions
        extends MyCommonSorter {
            private ShowTemporarilyDecisions() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.YES) || o.equals((Object)ExecuteUnsignedApplet.NO);
            }
        }

        private static final class ShowPermanentN
        extends MyCommonSorter {
            private ShowPermanentN() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.NEVER);
            }
        }

        private static final class ShowPermanentA
        extends MyCommonSorter {
            private ShowPermanentA() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.ALWAYS);
            }
        }

        private static final class ShowPermanents
        extends MyCommonSorter {
            private ShowPermanents() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                ExecuteUnsignedApplet o = (ExecuteUnsignedApplet)((Object)entry.getModel().getValueAt(entry.getIdentifier(), 0));
                return o.equals((Object)ExecuteUnsignedApplet.ALWAYS) || o.equals((Object)ExecuteUnsignedApplet.NEVER);
            }
        }

        private static final class ShowAll
        extends MyCommonSorter {
            private ShowAll() {
            }

            @Override
            public boolean include(RowFilter.Entry<? extends UnsignedAppletActionTableModel, ? extends Integer> entry) {
                return true;
            }
        }
    }

    private static abstract class MyCommonSorter
    extends RowFilter<UnsignedAppletActionTableModel, Integer> {
        private MyCommonSorter() {
        }
    }

    private final class DeleteAdapter
    implements KeyListener {
        private final JTable table;

        public DeleteAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127 && !((UnsignedAppletsTrustingListPanel)UnsignedAppletsTrustingListPanel.this).currentModel.back.isReadOnly()) {
                UnsignedAppletsTrustingListPanel.removeSelectedFromTable(this.table, UnsignedAppletsTrustingListPanel.this.askBeforeActionCheckBox.isSelected(), (UnsignedAppletActionTableModel)this.table.getModel(), UnsignedAppletsTrustingListPanel.this.self);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private final class SingleSelectionListenerImpl
    implements ListSelectionListener {
        private final JTable table;

        public SingleSelectionListenerImpl(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.table.getSelectedRows().length == 1 && !((UnsignedAppletsTrustingListPanel)UnsignedAppletsTrustingListPanel.this).currentModel.back.isReadOnly()) {
                UnsignedAppletsTrustingListPanel.this.moveRowUpButton.setEnabled(true);
                UnsignedAppletsTrustingListPanel.this.moveRowDownButton.setEnabled(true);
            } else {
                UnsignedAppletsTrustingListPanel.this.moveRowUpButton.setEnabled(false);
                UnsignedAppletsTrustingListPanel.this.moveRowDownButton.setEnabled(false);
            }
        }
    }

    public static final class UrlRegexCellRenderer
    extends DefaultTableCellRenderer {
        private final UrlRegEx keeper;

        private UrlRegexCellRenderer(UrlRegEx urlRegEx) {
            this.keeper = urlRegEx == null ? new UrlRegEx("") : urlRegEx;
            this.setText(this.keeper.getFilteredRegEx());
        }

        @Override
        public void setText(String t) {
            if (this.keeper == null) {
                super.setText("");
            } else {
                super.setText(this.keeper.getFilteredRegEx());
            }
        }

        public static final class MyDateCellRenderer
        extends DefaultTableCellRenderer {
            private final Date keeper;

            private MyDateCellRenderer(Date d) {
                this.keeper = d;
                this.setText(DateFormat.getInstance().format(d));
            }

            @Override
            public void setText(String t) {
                if (this.keeper == null) {
                    super.setText("");
                } else {
                    super.setText(DateFormat.getInstance().format(this.keeper));
                }
            }
        }
    }

    public static final class MyTextField
    extends JTextField {
        private final UrlRegEx keeper;

        private MyTextField(UrlRegEx urlRegEx) {
            this.keeper = urlRegEx == null ? new UrlRegEx("") : urlRegEx;
            this.setText(this.keeper.getFilteredRegEx());
        }

        @Override
        public void setText(String t) {
            super.setText(this.keeper.getRegEx());
        }
    }
}

