/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.config.BasicValueValidators;
import net.sourceforge.jnlp.config.SecurityValueValidator;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.Translator;

public class Defaults {
    public static Map<String, Setting<String>> getDefaults() {
        File userFile = new File(System.getProperty("user.home") + File.separator + ".icedtea" + File.separator + "deployment.properties");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(userFile.toString());
        }
        String SYSTEM_HOME = System.getProperty("java.home");
        String SYSTEM_SECURITY = SYSTEM_HOME + File.separator + "lib" + File.separator + "security";
        String USER_HOME = System.getProperty("user.home") + File.separator + ".icedtea";
        String USER_SECURITY = USER_HOME + File.separator + "security";
        String LOCKS_DIR = System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + File.separator + "netx" + File.separator + "locks";
        Object[][] defaults = new Object[][]{{"deployment.user.cachedir", BasicValueValidators.getFilePathValidator(), USER_HOME + File.separator + "cache"}, {"deployment.user.pcachedir", BasicValueValidators.getFilePathValidator(), USER_HOME + File.separator + "pcache"}, {"deployment.system.cachedir", BasicValueValidators.getFilePathValidator(), null}, {"deployment.user.logdir", BasicValueValidators.getFilePathValidator(), USER_HOME + File.separator + "log"}, {"deployment.user.tmp", BasicValueValidators.getFilePathValidator(), USER_HOME + File.separator + "tmp"}, {"deployment.user.locksdir", BasicValueValidators.getFilePathValidator(), LOCKS_DIR}, {"deployment.user.runningfile", BasicValueValidators.getFilePathValidator(), LOCKS_DIR + File.separator + "netx_running"}, {"deployment.user.security.policy", BasicValueValidators.getUrlValidator(), "file://" + USER_SECURITY + File.separator + "java.policy"}, {"deployment.user.security.trusted.cacerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.cacerts"}, {"deployment.user.security.trusted.jssecacerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.jssecacerts"}, {"deployment.user.security.trusted.certs", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.certs"}, {"deployment.user.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.jssecerts"}, {"deployment.user.security.trusted.clientauthcerts", BasicValueValidators.getFilePathValidator(), USER_SECURITY + File.separator + "trusted.clientcerts"}, {"deployment.system.security.policy", BasicValueValidators.getUrlValidator(), null}, {"deployment.system.security.cacerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "cacerts"}, {"deployment.system.security.jssecacerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "jssecacerts"}, {"deployment.system.security.trusted.certs", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.certs"}, {"deployment.system.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.jssecerts"}, {"deployment.system.security.trusted.clientautcerts", BasicValueValidators.getFilePathValidator(), SYSTEM_SECURITY + File.separator + "trusted.clientcerts"}, {"deployment.security.askgrantdialog.show", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.askgrantdialog.notinca", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.notinca.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.expired.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.jsse.hostmismatch.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.trusted.policy", BasicValueValidators.getFilePathValidator(), null}, {"deployment.security.sandbox.awtwarningwindow", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.sandbox.jnlp.enhanced", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.authenticator", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.proxy.type", BasicValueValidators.getRangedIntegerValidator(-1, 3), String.valueOf(3)}, {"deployment.proxy.same", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.proxy.auto.config.url", BasicValueValidators.getUrlValidator(), null}, {"deployment.proxy.bypass.list", null, null}, {"deployment.proxy.bypass.local", null, null}, {"deployment.proxy.http.host", null, null}, {"deployment.proxy.http.port", null, null}, {"deployment.proxy.https.host", null, null}, {"deployment.proxy.https.port", null, null}, {"deployment.proxy.ftp.host", null, null}, {"deployment.proxy.ftp.port", null, null}, {"deployment.proxy.socks.host", null, null}, {"deployment.proxy.socks.port", null, null}, {"deployment.proxy.override.hosts", null, null}, {"deployment.cache.max.size", BasicValueValidators.getRangedIntegerValidator(-1, Integer.MAX_VALUE), String.valueOf("-1")}, {"deployment.cache.jarcompression", BasicValueValidators.getRangedIntegerValidator(0, 10), String.valueOf(0)}, {"deployment.javapi.cache.enabled", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.console.startup.mode", BasicValueValidators.getStringValidator(new String[]{"DISABLE", "HIDE", "SHOW"}), "HIDE"}, {"deployment.trace", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.javaws.associations", BasicValueValidators.getRangedIntegerValidator(0, 3), String.valueOf(2)}, {"deployment.javaws.shortcut", BasicValueValidators.getStringValidator(new String[]{"ALWAYS", "ALWAYS_IF_HINTED", "ASK_USER", "ASK_IF_HINTED", "NEVER"}), "ASK_IF_HINTED"}, {"deployment.javaws.installURL", BasicValueValidators.getUrlValidator(), null}, {"deployment.javaws.autodownload", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.browser.path", BasicValueValidators.getFilePathValidator(), null}, {"deployment.javaws.update.timeout", BasicValueValidators.getRangedIntegerValidator(0, 10000), String.valueOf(500)}, {"deployment.plugin.jvm.arguments", null, null}, {"deployment.security.level", new SecurityValueValidator(), null}, {"deployment.jre.dir", null, null}};
        HashMap<String, Setting<String>> result = new HashMap<String, Setting<String>>();
        for (int i = 0; i < defaults.length; ++i) {
            String name = (String)defaults[i][0];
            ValueValidator checker = (ValueValidator)defaults[i][1];
            String actualValue = (String)defaults[i][2];
            boolean locked = false;
            Setting<String> value = new Setting<String>(name, Translator.R("Unknown"), locked, checker, actualValue, actualValue, Translator.R("DCSourceInternal"));
            result.put(name, value);
        }
        return result;
    }
}

