/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.IllegalResourceDescriptorException;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.cache.ResourceUrlCreator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.event.DownloadEvent;
import net.sourceforge.jnlp.event.DownloadListener;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.HttpUtils;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.WeakList;

public class ResourceTracker {
    private static final Object lock = new Object();
    private static final int UNINITIALIZED = 0;
    private static final int CONNECT = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 4;
    private static final int DOWNLOAD = 8;
    private static final int DOWNLOADING = 16;
    private static final int DOWNLOADED = 32;
    private static final int ERROR = 64;
    private static final int STARTED = 128;
    private static final int maxThreads = 5;
    private static final String[] requestMethods = new String[]{"HEAD", "GET"};
    private static int threads = 0;
    private static WeakList<ResourceTracker> prefetchTrackers = new WeakList();
    private static ArrayList<Resource> queue = new ArrayList();
    private static ConcurrentHashMap<Resource, DownloadOptions> downloadOptions = new ConcurrentHashMap();
    private static ArrayList<ResourceTracker> active = new ArrayList();
    private List<Resource> resources = new ArrayList<Resource>();
    private List<DownloadListener> listeners = new ArrayList<DownloadListener>();
    private boolean prefetch;

    public ResourceTracker() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceTracker(boolean prefetch) {
        this.prefetch = prefetch;
        if (prefetch) {
            WeakList<ResourceTracker> weakList = prefetchTrackers;
            synchronized (weakList) {
                prefetchTrackers.add(this);
                prefetchTrackers.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(URL location, Version version, DownloadOptions options, UpdatePolicy updatePolicy) {
        if (location == null) {
            throw new IllegalResourceDescriptorException("location==null");
        }
        try {
            location = UrlUtils.normalizeUrl(location);
        }
        catch (Exception ex) {
            System.err.println("Normalization of " + location.toString() + " have failed");
            ex.printStackTrace();
        }
        Resource resource = Resource.getResource(location, version, updatePolicy);
        boolean downloaded = false;
        Object object = this.resources;
        synchronized (object) {
            if (this.resources.contains(resource)) {
                return;
            }
            resource.addTracker(this);
            this.resources.add(resource);
        }
        if (options == null) {
            options = new DownloadOptions(false, false);
        }
        downloadOptions.put(resource, options);
        downloaded = this.checkCache(resource, updatePolicy);
        object = lock;
        synchronized (object) {
            if (!downloaded && this.prefetch && threads == 0) {
                this.startThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(URL location) {
        List<Resource> list = this.resources;
        synchronized (list) {
            Resource resource = this.getResource(location);
            if (resource != null) {
                this.resources.remove(resource);
                resource.removeTracker(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCache(Resource resource, UpdatePolicy updatePolicy) {
        CacheEntry entry;
        if (!CacheUtil.isCacheable(resource.location, resource.downloadVersion)) {
            Resource resource2 = resource;
            synchronized (resource2) {
                resource.changeStatus(0, 164);
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy != UpdatePolicy.ALWAYS && updatePolicy != UpdatePolicy.FORCE && (entry = new CacheEntry(resource.location, resource.downloadVersion)).isCached() && !updatePolicy.shouldUpdate(entry)) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("not updating: " + resource.location);
            }
            Resource resource3 = resource;
            synchronized (resource3) {
                resource.localFile = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
                resource.size = resource.localFile.length();
                resource.transferred = resource.localFile.length();
                resource.changeStatus(0, 164);
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy == UpdatePolicy.FORCE) {
            resource.changeStatus(Integer.MAX_VALUE, 0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(DownloadListener listener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(DownloadListener listener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent(Resource resource) {
        int status;
        DownloadListener[] l = null;
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            l = this.listeners.toArray(new DownloadListener[0]);
        }
        Resource resource2 = resource;
        synchronized (resource2) {
            status = resource.status;
        }
        DownloadEvent event = new DownloadEvent(this, resource);
        for (DownloadListener dl : l) {
            if (0 != (0x60 & status)) {
                dl.downloadCompleted(event);
                continue;
            }
            if (0 != (0x10 & status)) {
                dl.downloadStarted(event);
                continue;
            }
            if (0 == (2 & status)) continue;
            dl.updateStarted(event);
        }
    }

    public URL getCacheURL(URL location) {
        block3: {
            try {
                File f = this.getCacheFile(location);
                if (f != null) {
                    return f.toURL();
                }
            }
            catch (MalformedURLException ex) {
                if (!JNLPRuntime.isDebug()) break block3;
                ex.printStackTrace();
            }
        }
        return location;
    }

    public File getCacheFile(URL location) {
        try {
            File file;
            Resource resource = this.getResource(location);
            if (!resource.isSet(96)) {
                this.waitForResource(location, 0L);
            }
            if (resource.isSet(64)) {
                return null;
            }
            if (resource.localFile != null) {
                return resource.localFile;
            }
            if (location.getProtocol().equalsIgnoreCase("file") && (file = UrlUtils.decodeUrlAsFile(location)).exists()) {
                return file;
            }
            return null;
        }
        catch (InterruptedException ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public InputStream getInputStream(URL location) throws IOException {
        try {
            Resource resource = this.getResource(location);
            if (!resource.isSet(96)) {
                this.waitForResource(location, 0L);
            }
            if (resource.localFile != null) {
                return new FileInputStream(resource.localFile);
            }
            return resource.location.openStream();
        }
        catch (InterruptedException ex) {
            throw new IOException("wait was interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForResources(URL[] urls, long timeout) throws InterruptedException {
        Resource[] resources;
        Resource[] resourceArray = resources = new Resource[urls.length];
        synchronized (resources) {
            for (int i = 0; i < urls.length; ++i) {
                resources[i] = this.getResource(urls[i]);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (resources.length > 0) {
                return this.wait(resources, timeout);
            }
            return true;
        }
    }

    public boolean waitForResource(URL location, long timeout) throws InterruptedException {
        return this.wait(new Resource[]{this.getResource(location)}, timeout);
    }

    public long getAmountRead(URL location) {
        return this.getResource((URL)location).transferred;
    }

    public boolean checkResource(URL location) {
        return this.getResource(location).isSet(96);
    }

    public boolean startResource(URL location) {
        Resource resource = this.getResource(location);
        return this.startResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startResource(Resource resource) {
        boolean enqueue = false;
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(64)) {
                return true;
            }
            boolean bl = enqueue = !resource.isSet(128);
            if (!resource.isSet(6)) {
                resource.changeStatus(0, 129);
            }
            if (!resource.isSet(48)) {
                resource.changeStatus(0, 136);
            }
            if (!resource.isSet(9)) {
                enqueue = false;
            }
        }
        if (enqueue) {
            this.queueResource(resource);
        }
        return !enqueue;
    }

    public long getTotalSize(URL location) {
        return this.getResource((URL)location).size;
    }

    protected void startThread() {
        if (threads < 5) {
            Thread thread = new Thread((Runnable)new Downloader(), "DownloaderThread" + ++threads);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endThread() {
        if (--threads < 0) {
            threads = 0;
            if (queue.size() > 0) {
                this.startThread();
            }
            throw new RuntimeException("tracker threads < 0");
        }
        if (threads == 0) {
            WeakList<ResourceTracker> weakList = prefetchTrackers;
            synchronized (weakList) {
                queue.trimToSize();
                active.clear();
                active.trimToSize();
                prefetchTrackers.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueResource(Resource resource) {
        Object object = lock;
        synchronized (object) {
            if (!resource.isSet(9)) {
                throw new IllegalResourceDescriptorException("Invalid resource state (resource: " + resource + ")");
            }
            queue.add(resource);
            this.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(Resource resource) {
        boolean doConnect = false;
        boolean doDownload = false;
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(2)) {
                doConnect = true;
            }
        }
        if (doConnect) {
            this.initializeResource(resource);
        }
        resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(8)) {
                this.queueResource(resource);
            }
            if (resource.isSet(16)) {
                doDownload = true;
            }
        }
        if (doDownload) {
            this.downloadResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource(Resource resource) {
        resource.fireDownloadEvent();
        CacheEntry origEntry = new CacheEntry(resource.location, resource.downloadVersion);
        origEntry.lock();
        try {
            URL realLocation = resource.getDownloadLocation();
            URLConnection con = realLocation.openConnection();
            con.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
            con.connect();
            URL downloadLocation = resource.location;
            String contentEncoding = con.getContentEncoding();
            if (JNLPRuntime.isDebug()) {
                System.err.println("Downloading" + resource.location + " using " + realLocation + " (encoding : " + contentEncoding + ")");
            }
            boolean packgz = "pack200-gzip".equals(contentEncoding) || realLocation.getPath().endsWith(".pack.gz");
            boolean gzip = "gzip".equals(contentEncoding);
            if (packgz) {
                downloadLocation = new URL(downloadLocation.toString() + ".pack.gz");
            } else if (gzip) {
                downloadLocation = new URL(downloadLocation.toString() + ".gz");
            }
            File downloadLocationFile = CacheUtil.getCacheFile(downloadLocation, resource.downloadVersion);
            CacheEntry downloadEntry = new CacheEntry(downloadLocation, resource.downloadVersion);
            File finalFile = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
            if (!downloadEntry.isCurrent(con)) {
                int rlen;
                byte[] buf = new byte[1024];
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                OutputStream out = CacheUtil.getOutputStream(downloadLocation, resource.downloadVersion);
                while (-1 != (rlen = ((InputStream)in).read(buf))) {
                    resource.transferred += (long)rlen;
                    out.write(buf, 0, rlen);
                }
                ((InputStream)in).close();
                out.close();
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                if (packgz) {
                    downloadEntry.initialize(con);
                    GZIPInputStream gzInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(downloadLocation, resource.downloadVersion)));
                    BufferedInputStream inputStream = new BufferedInputStream(gzInputStream);
                    JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(CacheUtil.getCacheFile(resource.location, resource.downloadVersion)));
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    unpacker.unpack((InputStream)inputStream, outputStream);
                    outputStream.close();
                    ((InputStream)inputStream).close();
                    gzInputStream.close();
                } else if (gzip) {
                    downloadEntry.initialize(con);
                    GZIPInputStream gzInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(downloadLocation, resource.downloadVersion)));
                    BufferedInputStream inputStream = new BufferedInputStream(gzInputStream);
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(CacheUtil.getCacheFile(resource.location, resource.downloadVersion)));
                    while (-1 != (rlen = ((InputStream)inputStream).read(buf))) {
                        outputStream.write(buf, 0, rlen);
                    }
                    outputStream.close();
                    ((InputStream)inputStream).close();
                    gzInputStream.close();
                }
            } else {
                resource.transferred = downloadLocationFile.length();
            }
            if (!downloadLocationFile.getPath().equals(finalFile.getPath())) {
                downloadEntry.markForDelete();
                downloadEntry.store();
            }
            resource.changeStatus(16, 32);
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            resource.changeStatus(0, 64);
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
        }
        finally {
            origEntry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeResource(Resource resource) {
        resource.fireDownloadEvent();
        CacheEntry entry = new CacheEntry(resource.location, resource.requestVersion);
        entry.lock();
        try {
            boolean current;
            File localFile = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
            URL finalLocation = this.findBestUrl(resource);
            if (finalLocation == null) {
                System.err.println("Attempted to download " + resource.location + ", but failed to connect!");
                throw new NullPointerException("finalLocation == null");
            }
            resource.setDownloadLocation(finalLocation);
            URLConnection connection = finalLocation.openConnection();
            connection.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
            int size = connection.getContentLength();
            boolean bl = current = CacheUtil.isCurrent(resource.location, resource.requestVersion, connection) && resource.getUpdatePolicy() != UpdatePolicy.FORCE;
            if (!current && entry.isCached()) {
                entry.markForDelete();
                entry.store();
                localFile = CacheUtil.makeNewCacheFile(resource.location, resource.downloadVersion);
                CacheEntry newEntry = new CacheEntry(resource.location, resource.requestVersion);
                newEntry.lock();
                entry.unlock();
                entry = newEntry;
            }
            Object object = resource;
            synchronized (object) {
                resource.localFile = localFile;
                resource.size = size;
                resource.changeStatus(3, 4);
                if (current) {
                    resource.changeStatus(24, 32);
                }
            }
            if (!current) {
                entry.initialize(connection);
            }
            entry.setLastUpdated(System.currentTimeMillis());
            entry.store();
            object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            resource.changeStatus(0, 64);
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
        }
        finally {
            entry.unlock();
        }
    }

    static int getUrlResponseCode(URL url, Map<String, String> requestProperties, String requestMethod) throws IOException {
        URLConnection connection = url.openConnection();
        for (Map.Entry<String, String> property : requestProperties.entrySet()) {
            connection.addRequestProperty(property.getKey(), property.getValue());
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod(requestMethod);
            int responseCode = httpConnection.getResponseCode();
            HttpUtils.consumeAndCloseConnectionSilently(httpConnection);
            return responseCode;
        }
        return 200;
    }

    URL findBestUrl(Resource resource) {
        DownloadOptions options = downloadOptions.get(resource);
        if (options == null) {
            options = new DownloadOptions(false, false);
        }
        List<URL> urls = new ResourceUrlCreator(resource, options).getUrls();
        if (JNLPRuntime.isDebug()) {
            System.err.println("All possible urls for " + resource.toString() + " : " + urls);
        }
        for (String requestMethod : requestMethods) {
            for (URL url : urls) {
                try {
                    HashMap<String, String> requestProperties = new HashMap<String, String>();
                    requestProperties.put("Accept-Encoding", "pack200-gzip, gzip");
                    int responseCode = ResourceTracker.getUrlResponseCode(url, requestProperties, requestMethod);
                    if (responseCode < 200 || responseCode >= 300) {
                        if (!JNLPRuntime.isDebug()) continue;
                        System.err.println("For " + resource.toString() + " the server returned " + responseCode + " code for " + requestMethod + " request for " + url.toExternalForm());
                        continue;
                    }
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("best url for " + resource.toString() + " is " + url.toString() + " by " + requestMethod);
                    }
                    return url;
                }
                catch (IOException e) {
                    if (!JNLPRuntime.isDebug()) continue;
                    System.err.println("While processing " + url.toString() + " by " + requestMethod + " for resource " + resource.toString() + " got " + e + ": ");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource selectNextResource() {
        Resource result = ResourceTracker.selectByFlag(queue, 1, 64);
        if (result == null) {
            result = ResourceTracker.selectByFlag(queue, 8, 67);
        }
        if (result != null) {
            queue.remove(result);
        }
        if (result == null && threads == 1) {
            result = ResourceTracker.getPrefetch();
        }
        if (result == null) {
            return null;
        }
        Resource resource = result;
        synchronized (resource) {
            if (result.isSet(1)) {
                result.changeStatus(1, 2);
            } else if (result.isSet(8)) {
                result.changeStatus(8, 16);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getPrefetch() {
        Resource result = null;
        Resource alternate = null;
        WeakList<ResourceTracker> weakList = prefetchTrackers;
        synchronized (weakList) {
            for (int i = 0; i < prefetchTrackers.size() && result == null; ++i) {
                ResourceTracker tracker = prefetchTrackers.get(i);
                if (tracker == null) continue;
                List<Resource> list = tracker.resources;
                synchronized (list) {
                    result = ResourceTracker.selectByFlag(tracker.resources, 0, 64);
                    if (result == null && alternate == null) {
                        alternate = ResourceTracker.selectByFlag(tracker.resources, 4, 120);
                    }
                    continue;
                }
            }
        }
        if (result == null) {
            result = alternate;
        }
        if (result == null) {
            return null;
        }
        weakList = result;
        synchronized (weakList) {
            ResourceTracker tracker = result.getTracker();
            if (tracker == null) {
                return null;
            }
            result.changeStatus(0, 128);
            tracker.startResource(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource selectByFlag(List<Resource> source, int flag, int notflag) {
        Resource result = null;
        int score = Integer.MAX_VALUE;
        for (Resource resource : source) {
            boolean selectable = false;
            Resource resource2 = resource;
            synchronized (resource2) {
                if (resource.isSet(flag) && !resource.isSet(notflag)) {
                    selectable = true;
                }
            }
            if (!selectable) continue;
            int activeCount = 0;
            for (ResourceTracker rt : active) {
                if (rt != resource.getTracker()) continue;
                ++activeCount;
            }
            if (activeCount >= score) continue;
            result = resource;
            score = activeCount;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(URL location) {
        List<Resource> list = this.resources;
        synchronized (list) {
            for (Resource resource : this.resources) {
                if (!CacheUtil.urlEquals(resource.location, location)) continue;
                return resource;
            }
        }
        throw new IllegalResourceDescriptorException("Location does not specify a resource being tracked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wait(Resource[] resources, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        for (Resource resource : resources) {
            this.startResource(resource);
        }
        while (true) {
            boolean finished = true;
            Object object = lock;
            synchronized (object) {
                Resource[] arr$ = resources;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Resource resource;
                    Resource resource2 = resource = arr$[i$];
                    synchronized (resource2) {
                        if (!resource.isSet(96)) {
                            finished = false;
                            break;
                        }
                        continue;
                    }
                }
                if (finished) {
                    return true;
                }
                long waitTime = 0L;
                if (timeout > 0L && (waitTime = timeout - (System.currentTimeMillis() - startTime)) <= 0L) {
                    return false;
                }
                lock.wait(waitTime);
            }
        }
    }

    private class Downloader
    implements Runnable {
        Resource resource = null;

        private Downloader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    if (this.resource != null) {
                        active.remove(this.resource.getTracker());
                    }
                    this.resource = ResourceTracker.selectNextResource();
                    if (this.resource == null) {
                        ResourceTracker.this.endThread();
                        break;
                    }
                    active.add(this.resource.getTracker());
                }
                try {
                    final Resource fResource = this.resource;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ResourceTracker.this.processResource(fResource);
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    if (!JNLPRuntime.isDebug()) continue;
                    ex.printStackTrace();
                }
            }
        }
    }
}

