/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;

public class JNLPSplashScreen
extends JDialog {
    ResourceTracker resourceTracker;
    URL splashImageUrl;
    Image splashImage;
    private final JNLPFile file;
    public static final int DEF_WIDTH = 635;
    public static final int DEF_HEIGHT = 480;
    private SplashPanel componetSplash;
    private boolean splashImageLoaded = false;

    public JNLPSplashScreen(ResourceTracker resourceTracker, JNLPFile file) {
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.resourceTracker = resourceTracker;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSplashImageURL(URL url) {
        this.splashImageLoaded = false;
        try {
            if (url != null) {
                this.splashImageUrl = url;
                this.splashImage = null;
                try {
                    this.splashImage = ImageIO.read(this.resourceTracker.getCacheFile(this.splashImageUrl));
                    if (this.splashImage == null && JNLPRuntime.isDebug()) {
                        System.err.println("Error loading splash image: " + url);
                    }
                }
                catch (IOException e) {
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Error loading splash image: " + url);
                    }
                    this.splashImage = null;
                }
                catch (IllegalArgumentException argumentException) {
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Error loading splash image: " + url);
                    }
                    this.splashImage = null;
                }
            }
            if (this.splashImage == null) {
                this.setLayout(new BorderLayout());
                SplashPanel splash = SplashUtils.getSplashScreen(635, 480);
                if (splash != null) {
                    splash.startAnimation();
                    splash.setInformationElement(InformationElement.createFromJNLP(this.file));
                    this.add(splash.getSplashComponent());
                    this.componetSplash = splash;
                }
            }
            this.correctSize();
        }
        finally {
            this.splashImageLoaded = true;
        }
    }

    public boolean isSplashImageLoaded() {
        return this.splashImageLoaded;
    }

    public boolean isSplashScreenValid() {
        return this.splashImage != null || this.componetSplash != null;
    }

    private void correctSize() {
        int minimumWidth = 635;
        int minimumHeight = 480;
        if (this.splashImage != null) {
            Insets insets = this.getInsets();
            minimumWidth = this.splashImage.getWidth(null) + insets.left + insets.right;
            minimumHeight = this.splashImage.getHeight(null) + insets.top + insets.bottom;
        }
        this.setMinimumSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setSize(new Dimension(minimumWidth, minimumHeight));
        this.setPreferredSize(new Dimension(minimumWidth, minimumHeight));
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.splashImage == null) {
            super.paint(g);
            return;
        }
        this.correctSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.splashImage, this.getInsets().left, this.getInsets().top, null);
    }

    public boolean isCustomSplashscreen() {
        return this.componetSplash != null;
    }

    public void stopAnimation() {
        if (this.isCustomSplashscreen()) {
            this.componetSplash.stopAnimation();
        }
    }
}

