/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;

public class JNLPFile {
    protected URL sourceLocation = null;
    protected URL fileLocation;
    protected String uniqueKey = null;
    protected URL codeBase;
    protected Version fileVersion;
    protected Version specVersion;
    protected List<InformationDesc> info;
    protected UpdateDesc update;
    protected List<ResourcesDesc> resources;
    protected ResourcesDesc sharedResources = new ResourcesDesc(this, null, null, null);
    protected LaunchDesc launchType;
    protected ComponentDesc component;
    protected SecurityDesc security;
    protected Locale defaultLocale = null;
    protected String defaultOS = null;
    protected String defaultArch = null;
    private boolean missingSignedJNLP = false;
    private boolean containsSpecialProperties = false;
    private String[] generalProperties = SecurityDesc.getJnlpRIAPermissions();

    protected JNLPFile() {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public JNLPFile(URL location) throws IOException, ParseException {
        this(location, false);
    }

    public JNLPFile(URL location, boolean strict) throws IOException, ParseException {
        this(location, (Version)null, strict);
    }

    public JNLPFile(URL location, Version version, boolean strict) throws IOException, ParseException {
        this(location, version, strict, JNLPRuntime.getDefaultUpdatePolicy());
    }

    public JNLPFile(URL location, Version version, boolean strict, UpdatePolicy policy) throws IOException, ParseException {
        this(location, version, strict, policy, null);
    }

    protected JNLPFile(URL location, Version version, boolean strict, UpdatePolicy policy, URL forceCodebase) throws IOException, ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        Node root = Parser.getRootNode(JNLPFile.openURL(location, version, policy));
        this.parse(root, strict, location, forceCodebase);
        if (this.sourceLocation != null && "file".equals(location.getProtocol())) {
            JNLPFile.openURL(this.sourceLocation, version, policy);
        }
        this.fileLocation = location;
        this.uniqueKey = Calendar.getInstance().getTimeInMillis() + "-" + (int)(Math.random() * 2.147483647E9) + "-" + location;
        if (JNLPRuntime.isDebug()) {
            System.err.println("UNIQUEKEY=" + this.uniqueKey);
        }
    }

    public JNLPFile(URL location, String uniqueKey, Version version, boolean strict, UpdatePolicy policy) throws IOException, ParseException {
        this(location, version, strict, policy);
        this.uniqueKey = uniqueKey;
        if (JNLPRuntime.isDebug()) {
            System.err.println("UNIQUEKEY (override) =" + this.uniqueKey);
        }
    }

    public JNLPFile(InputStream input, boolean strict) throws ParseException {
        this(input, null, strict);
    }

    public JNLPFile(InputStream input, URL codebase, boolean strict) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        this.parse(Parser.getRootNode(input), strict, null, codebase);
    }

    private JNLPFile(Reader input, boolean strict) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static InputStream openURL(URL location, Version version, UpdatePolicy policy) throws IOException {
        if (location == null || policy == null) {
            throw new IllegalArgumentException(Translator.R("NullParameter"));
        }
        try {
            ResourceTracker tracker = new ResourceTracker(false);
            tracker.addResource(location, version, null, policy);
            return tracker.getInputStream(location);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public String getTitle() {
        return this.getInformation().getTitle();
    }

    public String getVendor() {
        return this.getInformation().getVendor();
    }

    public URL getSourceLocation() {
        return this.sourceLocation;
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Version getFileVersion() {
        return this.fileVersion;
    }

    public Version getSpecVersion() {
        return this.specVersion;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public InformationDesc getInformation() {
        return this.getInformation(this.defaultLocale);
    }

    public InformationDesc getInformation(final Locale locale) {
        return new InformationDesc(this, new Locale[]{locale}){

            @Override
            protected List<Object> getItems(Object key) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision)) continue;
                        result.addAll(infoDesc.getItems(key));
                    }
                    if (result.size() <= 0) continue;
                    return result;
                }
                return result;
            }

            @Override
            public String getTitle() {
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        String title = infoDesc.getTitle();
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision) || title == null || "".equals(title)) continue;
                        return title;
                    }
                }
                return null;
            }

            @Override
            public String getVendor() {
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        String vendor = infoDesc.getVendor();
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision) || vendor == null || "".equals(vendor)) continue;
                        return vendor;
                    }
                }
                return null;
            }
        };
    }

    public UpdateDesc getUpdate() {
        return this.update;
    }

    public SecurityDesc getSecurity() {
        return this.security;
    }

    public ResourcesDesc getResources() {
        return this.getResources(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc getResources(final Locale locale, final String os, final String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                ArrayList<T> result = new ArrayList<T>();
                for (ResourcesDesc rescDesc : JNLPFile.this.resources) {
                    boolean hasUsableLocale = false;
                    for (Match match : Match.values()) {
                        hasUsableLocale |= JNLPFile.this.localeMatches(locale, rescDesc.getLocales(), match);
                    }
                    if (!hasUsableLocale || !JNLPFile.this.stringMatches(os, rescDesc.getOS()) || !JNLPFile.this.stringMatches(arch, rescDesc.getArch())) continue;
                    result.addAll(rescDesc.getResources(launchType));
                }
                result.addAll(JNLPFile.this.sharedResources.getResources(launchType));
                return result;
            }

            @Override
            public void addResource(Object resource) {
                JNLPFile.this.sharedResources.addResource(resource);
            }
        };
    }

    public ResourcesDesc[] getResourcesDescs() {
        return this.getResourcesDescs(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc[] getResourcesDescs(Locale locale, String os, String arch) {
        ArrayList<ResourcesDesc> matchingResources = new ArrayList<ResourcesDesc>();
        for (ResourcesDesc rescDesc : this.resources) {
            boolean hasUsableLocale = false;
            for (Match match : Match.values()) {
                hasUsableLocale |= this.localeMatches(locale, rescDesc.getLocales(), match);
            }
            if (!hasUsableLocale || !this.stringMatches(os, rescDesc.getOS()) || !this.stringMatches(arch, rescDesc.getArch())) continue;
            matchingResources.add(rescDesc);
        }
        return matchingResources.toArray(new ResourcesDesc[0]);
    }

    public LaunchDesc getLaunchInfo() {
        return this.launchType;
    }

    public AppletDesc getApplet() {
        if (!this.isApplet()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplet"));
        }
        return (AppletDesc)this.launchType;
    }

    public ApplicationDesc getApplication() {
        if (!this.isApplication()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplication"));
        }
        return (ApplicationDesc)this.launchType;
    }

    public ComponentDesc getComponent() {
        if (!this.isComponent()) {
            throw new UnsupportedOperationException(Translator.R("JNotComponent"));
        }
        return this.component;
    }

    public InstallerDesc getInstaller() {
        if (!this.isInstaller()) {
            throw new UnsupportedOperationException(Translator.R("NotInstaller"));
        }
        return (InstallerDesc)this.launchType;
    }

    public boolean isApplet() {
        return this.launchType instanceof AppletDesc;
    }

    public boolean isApplication() {
        return this.launchType instanceof ApplicationDesc;
    }

    public boolean isComponent() {
        return this.component != null;
    }

    public boolean isInstaller() {
        return this.launchType instanceof InstallerDesc;
    }

    public void setDefaults(String os, String arch, Locale locale) {
        this.defaultOS = os;
        this.defaultArch = arch;
        this.defaultLocale = locale;
    }

    public boolean localeMatches(Locale requested, Locale[] available, Match matchLevel) {
        if (matchLevel == Match.GENERALIZED) {
            return available == null || available.length == 0;
        }
        String language = requested.getLanguage();
        String country = requested.getCountry();
        String variant = requested.getVariant();
        block5: for (Locale locale : available) {
            switch (matchLevel) {
                case LANG: {
                    if (language.isEmpty() || !language.equals(locale.getLanguage()) || !locale.getCountry().isEmpty() || !locale.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY: {
                    if (language.isEmpty() || !language.equals(locale.getLanguage()) || country.isEmpty() || !country.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY_VARIANT: {
                    if (!language.equals(locale.getLanguage()) || !country.equals(locale.getCountry()) || !variant.equals(locale.getVariant())) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean stringMatches(String prefixStr, String[] available) {
        if (available == null || available.length == 0) {
            return true;
        }
        for (int i = 0; i < available.length; ++i) {
            if (available[i] == null || !available[i].startsWith(prefixStr)) continue;
            return true;
        }
        return false;
    }

    private void parse(Node root, boolean strict, URL location, URL forceCodebase) throws ParseException {
        try {
            Parser parser = new Parser(this, location, root, strict, true, forceCodebase);
            this.specVersion = parser.getSpecVersion();
            this.fileVersion = parser.getFileVersion();
            this.codeBase = parser.getCodeBase();
            this.sourceLocation = parser.getFileLocation() != null ? parser.getFileLocation() : location;
            this.info = parser.getInfo(root);
            parser.checkForInformation();
            this.update = parser.getUpdate(root);
            this.resources = parser.getResources(root, false);
            this.launchType = parser.getLauncher(root);
            this.component = parser.getComponent(root);
            this.security = parser.getSecurity(root);
            this.checkForSpecialProperties();
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            throw new RuntimeException(ex.toString());
        }
    }

    private void checkForSpecialProperties() {
        for (ResourcesDesc res : this.resources) {
            for (PropertyDesc propertyDesc : res.getProperties()) {
                String property;
                for (int i = 0; i < this.generalProperties.length && !(property = propertyDesc.getKey()).equals(this.generalProperties[i]); ++i) {
                    if (property.equals(this.generalProperties[i]) || i != this.generalProperties.length - 1) continue;
                    this.containsSpecialProperties = true;
                    return;
                }
            }
        }
    }

    public boolean needsNewVM() {
        return this.getNewVMArgs().size() != 0;
    }

    public List<String> getNewVMArgs() {
        LinkedList<String> newVMArgs = new LinkedList<String>();
        JREDesc[] jres = this.getResources().getJREs();
        for (int jreIndex = 0; jreIndex < jres.length; ++jreIndex) {
            String vmArgsFromJre;
            String maxHeapSize;
            String initialHeapSize = jres[jreIndex].getInitialHeapSize();
            if (initialHeapSize != null) {
                newVMArgs.add("-Xms" + initialHeapSize);
            }
            if ((maxHeapSize = jres[jreIndex].getMaximumHeapSize()) != null) {
                newVMArgs.add("-Xmx" + maxHeapSize);
            }
            if ((vmArgsFromJre = jres[jreIndex].getVMArgs()) == null) continue;
            String[] args = vmArgsFromJre.split(" ");
            newVMArgs.addAll(Arrays.asList(args));
        }
        return newVMArgs;
    }

    public DownloadOptions getDownloadOptions() {
        boolean usePack = false;
        boolean useVersion = false;
        ResourcesDesc desc = this.getResources();
        if (Boolean.valueOf(desc.getPropertiesMap().get("jnlp.packEnabled")).booleanValue()) {
            usePack = true;
        }
        if (Boolean.valueOf(desc.getPropertiesMap().get("jnlp.versionEnabled")).booleanValue()) {
            useVersion = true;
        }
        return new DownloadOptions(usePack, useVersion);
    }

    public boolean requiresSignedJNLPWarning() {
        return this.missingSignedJNLP && this.containsSpecialProperties;
    }

    public void setSignedJNLPAsMissing() {
        this.missingSignedJNLP = true;
    }

    static enum Match {
        LANG_COUNTRY_VARIANT,
        LANG_COUNTRY,
        LANG,
        GENERALIZED;

    }
}

