/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginStreamHandler;

class PluginMessageHandlerWorker
extends Thread {
    private boolean free = true;
    private final boolean isPriorityWorker;
    private final int id;
    private volatile String message;
    private PluginStreamHandler streamHandler;
    private PluginMessageConsumer consumer;

    public synchronized void notifyHasWork() {
        this.notifyAll();
    }

    public synchronized void waitForWork() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public PluginMessageHandlerWorker(PluginMessageConsumer consumer, PluginStreamHandler streamHandler, int id, boolean isPriorityWorker) {
        super("PluginMessageHandlerWorker" + id);
        this.id = id;
        this.streamHandler = streamHandler;
        this.isPriorityWorker = isPriorityWorker;
        this.consumer = consumer;
        PluginDebug.debug("Worker ", this.id, " (priority=", isPriorityWorker, ") created.");
    }

    public void setmessage(String message) {
        this.message = message;
    }

    @Override
    public void run() {
        while (true) {
            if (this.message != null) {
                PluginDebug.debug("Consumer (priority=", this.isPriorityWorker, ") thread ", this.id, " consuming ", this.message);
                this.busy();
                try {
                    this.streamHandler.handleMessage(this.message);
                }
                catch (PluginException pluginException) {
                    // empty catch block
                }
                this.message = null;
                PluginDebug.debug("Consumption (priority=", this.isPriorityWorker, ") completed by consumer thread ", this.id);
                this.free();
                continue;
            }
            this.waitForWork();
            PluginDebug.debug("Consumer thread ", this.id, " woken...");
        }
    }

    public int getWorkerId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = true;
        }
    }

    public boolean isPriority() {
        return this.isPriorityWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFree(boolean prioritized) {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            return this.free && prioritized == this.isPriorityWorker;
        }
    }

    @Override
    public String toString() {
        return "Worker #" + this.id + "/IsPriority=" + this.isPriorityWorker + "/IsFree=" + this.free + "/Message=" + this.message;
    }
}

